/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.Iocard;
import org.lsst.ccs.drivers.iocard.IocardException;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestHelios1 {
    private static final int BASE_ADDR = 640;
    private static final int IRQ_LEVEL = 5;
    private static final int N_REGS = 16;
    private static final int PAGE_REG = 1;
    private static final Output out = new ConsOut();
    private Iocard ioc = new Iocard();

    public static void main(String[] args) {
        TestHelios1 test = new TestHelios1();
        test.run();
        System.exit(0);
    }

    public void run() {
        int reg;
        this.ioc.init(640, 16, 5);
        out.println((Object)"Register values (bytes):");
        int reg2 = 0;
        while (reg2 < 12) {
            out.format(" %02x", new Object[]{this.ioc.readB(reg2)});
            ++reg2;
        }
        int page = 0;
        while (page < 3) {
            this.ioc.writeB(1, page);
            if (page != 0) {
                out.format("%36s", new Object[]{""});
            }
            reg = 12;
            while (reg < 16) {
                out.format(" %02x", new Object[]{this.ioc.readB(reg)});
                ++reg;
            }
            out.println();
            ++page;
        }
        out.println((Object)"Register values (shorts):");
        reg2 = 0;
        while (reg2 < 12) {
            out.format(" %04x", new Object[]{this.ioc.readW(reg2)});
            reg2 += 2;
        }
        page = 0;
        while (page < 3) {
            this.ioc.writeB(1, page);
            if (page != 0) {
                out.format("%30s", new Object[]{""});
            }
            reg = 12;
            while (reg < 16) {
                out.format(" %04x", new Object[]{this.ioc.readW(reg)});
                reg += 2;
            }
            out.println();
            ++page;
        }
        out.println((Object)"Register values (ints):");
        reg2 = 0;
        while (reg2 < 12) {
            out.format(" %08x", new Object[]{this.ioc.readL(reg2)});
            reg2 += 4;
        }
        page = 0;
        while (page < 3) {
            this.ioc.writeB(1, page);
            if (page != 0) {
                out.format("%27s", new Object[]{""});
            }
            reg = 12;
            while (reg < 16) {
                out.format(" %08x", new Object[]{this.ioc.readL(reg)});
                reg += 4;
            }
            out.println();
            ++page;
        }
        reg2 = -1;
        try {
            this.ioc.readB(reg2);
        }
        catch (IocardException e) {
            out.format("%s reading byte at offset %s\n", new Object[]{e, reg2});
        }
        reg2 = 16;
        try {
            this.ioc.readB(reg2);
        }
        catch (IocardException e) {
            out.format("%s reading byte at offset %s\n", new Object[]{e, reg2});
        }
        reg2 = 15;
        try {
            this.ioc.readW(reg2);
        }
        catch (IocardException e) {
            out.format("%s reading short integer at offset %s\n", new Object[]{e, reg2});
        }
        reg2 = 13;
        try {
            this.ioc.readL(reg2);
        }
        catch (IocardException e) {
            out.format("%s reading integer at offset %s\n", new Object[]{e, reg2});
        }
        this.ioc.term();
    }
}

