/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.AccesDio;
import org.lsst.ccs.drivers.iocard.TestIocard;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAccesDio
implements CmndProcess.Dispatch {
    private static final int CMD_INIT = 0;
    private static final int CMD_DIOCONF = 1;
    private static final int CMD_DIOIN = 2;
    private static final int CMD_DIOOUT = 3;
    private static final int CMD_DIOINBIT = 4;
    private static final int CMD_DIOOUTBIT = 5;
    private static final int CMD_DIOSETBIT = 6;
    private static final int CMD_DIOCLRBIT = 7;
    private static final int CMD_DIOSHOW = 8;
    private static final int CMD_INTATTACH = 9;
    private static final int CMD_INTDETACH = 10;
    private static final int CMD_INTSTART = 11;
    private static final int CMD_INTSTOP = 12;
    private static final int CMD_INTSHOW = 13;
    private static final int CMD_SHOW = 14;
    private static final int CMD_REGSHOW = 15;
    private static final int NUM_CMDS = 16;
    private static final String[] helpInit = new String[]{"Initialize Acces DIO card", "init <addr> <irq>", "addr   The base address of the card (initially 0x340)", "irq    The IRQ level of the card (initially 6)"};
    private static final String[] helpShow = new String[]{"Show initialization parameters", "show"};
    private static final String[] helpRegshow = new String[]{"Show register contents", "regshow"};
    private static final String[] helpDioconf = new String[]{"Set digital I/O parameters", "dioconf <value>", "value    The value to set"};
    private static final String[] helpDioin = new String[]{"Read and display a byte from a digital I/O port", "dioin <port>", "port    The digital I/O port to read"};
    private static final String[] helpDioout = new String[]{"Write a byte to a digital I/O port", "dioout <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDioinbit = new String[]{"Read and display a bit from a digital I/O port", "dioinbit <port> <bitnum>", "port    The digital I/O port to read", "bitnum  The number of the bit to read"};
    private static final String[] helpDiooutbit = new String[]{"Write a bit to a digital I/O port", "diooutbit <port> <bitnum> <value>", "port    The digital I/O port to write to", "bitnum  The number of the bit to write", "value   The value to set the bit to"};
    private static final String[] helpDiosetbit = new String[]{"Set a bit in a digital I/O port", "diosetbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to set"};
    private static final String[] helpDioclrbit = new String[]{"Clear a bit in a digital I/O port", "dioclrbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to clear"};
    private static final String[] helpDioshow = new String[]{"Show the current digital I/O parameters", "dioshow"};
    private static final String[] helpIntattach = new String[]{"Attach to interrupt processing", "intattach <pmask>", "pmask  A bit mask of the ports (0 - 2) to trigger interrupts"};
    private static final String[] helpIntdetach = new String[]{"Detach from interrupt processing", "intdetach"};
    private static final String[] helpIntstart = new String[]{"Start generating interrupts", "intstart <port> <rate>", "port  The port to use for generating interrupts", "rate  The rate of interrupt generation (number / second)"};
    private static final String[] helpIntstop = new String[]{"Stop generating interrupts", "intstop"};
    private static final String[] helpIntshow = new String[]{"Show generated interrupt statistics", "intshow"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(16);
    private static final int BASE_ADDR = 832;
    private static final int IRQ_LEVEL = 6;
    private final Output out;
    private final AccesDio acc;
    private final CmndProcess proc;
    private final TestIocard tioc;
    private int baseAddr = 832;
    private int irqLevel = 6;
    private int dioPort = 0;
    private int dioConf = 0;
    private int dioValue = 0;
    private int dioBit = 0;
    private int intPort = 0;
    private int intMask = 7;
    private float intRate = 1.0f;
    private static final String[] regDesc;

    static {
        cmnd.add("init", 0, helpInit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("show", 14, helpShow, "", new CmndProcess.Lookup[0]);
        cmnd.add("regshow", 15, helpRegshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("dioconf", 1, helpDioconf, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioin", 2, helpDioin, "i", new CmndProcess.Lookup[0]);
        cmnd.add("dioout", 3, helpDioout, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbit", 4, helpDioinbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbit", 5, helpDiooutbit, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("diosetbit", 6, helpDiosetbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioclrbit", 7, helpDioclrbit, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dioshow", 8, helpDioshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("intattach", 9, helpIntattach, "i", new CmndProcess.Lookup[0]);
        cmnd.add("intdetach", 10, helpIntdetach, "", new CmndProcess.Lookup[0]);
        cmnd.add("intstart", 11, helpIntstart, "if", new CmndProcess.Lookup[0]);
        cmnd.add("intstop", 12, helpIntstop, "", new CmndProcess.Lookup[0]);
        cmnd.add("intshow", 13, helpIntshow, "", new CmndProcess.Lookup[0]);
        regDesc = new String[]{"|G0 A7 |G0 A6 |G0 A5 |G0 A4 |G0 A3 |G0 A2 |G0 A1 |G0 A0 |", "|G0 B7 |G0 B6 |G0 B5 |G0 B4 |G0 B3 |G0 B2 |G0 B1 |G0 B0 |", "|G0 C7 |G0 C6 |G0 C5 |G0 C4 |G0 C3 |G0 C2 |G0 C1 |G0 C0 |", "|                G0 Control (Write only)                |", "|G1 A7 |G1 A6 |G1 A5 |G1 A4 |G1 A3 |G1 A2 |G1 A1 |G1 A0 |", "|G1 B7 |G1 B6 |G1 B5 |G1 B4 |G1 B3 |G1 B2 |G1 B1 |G1 B0 |", "|G1 C7 |G1 C6 |G1 C5 |G1 C4 |G1 C3 |G1 C2 |G1 C1 |G1 C0 |", "|                G1 Control (Write only)                |", "|         G0 Enable/Disable Buffer (Write only)         |", "|         G1 Enable/Disable Buffer (Write only)         |", "|  -   |  -   |  -   |  -   |  -   |  -   |G1 TEN|G0 TEN|", "|  -   |G1 IDC|G1 IDB|G1 IDA|  -   |G0 IDC|G0 IDB|G0 IDA|", "|  -   |  -   |  -   |G0 EA |G0 ECH|  -   |G0 EB |G0 ECL|", "|  -   |  -   |  -   |G1 EA |G1 ECH|  -   |G1 EB |G1 ECL|", "|                       Not Used                        |", "|G1 ICH|G1 ICL|G1 IB |G1 IA |G0 ICH|G0 DCL|G0 IB |G0 IA |", "|                    Counter/Timer 0                    |", "|                    Counter/Timer 1                    |", "|                    Counter/Timer 2                    |", "|            Counter/Timer Mode (Write only)            |", "|                Counter/Timer Interrupt                |", "|               Counter/Timer IRQ Status                |", "|             Counter/Timer Interrupt Clear             |", "|                       Not Used                        |", "|G1 ICH|G1 ICL|G1 IB |G1 IA |G0 ICH|G0 DCL|G0 IB |G0 IA |"};
    }

    TestAccesDio(Output out) {
        this.out = out != null ? out : new ConsOut();
        this.acc = new AccesDio();
        this.proc = new CmndProcess();
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        this.tioc = new TestIocard(this.acc, this.proc, this.out);
    }

    TestAccesDio() {
        this(null);
    }

    public static void main(String[] args) {
        new TestAccesDio().tioc.run();
        System.exit(0);
    }

    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 0: {
                this.procInit(found, args);
                break;
            }
            case 14: {
                this.procShow(found, args);
                break;
            }
            case 15: {
                this.procRegshow(found, args);
                break;
            }
            case 1: {
                this.procDioconf(found, args);
                break;
            }
            case 2: {
                this.procDioin(found, args);
                break;
            }
            case 3: {
                this.procDioout(found, args);
                break;
            }
            case 4: {
                this.procDioinbit(found, args);
                break;
            }
            case 5: {
                this.procDiooutbit(found, args);
                break;
            }
            case 6: {
                this.procDiosetbit(found, args);
                break;
            }
            case 7: {
                this.procDioclrbit(found, args);
                break;
            }
            case 8: {
                this.procDioshow(found, args);
                break;
            }
            case 9: {
                this.procIntattach(found, args);
                break;
            }
            case 10: {
                this.procIntdetach(found, args);
                break;
            }
            case 11: {
                this.procIntstart(found, args);
                break;
            }
            case 12: {
                this.procIntstop(found, args);
                break;
            }
            case 13: {
                this.procIntshow(found, args);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void procInit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.baseAddr = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.irqLevel = (Integer)args[1];
        }
        this.acc.init(this.baseAddr, this.irqLevel);
    }

    private void procShow(int found, Object[] args) {
        this.out.println((Object)"Initialization parameters:");
        this.out.format("  Base address     = %04x\n", new Object[]{this.baseAddr});
        this.out.format("  Card size        = %04x\n", new Object[]{25});
        this.out.println((Object)("  IRQ level        = " + this.irqLevel));
    }

    private void procRegshow(int found, Object[] args) {
        int r = 0;
        while (r < 25) {
            this.out.format("  %2s: %02x  %s\n", new Object[]{r, this.acc.readB(r), regDesc[r]});
            ++r;
        }
    }

    private void procDioconf(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioConf = (Integer)args[0];
        }
        this.acc.dioConfig(this.dioConf);
    }

    private void procDioin(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        int value = this.acc.dioInp(this.dioPort);
        this.out.format("Value = 0x%02x\n", new Object[]{value});
    }

    private void procDioout(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioValue = (Integer)args[1];
        }
        this.acc.dioOut(this.dioPort, this.dioValue);
    }

    private void procDioinbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        int value = this.acc.dioInpBit(this.dioPort, this.dioBit);
        this.out.println((Object)("Value = " + value));
    }

    private void procDiooutbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        if ((found & 4) != 0) {
            this.dioValue = (Integer)args[2];
        }
        this.acc.dioOutBit(this.dioPort, this.dioBit, this.dioValue);
    }

    private void procDiosetbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.acc.dioSetBit(this.dioPort, this.dioBit);
    }

    private void procDioclrbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Integer)args[1];
        }
        this.acc.dioClrBit(this.dioPort, this.dioBit);
    }

    private void procDioshow(int found, Object[] args) {
        this.out.println((Object)"Digital I/O parameters:");
        this.out.format("  Configuration = %02x\n", new Object[]{this.dioConf});
        this.out.println((Object)("  Port          = " + this.dioPort));
        this.out.format("  Output value  = %02x\n", new Object[]{this.dioValue});
        this.out.println((Object)("  Bit number    = " + this.dioBit));
    }

    private void procIntattach(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.intMask = (Integer)args[0];
        }
        this.acc.attachInt(this.intMask, this, "reportInt", this.acc);
    }

    private void procIntdetach(int found, Object[] args) {
        this.acc.detachInt();
    }

    private void procIntstart(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.intPort = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.intRate = ((Float)args[1]).floatValue();
        }
    }

    private void procIntstop(int found, Object[] args) {
    }

    private void procIntshow(int found, Object[] args) {
    }

    private void reportInt(int value, Object parm) {
        AccesDio dio = (AccesDio)parm;
        this.out.format("Flags = %02x, DIO lines = %06x\n", new Object[]{value, dio.readL(0) & 0xFFFFFF});
    }
}

