/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.Iocard;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAcces2 {
    private static final int BASE_ADDR = 832;
    private static final int IRQ_LEVEL = 6;
    private static final int N_REGS = 25;
    private static final int PORTA_REG = 0;
    private static final int PORTB_REG = 1;
    private static final int PORTC_REG = 2;
    private static final int CONF_REG = 3;
    private static final int SETUP_REG = 11;
    private static final int STATE_REG = 15;
    private static final int RESET_REG = 24;
    private static final Output out = new ConsOut();
    private Iocard ioc = new Iocard();

    public static void main(String[] args) {
        TestAcces2 test = new TestAcces2();
        int intvl = 100;
        if (args.length >= 1) {
            intvl = Integer.valueOf(args[0]);
        }
        test.run(intvl, args.length > 1);
        System.exit(0);
    }

    public void run(int intvl, boolean rev) {
        this.ioc.init(832, 25, 6);
        this.ioc.writeB(3, 128);
        this.testIntr(0, 9, intvl, rev);
        this.testIntr(8, 9, intvl, rev);
        this.testIntr(16, 9, intvl, rev);
        this.testIntr(24, 9, intvl, rev);
        this.ioc.term();
    }

    void testIntr(int first, int count, int intvl, boolean rev) {
        this.ioc.attachInt(0, 1, 24, 15, 24, 0, 0, this, "procIntr", rev);
        this.ioc.writeB(11, rev ? 3 : 5);
        int j = first;
        while (j < first + count) {
            this.ioc.writeB(rev ? 2 : 1, j);
            try {
                Thread.sleep(intvl);
            }
            catch (InterruptedException interruptedException) {}
            ++j;
        }
        this.ioc.writeB(11, 7);
        this.ioc.detachInt(0);
    }

    void procIntr(int value, Object parm) {
        boolean rev = (Boolean)parm;
        out.format("Flag = %02x, Data = %02x\n", new Object[]{value, this.ioc.readB(rev ? 2 : 1)});
    }
}

