package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;


/**
 **************************************************************************
 **
 **  \file testAcces1.java
 **
 **  Program to test the Acces DIO card's basic capabilities
 **
 **  \author Owen H Saxton
 **
 **************************************************************************
 */
public class TestAcces1 {

    private final static int
        BASE_ADDR = 0x340,
        IRQ_LEVEL = 6,
        N_REGS    = 25;

    private final static Output out = new ConsOut();

    private Iocard ioc = new Iocard();


   /**
    ***************************************************************************
    **
    **  Main program
    **
    ***************************************************************************
    */
    public static void main(String[] args)
    {
        TestAcces1 test = new TestAcces1();
        test.run();
        System.exit(0);
    }


   /**
    ***************************************************************************
    **
    **  Run the test
    **
    ***************************************************************************
    */
    public void run()
    {
        /*
        **  Initialize
        */
        ioc.init(BASE_ADDR, N_REGS, IRQ_LEVEL);

        /*
        **  Read and display the registers as bytes
        */
        out.println("Register values (bytes):");
        for (int reg = 0; reg < N_REGS; reg++)
            out.format(" %02x", ioc.readB(reg));
        out.println();

        /*
        **  Terminate
        */
        ioc.term();
    }
}
