/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import java.io.IOException;
import java.util.Scanner;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.iocard.Iocard;
import org.lsst.ccs.drivers.iocard.IocardException;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestIocard
implements CmndProc.Dispatch {
    private static final int CMD_INIT = 0;
    private static final int CMD_TERM = 1;
    private static final int CMD_SHOW = 2;
    private static final int CMD_READB = 3;
    private static final int CMD_READW = 4;
    private static final int CMD_READL = 5;
    private static final int CMD_WRITEB = 6;
    private static final int CMD_WRITEW = 7;
    private static final int CMD_WRITEL = 8;
    private static final int CMD_UPDATEB = 9;
    private static final int CMD_UPDATEW = 10;
    private static final int CMD_UPDATEL = 11;
    private static final int CMD_REGSHOW = 12;
    private static final int CMD_INTATTACH = 13;
    private static final int CMD_INTDETACH = 14;
    private static final int CMD_INTSHOW = 15;
    private static final int CMD_TIMEREAD = 16;
    private static final int NUM_CMDS = 17;
    private static final String[] helpInit = new String[]{"Initialize access to an I/O card", "init <address> <size> <irq>", "address    The address of the I/O card", "size       The number of bytes used by the card's registers", "irq        The IRQ level to use for interrupts"};
    private static final String[] helpTerm = new String[]{"Terminate card access", "term"};
    private static final String[] helpShow = new String[]{"Show the current card initialization parameters", "show"};
    private static final String[] helpReadb = new String[]{"Read and display a byte from the card", "read <offset>", "offset  The offset from which to read a byte"};
    private static final String[] helpReadw = new String[]{"Read and display a 16-bit word from the card", "readw <offset>", "offset  The offset from which to read a 16-bit word"};
    private static final String[] helpReadl = new String[]{"Read and display a 32-bit word from the card", "readl <offset>", "offset  The offset from which to read a 32-bit integer"};
    private static final String[] helpWriteb = new String[]{"Write a byte to the card", "write <offset> <value>", "offset  The offset at which to write a byte", "value   The value to write"};
    private static final String[] helpWritew = new String[]{"Write a 16-bit word to the card", "writew <offset> <value>", "offset  The offset at which to write a 16-bit word", "value   The value to write"};
    private static final String[] helpWritel = new String[]{"Write a 32-bit word to the card", "writel <offset> <value>", "offset  The offset at which to write a 32-bit integer", "value   The value to write"};
    private static final String[] helpUpdateb = new String[]{"Update a byte on the card", "update <offset> <mask> <value>", "offset  The offset at which to update a byte", "mask    The mask of bits to update", "value   The value to write"};
    private static final String[] helpUpdatew = new String[]{"Update a 16-bit word to the card", "updatew <offset> <mask> <value>", "offset  The offset at which to update a 16-bit word", "mask    The mask of bits to update", "value   The value to write"};
    private static final String[] helpUpdatel = new String[]{"Update a 32-bit word to the card", "updatel <offset> <mask> <value>", "offset  The offset at which to update a 32-bit integer", "mask    The mask of bits to update", "value   The value to write"};
    private static final String[] helpRegshow = new String[]{"Read and display the card's registers", "regshow"};
    private static final String[] helpIntAttach = new String[]{"Attach to interrupt processing", "intattach <optns> <cMask> <cValue> <rOffs> <rValue> <vOffs>", "optns   Interrupt options: 1 = check, 2 = write to reset, 4 = read", "cOffs   The offset to the register to check", "cMask   The mask of bits to check", "rOffs   The offset to the reset register", "rValue  The value to use for resetting", "vOffs   The offset to the value to read"};
    private static final String[] helpIntDetach = new String[]{"Detach from interrupt processing", "intdetach"};
    private static final String[] helpIntshow = new String[]{"Show interrupt processing parameters and statistics", "intshow"};
    private static final String[] helpTimeread = new String[]{"Time reading from an address", "timeread <count> <address> <width>", "count    The number of times to perform the read", "address  The address at which to read (default board address)", "width    The size (1, 2 or 4) of the word to read (default 1)"};
    private final Output out;
    private final ConsoleReader reader;
    private final Iocard card;
    private final CmndProc proc;
    private int baseAddr = 0;
    private int cardSize = 0;
    private int irqLevel = 0;
    private boolean initd = false;
    private int dValue = 0;
    private int dMask = 0;
    private int dCount = 0;
    private int dOffset = 0;
    private int dWidth = 1;
    private int iCount = 0;
    private int iOptns = 0;
    private int cOffset = 0;
    private int cMask = 0;
    private int rOffset = 0;
    private int rValue = 0;
    private int vOffset = 0;

    TestIocard(Iocard iCard, CmndProc iProc, Output iOut) throws IOException {
        this.out = iOut != null ? iOut : new ConsOut();
        CmndProc.Command cmnd = new CmndProc.Command(17);
        cmnd.add("init", 0, helpInit);
        cmnd.add("term", 1, helpTerm);
        cmnd.add("show", 2, helpShow);
        cmnd.add("readb", 3, helpReadb);
        cmnd.add("readw", 4, helpReadw);
        cmnd.add("readl", 5, helpReadl);
        cmnd.add("writeb", 6, helpWriteb);
        cmnd.add("writew", 7, helpWritew);
        cmnd.add("writel", 8, helpWritel);
        cmnd.add("updateb", 9, helpUpdateb);
        cmnd.add("updatew", 10, helpUpdatew);
        cmnd.add("updatel", 11, helpUpdatel);
        cmnd.add("regshow", 12, helpRegshow);
        cmnd.add("intattach", 13, helpIntAttach);
        cmnd.add("intdetach", 14, helpIntDetach);
        cmnd.add("intshow", 15, helpIntshow);
        cmnd.add("timeread", 16, helpTimeread);
        this.card = iCard == null ? new Iocard() : iCard;
        this.proc = iProc == null ? new CmndProc() : iProc;
        this.proc.add((CmndProc.Dispatch)this, cmnd);
        this.reader = new ConsoleReader();
    }

    TestIocard() throws IOException {
        this(null, null, null);
    }

    public static void main(String[] args) throws IOException {
        TestIocard test = new TestIocard();
        test.run();
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (IocardException e) {
                this.out.println((Object)e);
            }
        }
    }

    public boolean dispatch(int cCode, Scanner scan) {
        Object[] args = new Object[16];
        switch (cCode) {
            case 0: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if (this.initd) {
                    this.initd = false;
                    this.card.term();
                }
                if ((found & 1) != 0) {
                    this.baseAddr = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.cardSize = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.irqLevel = (Integer)args[2];
                }
                this.card.init(this.baseAddr, this.cardSize, this.irqLevel);
                this.initd = true;
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.initd = false;
                this.card.term();
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Initialization parameters:");
                this.out.format("  Base address     = %04x\n", new Object[]{this.baseAddr});
                this.out.format("  Card size        = %04x\n", new Object[]{this.cardSize});
                this.out.println((Object)("  IRQ level        = " + this.irqLevel));
                this.out.println((Object)("  Initialized      = " + this.initd));
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                this.out.format("Value = 0x%02x\n", new Object[]{this.card.readB(this.dOffset)});
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                this.out.format("Value = 0x%04x\n", new Object[]{this.card.readW(this.dOffset)});
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                this.out.format("Value = 0x%08x\n", new Object[]{this.card.readL(this.dOffset)});
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dValue = (Integer)args[1];
                }
                this.card.writeB(this.dOffset, this.dValue);
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dValue = (Integer)args[1];
                }
                this.card.writeW(this.dOffset, this.dValue);
                break;
            }
            case 8: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dValue = (Integer)args[1];
                }
                this.card.writeL(this.dOffset, this.dValue);
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dMask = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dValue = (Integer)args[2];
                }
                this.card.updateB(this.dOffset, this.dMask, this.dValue);
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dMask = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dValue = (Integer)args[2];
                }
                this.card.updateW(this.dOffset, this.dMask, this.dValue);
                break;
            }
            case 11: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dOffset = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dMask = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dValue = (Integer)args[2];
                }
                this.card.updateL(this.dOffset, this.dMask, this.dValue);
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Card Registers:");
                int j = 0;
                while (j < this.cardSize) {
                    if ((j & 3) == 0 && j > 0) {
                        this.out.println();
                    }
                    this.out.format("   %02x: %02x", new Object[]{j, this.card.readB(j)});
                    ++j;
                }
                this.out.println();
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dCount = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dOffset = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dWidth = (Integer)args[2];
                }
                long msec = System.currentTimeMillis();
                if (this.dWidth == 4) {
                    int j = 0;
                    while (j < this.dCount) {
                        this.card.readL(this.dOffset);
                        ++j;
                    }
                } else if (this.dWidth == 2) {
                    int j = 0;
                    while (j < this.dCount) {
                        this.card.readW(this.dOffset);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < this.dCount) {
                        this.card.readB(this.dOffset);
                        ++j;
                    }
                }
                msec = System.currentTimeMillis() - msec;
                this.out.println((Object)("Performed " + this.dCount + " operations in " + msec + " msec"));
                break;
            }
            case 13: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iiiiii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.iOptns = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.cOffset = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.cMask = (Integer)args[2];
                }
                if ((found & 8) != 0) {
                    this.rOffset = (Integer)args[3];
                }
                if ((found & 0x10) != 0) {
                    this.rValue = (Integer)args[4];
                }
                if ((found & 0x20) != 0) {
                    this.vOffset = (Integer)args[5];
                }
                this.iCount = 0;
                this.card.attachInt(0, this.iOptns, this.cOffset, this.cMask, this.rOffset, this.rValue, this.vOffset, this, "intProc", this);
                break;
            }
            case 14: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.card.detachInt(0);
                break;
            }
            case 15: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Interrupt Parameters:");
                this.out.format("  Options               = %02x\n", new Object[]{this.iOptns});
                this.out.format("  Check Register Offset = %02x\n", new Object[]{this.cOffset});
                this.out.format("  Check Mask            = %02x\n", new Object[]{this.cMask});
                this.out.format("  Reset Register Offset = %02x\n", new Object[]{this.rOffset});
                this.out.format("  Reset Value           = %02x\n", new Object[]{this.rValue});
                this.out.format("  Read Register Offset  = %02x\n", new Object[]{this.vOffset});
                this.out.println((Object)("  Count                 = " + this.iCount));
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void intProc(int value, Object parm) {
        TestIocard tioc = (TestIocard)parm;
        ++this.iCount;
        this.out.format("Interrupt occurred: count = %s, value = %02x\n", new Object[]{tioc.iCount, value});
    }
}

