/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.iocard;

import org.lsst.ccs.drivers.iocard.AccesDioException;
import org.lsst.ccs.drivers.iocard.Iocard;

public class AccesDio
extends Iocard {
    public static final int N_REGS = 25;
    public static final int PORTA_REG = 0;
    public static final int PORTB_REG = 1;
    public static final int PORTC_REG = 2;
    public static final int CONF_REG = 3;
    public static final int SETUP_REG = 11;
    public static final int STATE_REG = 15;
    public static final int RESET_REG = 24;
    private static final int[] dioConf = new int[]{128, 144, 130, 146, 129, 145, 131, 147, 136, 152, 138, 154, 137, 153, 139, 155};

    public AccesDio(int base, int irq) {
        super.init(base, 25, irq);
    }

    public AccesDio() {
    }

    public void init(int base, int irq) {
        super.init(base, 25, irq);
    }

    public void dioConfig(int value) {
        this.writeB(3, dioConf[value & 0xF]);
    }

    public int dioInp(int port) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        return this.readB(port);
    }

    public void dioOut(int port, int value) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.writeB(port, value);
    }

    public int dioInpBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        return this.readB(port) >> bit & 1;
    }

    public void dioOutBit(int port, int bit, int value) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.updateB(port, 1 << bit, value << bit);
    }

    public void dioSetBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        int value = 1 << bit;
        this.updateB(port, value, value);
    }

    public void dioClrBit(int port, int bit) {
        if (port < 0 || port > 2) {
            this.throwInvPort();
        }
        this.updateB(port, 1 << bit, 0);
    }

    public void attachInt(int mask, Object cbObj, String cbMeth, Object cbParm) {
        super.attachInt(0, 3, 15, 15, 15, 0, 0, cbObj, cbMeth, cbParm);
        this.writeB(11, 7 ^ mask);
    }

    public void detachInt() {
        this.writeB(11, 7);
        super.detachInt(0);
    }

    private void throwInvPort() {
        throw new AccesDioException("Invalid port number");
    }
}

