/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.indi.sbig;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.indilib.i4j.Constants;
import org.indilib.i4j.client.INDIBLOBElement;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDIDeviceListener;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIServerConnection;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;

public class SBIGCamera
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SBIGCamera.class.getName());
    private final INDIServerConnection indiServerConnection;
    private final INDIDevice sbig;
    private INDIBLOBElement blobElement;

    public SBIGCamera() throws IOException {
        this("localhost");
    }

    public SBIGCamera(String host) throws IOException {
        this(host, 7624);
    }

    public SBIGCamera(String host, int port) throws IOException {
        this.indiServerConnection = new INDIServerConnection(host, port);
        this.indiServerConnection.connect();
        try {
            this.indiServerConnection.askForDevices();
            this.sbig = this.indiServerConnection.waitForDevice("SBIG CCD", 2);
            if (this.sbig == null) {
                throw new IOException("No SBIG CCD device found");
            }
            this.sbig.blobsEnable(Constants.BLOBEnables.ALSO);
            this.sbig.addINDIDeviceListener(new DeviceListener());
            INDIElement connect = this.sbig.getElement("CONNECTION", "CONNECT");
            if ("OFF".equals(connect.getValueAsString())) {
                try {
                    connect.setDesiredValue(Constants.SwitchStatus.ON);
                    connect.getProperty().sendChangesToDriver();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException | INDIValueException x) {
                    throw new IOException("Error connecting to device", (Throwable)x);
                }
            }
            INDIProperty<?> property = this.sbig.waitForProperty("CCD1", 2);
            this.blobElement = (INDIBLOBElement)property.getElement("CCD1");
            if (this.blobElement == null) {
                throw new IOException("Unable to access element CCC1/CCD1");
            }
        }
        catch (IOException x) {
            this.indiServerConnection.disconnect();
            throw x;
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, INDIValueException {
        try (SBIGCamera sbigCamera = new SBIGCamera("lsst-uno12");){
            File file = sbigCamera.exposeAndWriteFile(5.0, "FRAME_LIGHT", "test.fits");
            System.out.println(file);
            System.out.println(sbigCamera.getTemperature());
            System.out.println(sbigCamera.isCooling());
            sbigCamera.setCooling(false);
            System.out.println(sbigCamera.isCooling());
        }
    }

    public File exposeAndWriteFile(double seconds, String frameType, String file) throws IOException {
        File f = new File(file);
        this.exposeAndWriteFile(seconds, frameType, f);
        return f;
    }

    public void exposeAndWriteFile(double seconds, String frameType, File file) throws IOException {
        CompletableFuture<INDIBLOBElement> expose = this.expose(seconds, frameType);
        try {
            INDIBLOBElement blob = expose.get((long)(seconds + 10.0), TimeUnit.SECONDS);
            blob.getValue().saveBLOBData(file);
            LOG.log(Level.INFO, "Wrote {0} of size {1}", new Object[]{file, blob.getValue().getSize()});
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException("Interruption while waiting for exposure");
        }
        catch (ExecutionException ex) {
            throw new IOException("Error taking exposure", ex.getCause());
        }
        catch (TimeoutException ex) {
            throw new IOException("Exposure timed out", ex);
        }
    }

    public CompletableFuture<INDIBLOBElement> expose(double seconds, String frameType) throws IOException {
        CompletableFuture<INDIBLOBElement> future = new CompletableFuture<INDIBLOBElement>();
        try {
            this.blobElement.addINDIElementListener(new ElementListener(future));
            INDIProperty<?> frameProperty = this.sbig.getProperty("CCD_FRAME_TYPE");
            if (!Arrays.asList(frameProperty.getElementNames()).contains(frameType)) {
                throw new IOException("Frame type frameType not in supported types " + Arrays.toString(frameProperty.getElementNames()));
            }
            Object frameElement = frameProperty.getElement(frameType);
            ((INDIElement)frameElement).setDesiredValue(Constants.SwitchStatus.ON);
            frameProperty.sendChangesToDriver();
            INDIProperty<?> exposureProperty = this.sbig.getProperty("CCD_EXPOSURE");
            Object element = exposureProperty.getElement("CCD_EXPOSURE_VALUE");
            ((INDIElement)element).setDesiredValue(seconds);
            exposureProperty.sendChangesToDriver();
        }
        catch (INDIValueException x) {
            future.completeExceptionally((Throwable)((Object)x));
        }
        return future;
    }

    public double getTemperature() {
        INDIProperty<?> property = this.sbig.getProperty("CCD_TEMPERATURE");
        Object element = property.getElement("CCD_TEMPERATURE_VALUE");
        return (Double)((INDIElement)element).getValue();
    }

    public boolean isCooling() {
        INDIProperty<?> property = this.sbig.getProperty("CCD_COOLER");
        Object element = property.getElement("COOLER_ON");
        return ((INDIElement)element).getValue() == Constants.SwitchStatus.ON;
    }

    public void setCooling(boolean on) throws IOException {
        try {
            INDIProperty<?> property = this.sbig.getProperty("CCD_COOLER");
            Object element = property.getElement(on ? "COOLER_ON" : "COOLER_OFF");
            ((INDIElement)element).setDesiredValue(Constants.SwitchStatus.ON);
            property.sendChangesToDriver();
        }
        catch (INDIValueException x) {
            throw new IOException("Unable to set cooling ", (Throwable)((Object)x));
        }
    }

    public INDIProperty<?> getProperty(String name) {
        return this.sbig.getProperty(name);
    }

    public String[] getProperties() {
        return this.sbig.getPropertyNames();
    }

    @Override
    public void close() throws IOException {
        this.indiServerConnection.disconnect();
    }

    static {
        INDIURLStreamHandlerFactory.init();
    }

    static class DeviceListener
    implements INDIDeviceListener {
        DeviceListener() {
        }

        @Override
        public void newProperty(INDIDevice device, INDIProperty<?> property) {
        }

        @Override
        public void removeProperty(INDIDevice device, INDIProperty<?> property) {
        }

        @Override
        public void messageChanged(INDIDevice device) {
            String lastMessage = device.getLastMessage();
            LOG.log(Level.INFO, lastMessage);
        }
    }

    static class ElementListener
    implements INDIElementListener {
        private final CompletableFuture<INDIBLOBElement> future;

        private ElementListener(CompletableFuture<INDIBLOBElement> future) {
            this.future = future;
        }

        @Override
        public void elementChanged(INDIElement element) {
            this.future.complete((INDIBLOBElement)element);
        }
    }
}

