/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

public class DoubleWithError {
    static final char plusorminus = '\u00b1';
    static final char plus = '+';
    static final char minus = '-';
    private double value;
    private double error;
    private boolean asymmetricError;
    private double minError;

    public DoubleWithError(double value, double error) {
        this.value = value;
        this.error = error;
        this.asymmetricError = false;
    }

    public DoubleWithError(double value, double plusError, double minError) {
        this.value = value;
        this.error = plusError;
        this.minError = minError;
        this.asymmetricError = true;
    }

    public void setError(double error) {
        this.error = error;
        this.asymmetricError = false;
    }

    public void setError(double plusError, double minError) {
        this.error = plusError;
        this.minError = minError;
        this.asymmetricError = true;
    }

    public double getError() {
        return this.error;
    }

    public double getPlusError() {
        return this.error;
    }

    public double getMinError() {
        return this.asymmetricError ? this.minError : this.error;
    }

    public boolean hasAsymmetricError() {
        return this.asymmetricError;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        if (this.asymmetricError) {
            return String.valueOf(this.value) + '+' + this.error + '-' + this.minError;
        }
        return String.valueOf(this.value) + '\u00b1' + this.error;
    }
}

