/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.url;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.indilib.i4j.protocol.url.INDIURLStreamHandler;
import org.indilib.i4j.protocol.url.INDIURLZipStreamHandler;
import org.indilib.i4j.protocol.websocket.INDIWebSocketStreamHandler;

public class INDIURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            initialized = true;
            if (System.getProperty(INDIURLStreamHandlerFactory.class.getSimpleName() + ".auto.register", "true").equalsIgnoreCase("true")) {
                URL.setURLStreamHandlerFactory(new INDIURLStreamHandlerFactory());
            }
        }
    }

    @Override
    public final URLStreamHandler createURLStreamHandler(String protocol) {
        if ("indi".equals(protocol)) {
            return new INDIURLStreamHandler();
        }
        if ("indiz".equals(protocol)) {
            return new INDIURLZipStreamHandler();
        }
        if ("indiw".equals(protocol)) {
            return new INDIWebSocketStreamHandler();
        }
        return null;
    }
}

