/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.i2c;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2c;

public class TestI2c {
    private final I2c i2c = new I2c();

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.i2c.open(ident, 0);
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.i2c.close();
    }

    @Command(name="writeone", description="Write one byte")
    public void writeOne(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.i2c.write(addr, value);
    }

    @Command(name="readone", description="Read one byte")
    public String readOne(@Argument(name="addr", description="I2C bus address") int addr) throws DriverException {
        return "Value = " + this.i2c.read(addr);
    }

    @Command(name="readmult", description="Read multiple byte")
    public String readMult(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="count", description="Byte count") int count) throws DriverException {
        byte[] data = new byte[count];
        return TestI2c.formatData(data, this.i2c.read(addr, data));
    }

    @Command(name="write", description="Write bytes (1-byte register number)")
    public void write(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, int ... value) throws DriverException {
        byte[] bvalue = new byte[value.length];
        for (int j = 0; j < bvalue.length; ++j) {
            bvalue[j] = (byte)value[j];
        }
        this.i2c.write(addr, reg, bvalue);
    }

    @Command(name="writestring", description="Write string (1-byte register number)")
    public void writeString(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="value", description="String to write") String value) throws DriverException {
        this.i2c.write(addr, reg, value.getBytes());
    }

    @Command(name="read", description="Read bytes (1-byte register number)")
    public String read(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="count", description="Byte count") int count) throws DriverException {
        byte[] data = new byte[count];
        return TestI2c.formatData(data, this.i2c.read(addr, reg, data));
    }

    @Command(name="readstring", description="Read string (1-byte register number)")
    public String readString(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="count", description="Byte count") int count) throws DriverException {
        byte[] data = new byte[count];
        return count + " bytes read: " + new String(data, 0, this.i2c.read(addr, reg, data));
    }

    @Command(name="write2", description="Write bytes (2-byte register number)")
    public void write2(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, int ... value) throws DriverException {
        byte[] bvalue = new byte[value.length];
        for (int j = 0; j < bvalue.length; ++j) {
            bvalue[j] = (byte)value[j];
        }
        this.i2c.write2(addr, reg, bvalue);
    }

    @Command(name="writestring2", description="Write string (2-byte register number)")
    public void writeString2(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="value", description="String to write") String value) throws DriverException {
        this.i2c.write2(addr, reg, value.getBytes());
    }

    @Command(name="read2", description="Read bytes (2-byte register number)")
    public String read2(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="count", description="Byte count") int count) throws DriverException {
        byte[] data = new byte[count];
        return TestI2c.formatData(data, this.i2c.read2(addr, reg, data));
    }

    @Command(name="readstring2", description="Read string (2-byte register number)")
    public String readString2(@Argument(name="addr", description="I2C bus address") int addr, @Argument(name="reg", description="Register number") int reg, @Argument(name="count", description="Byte count") int count) throws DriverException {
        byte[] data = new byte[count];
        return count + " bytes read: " + new String(data, 0, this.i2c.read2(addr, reg, data));
    }

    private static String formatData(byte[] data, int count) {
        if (count == 0) {
            return "No data read";
        }
        StringBuilder buff = new StringBuilder();
        buff.append(count);
        buff.append(" bytes read:");
        for (int j = 0; j < count; ++j) {
            if (j % 20 == 0) {
                buff.append("\n  ");
            }
            buff.append(String.format(" %02x", data[j]));
        }
        return buff.toString();
    }
}

