/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.hameg;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.hameg.HMPSeries;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestHMP
extends TestScpi {
    private final HMPSeries hmp = (HMPSeries)this.scpi;
    private int chanNum = 1;

    public TestHMP() {
        super(new HMPSeries());
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Ascii.ConnType connType, @Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.hmp.open(connType, ident);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Ascii.ConnType connType, @Argument(name="ident", description="Identification") String ident, @Argument(name="baud", description="Baud rate") int baudRate) throws DriverException {
        this.hmp.open(connType, ident, baudRate);
    }

    @Command(name="shownumchannels", description="Show the number of channels")
    public String showNumChannels() {
        return "No. of channels = " + this.hmp.getNumChannels();
    }

    @Command(name="setchannel", description="Set the current channel")
    public void setChannel(@Argument(name="channel", description="Channel number") int chan) {
        this.chanNum = chan;
    }

    @Command(name="showchannel", description="Show the set channel")
    public String showChannel() {
        return "Channel = " + this.chanNum;
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.hmp.setVoltage(value, this.chanNum);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setVoltage(value, chan);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage() throws DriverException {
        this.hmp.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage() throws DriverException {
        return "Maximum voltage = " + this.hmp.getMaximumVoltage(this.chanNum);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Maximum voltage = " + this.hmp.getMaximumVoltage(chan);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage() throws DriverException {
        return "Voltage = " + this.hmp.getVoltage(this.chanNum);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.hmp.getVoltage(chan);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.hmp.readVoltage(this.chanNum);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.hmp.readVoltage(chan);
    }

    @Command(name="setvoltlimit", description="Set the  voltage limit")
    public void setVoltLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.hmp.setVoltageLimit(value, this.chanNum);
    }

    @Command(name="setvoltlimit", description="Set the voltage limit")
    public void setVoltLimit(@Argument(name="value", description="Voltage limit to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setVoltageLimit(value, chan);
    }

    @Command(name="showvoltlimit", description="Show the voltage limit")
    public String showVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.hmp.getVoltageLimit(this.chanNum);
    }

    @Command(name="showvoltlimit", description="Show the voltage limit")
    public String showVoltLimit(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage limit = " + this.hmp.getVoltageLimit(chan);
    }

    @Command(name="showvolttrip", description="Show the voltage tripped state")
    public String showVoltTrip() throws DriverException {
        return "Voltage tripped = " + this.hmp.isVoltageTripped(this.chanNum);
    }

    @Command(name="showvolttrip", description="Show the voltage tripped state")
    public String showVoltTrip(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage tripped = " + this.hmp.isVoltageTripped(chan);
    }

    @Command(name="clearvolttrip", description="Clear the voltage tripped state")
    public void clearVoltTrip() throws DriverException {
        this.hmp.clearVoltageTrip(this.chanNum);
    }

    @Command(name="clearvolttrip", description="Clear the voltage tripped state")
    public void clearVoltTrip(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.clearVoltageTrip(chan);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.hmp.setCurrent(value, this.chanNum);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setCurrent(value, chan);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent() throws DriverException {
        this.hmp.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent() throws DriverException {
        return "Maximum current = " + this.hmp.getMaximumCurrent(this.chanNum);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Maximum current = " + this.hmp.getMaximumCurrent(chan);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent() throws DriverException {
        return "Current = " + this.hmp.getCurrent(this.chanNum);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Current = " + this.hmp.getCurrent(chan);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.hmp.readCurrent(this.chanNum);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Current = " + this.hmp.readCurrent(chan);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state) throws DriverException {
        this.hmp.setOutput(state == OnOff.ON, this.chanNum);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.hmp.setOutput(state == OnOff.ON, chan);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.hmp.getOutput(this.chanNum));
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Output state = " + this.getOnOff(this.hmp.getOutput(chan));
    }

    @Command(name="lock", description="Lock the front panel")
    public void lock() throws DriverException {
        this.hmp.lockPanel(true);
    }

    @Command(name="unlock", description="Unlock the front panel")
    public void unlock() throws DriverException {
        this.hmp.lockPanel(false);
    }

    @Command(name="beep", description="Sound the beeper")
    public void beep() throws DriverException {
        this.hmp.beep();
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

