/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.InputConversionEngine;
import org.lsst.ccs.command.TokenizedCommand;

public class RawCommand
implements BasicCommand {
    private final String commandName;
    private final List<Object> arguments;
    private static final long serialVersionUID = 8273895275408621472L;

    public RawCommand(String commandName, List<Object> arguments) {
        this.commandName = commandName;
        this.arguments = arguments;
    }

    @Override
    public String getCommand() {
        return this.commandName;
    }

    @Override
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    @Override
    public int getArgumentCount() {
        return this.arguments.size();
    }

    static RawCommand toRawCommand(BasicCommand command, Method method, InputConversionEngine engine) throws CommandInvocationException {
        if (command instanceof RawCommand) {
            return (RawCommand)command;
        }
        if (command instanceof TokenizedCommand) {
            return RawCommand.convertToRaw((TokenizedCommand)command, method, engine);
        }
        throw new CommandInvocationException("Error: Unknown type of command " + command.getClass().getName(), new Object[0]);
    }

    private static RawCommand convertToRaw(TokenizedCommand tokenizedCommand, Method method, InputConversionEngine engine) throws CommandInvocationException {
        DictionaryCommand methodCommand = CommandDictionaryBuilder.getDictionaryCommandFromMethod(method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        ArrayList<Object> args = new ArrayList<Object>(parameterTypes.length);
        boolean varArgs = method.isVarArgs();
        if (varArgs) {
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                args.add(engine.convertArgToType(tokenizedCommand.getArgument(i), parameterTypes[i]));
            }
            Type varClass = parameterTypes[parameterTypes.length - 1];
            Class<?> elemClass = ((Class)varClass).getComponentType();
            Object theArray = Array.newInstance(elemClass, tokenizedCommand.getArgumentCount() - parameterTypes.length + 1);
            for (int j = 0; j < Array.getLength(theArray); ++j) {
                Array.set(theArray, j, engine.convertArgToType(tokenizedCommand.getArgument(parameterTypes.length - 1 + j), elemClass));
            }
            args.add(theArray);
        } else {
            int i;
            int maxArgs = Math.max(parameterTypes.length, tokenizedCommand.getArgumentCount());
            int minArgs = Math.min(parameterTypes.length, tokenizedCommand.getArgumentCount());
            for (i = 0; i < minArgs; ++i) {
                args.add(engine.convertArgToType(tokenizedCommand.getArgument(i), parameterTypes[i]));
            }
            if (tokenizedCommand.getArgumentCount() < parameterTypes.length) {
                for (i = minArgs; i < maxArgs; ++i) {
                    args.add(engine.convertArgToType(methodCommand.getArguments()[i].getDefaultValue(), parameterTypes[i]));
                }
            }
        }
        return new RawCommand(tokenizedCommand.getCommand(), args);
    }

    public String toString() {
        return this.prettyToString();
    }
}

