/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.freehep.util.VersionComparator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourcesUtils;
import org.lsst.ccs.bootstrap.SystemPropertyMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class Bootstrap {
    private Options bootstrapCommandLineOptions;
    private final List<String> additionalCommandLineArguments = new ArrayList<String>();
    private final List<String> passedAlongOptions = new ArrayList<String>();
    private static String bootstrapApplication = null;
    private static URLClassLoader applicationClassLoader = null;
    private boolean printHelp = false;
    private boolean listApplications = false;
    private boolean showDistributionInfo = false;
    private static boolean verbose = false;
    static final String APPLICATION_OPTION = "application";
    static final String HELP_OPTION = "help";
    static final String VERBOSE_OPTION = "verbose";
    static final String LIST_APPLICATIONS_OPTION = "listApplications";
    private String showProperties = null;
    private boolean showClasspath = false;
    private static final String APPLICATION_ARGS_PROPERTY = "org.lsst.ccs.application.args";
    private static final String APPLICATION_DESCRIPTION_PROPERTY = "org.lsst.ccs.application.description";
    private static Properties bootstrapCmdLineProperties = new Properties();
    private static Map<String, String> additionalClassPathEntriesMap = new HashMap<String, String>();
    private static List<String> additionalClassPathEntriesList = new ArrayList<String>();
    private static Properties bootstrapApplicationProperties = null;
    private static final String BOOTSTRAP_ENVIRONMENT_PROPERTY = "org.lsst.ccs.bootstrap.environment";
    private static String distributionMainJar = null;
    private static boolean quiet = false;
    static Class loaderClass = BootstrapUtils.class;

    Bootstrap() {
        this(false);
    }

    Bootstrap(boolean quiet) {
        Bootstrap.quiet = quiet;
        this.bootstrapCommandLineOptions = new Options();
        this.bootstrapCommandLineOptions.addOption("h", HELP_OPTION, false, "Print the help message");
        this.bootstrapCommandLineOptions.addOption("v", VERBOSE_OPTION, false, "Turns on verbose statements");
        this.bootstrapCommandLineOptions.addOption("la", LIST_APPLICATIONS_OPTION, false, "List the available CCS applications in this distribution");
        this.bootstrapCommandLineOptions.addOption("app", APPLICATION_OPTION, true, "The APPLICATION to be launched");
        this.getOption(APPLICATION_OPTION).setArgName("APPLICATION");
        OptionBuilder.withArgName("SystemProperty=Value");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Set the Value of a SystemProperty.");
        Option sysProperty = OptionBuilder.create("D");
        this.bootstrapCommandLineOptions.addOption(sysProperty);
        this.bootstrapCommandLineOptions.addOption("di", "distInfo", false, "Show information on current distribution.");
        this.bootstrapCommandLineOptions.addOption("sp", "showProperties", true, "Show the properties for <FILE_NAME>.");
        this.getOption("showProperties").setArgName("FILE_NAME");
        this.bootstrapCommandLineOptions.addOption("scp", "showClasspath", false, "Show the classpath for the given application.");
    }

    static void resetBootstrap() {
        bootstrapCmdLineProperties = new Properties();
        additionalClassPathEntriesMap = new HashMap<String, String>();
        additionalClassPathEntriesList = new ArrayList<String>();
        bootstrapApplication = null;
        BootstrapUtils.reset();
    }

    static Class getLoaderClass() {
        return loaderClass;
    }

    static synchronized Properties getBootstrapApplicationProperties() {
        if (bootstrapApplicationProperties == null) {
            bootstrapApplicationProperties = BootstrapUtils.getApplicationDefinitionProperties(Bootstrap.getBootstrapApplication());
        }
        return bootstrapApplicationProperties;
    }

    List<String> getAdditionalCommandLineArguments() {
        return this.additionalCommandLineArguments;
    }

    CommandLine parseCommandLineArguments(String[] args) throws ParseException {
        Option[] opts;
        ArrayList<String> argumentsToParse = new ArrayList<String>();
        boolean skipNext = false;
        for (int i = 0; i < args.length; ++i) {
            if (skipNext) {
                skipNext = false;
                continue;
            }
            String arg = args[i];
            if (arg.startsWith("-D")) {
                int propertyStrIndex = arg.equals("-D") ? i + 1 : i;
                String propertyStr = args[propertyStrIndex].replace("-D", "");
                if (!propertyStr.contains("=")) {
                    args[propertyStrIndex] = args[propertyStrIndex].replace(propertyStr, propertyStr + "=");
                }
                if (arg.equals("-D")) {
                    argumentsToParse.add(arg);
                    continue;
                }
                this.additionalCommandLineArguments.add(args[i]);
                continue;
            }
            if (arg.startsWith("-") && !this.bootstrapCommandLineOptions.hasOption(arg)) {
                String tmpArg;
                this.additionalCommandLineArguments.add(arg);
                if (i >= args.length - 1 || (tmpArg = args[i + 1]).startsWith("-")) continue;
                this.additionalCommandLineArguments.add(tmpArg);
                skipNext = true;
                continue;
            }
            argumentsToParse.add(arg);
        }
        BasicParser parser = new BasicParser();
        String[] newArgs = argumentsToParse.toArray(new String[argumentsToParse.size()]);
        CommandLine line = parser.parse(this.bootstrapCommandLineOptions, newArgs, false);
        if (line.hasOption(APPLICATION_OPTION)) {
            String tmpApp = line.getOptionValue(APPLICATION_OPTION);
            if (!BootstrapUtils.getBootstrapListOfApplications().contains(tmpApp)) {
                throw new IllegalArgumentException("Application name:  " + tmpApp + " is not a valid value.");
            }
            bootstrapApplication = tmpApp;
        }
        if (line.hasOption(HELP_OPTION)) {
            this.printHelp = true;
        }
        this.additionalCommandLineArguments.addAll(line.getArgList());
        this.showClasspath = line.hasOption("showClasspath");
        if (line.hasOption("showProperties") && this.showProperties == null) {
            this.showProperties = line.getOptionValue("showProperties");
        }
        if (line.hasOption(LIST_APPLICATIONS_OPTION)) {
            this.listApplications = true;
        }
        verbose = line.hasOption(VERBOSE_OPTION);
        if (this.printHelp && !this.passedAlongOptions.contains("-help")) {
            this.passedAlongOptions.add("-help");
        }
        if (verbose && !this.passedAlongOptions.contains("-verbose")) {
            this.passedAlongOptions.add("-verbose");
        }
        Properties cmdLineProperties = line.getOptionProperties("D");
        for (Option opt : opts = line.getOptions()) {
            boolean wasSet;
            if (!opt.getOpt().equals("D")) continue;
            boolean bl = wasSet = opt.getValuesList().size() == 2;
            if (wasSet) continue;
            cmdLineProperties.setProperty(opt.getValue(), "");
        }
        if (Bootstrap.verbose() && !quiet && !cmdLineProperties.isEmpty()) {
            System.out.println("\n*** Adding the following command line properties to the Properties:");
            Set<Object> keys = cmdLineProperties.keySet();
            for (Object key : keys) {
                System.out.println("\t" + key + " = " + cmdLineProperties.getProperty((String)key));
            }
        }
        if (!cmdLineProperties.isEmpty()) {
            bootstrapCmdLineProperties.putAll((Map<?, ?>)cmdLineProperties);
            System.getProperties().putAll((Map<?, ?>)cmdLineProperties);
        }
        if (line.hasOption("distInfo")) {
            this.showDistributionInfo = true;
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String additional : this.additionalCommandLineArguments) {
            SystemPropertyMatcher m = SystemPropertyMatcher.matcher(additional);
            if (!m.matches()) continue;
            toBeRemoved.add(additional);
            bootstrapCmdLineProperties.put(m.getProperty(), m.getValue());
        }
        for (String remove : toBeRemoved) {
            this.additionalCommandLineArguments.remove(remove);
        }
        return line;
    }

    static Properties getCmdLineProperties() {
        return bootstrapCmdLineProperties;
    }

    static String getBootstrapApplication() {
        return bootstrapApplication;
    }

    private boolean doPrintHelp() {
        return this.printHelp;
    }

    static boolean verbose() {
        return verbose;
    }

    static boolean isQuiet() {
        return quiet;
    }

    Options getBootstrapCommandLineOptions() {
        return this.bootstrapCommandLineOptions;
    }

    private static void printBootstrapClassLoader() {
        URL[] urls = Bootstrap.getBootstrapApplicationClassLoader().getURLs();
        System.out.println("*** CLASSPATH");
        for (URL url : urls) {
            System.out.println("\t\t" + url);
        }
    }

    private Option getOption(String opt) {
        return this.getBootstrapCommandLineOptions().getOption(opt);
    }

    private String[] getApplicationArguments(Properties appProperties) throws ParseException {
        String applicationArgs = appProperties.getProperty(APPLICATION_ARGS_PROPERTY, "").trim();
        StringTokenizer applicationArgsTokenizer = new StringTokenizer(applicationArgs, " ");
        int nArgs = this.passedAlongOptions.size() + this.additionalCommandLineArguments.size() + applicationArgsTokenizer.countTokens();
        String[] mainArgs = new String[nArgs];
        int argCount = 0;
        for (String opt : this.passedAlongOptions) {
            mainArgs[argCount++] = opt;
        }
        for (String cmdArg : this.additionalCommandLineArguments) {
            mainArgs[argCount++] = cmdArg;
        }
        while (applicationArgsTokenizer.hasMoreTokens()) {
            mainArgs[argCount++] = applicationArgsTokenizer.nextToken();
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.print("*** Command line arguments passed to the mainClass: ");
            for (String arg : mainArgs) {
                System.out.print(arg + " ");
            }
            System.out.println();
        }
        return mainArgs;
    }

    static URLClassLoader getBootstrapApplicationClassLoader() {
        if (applicationClassLoader == null) {
            Bootstrap.buildBootstrapClassLoader();
        }
        return applicationClassLoader;
    }

    private static void scanPropertiesForClassPathEntries(Properties props) {
        Set<Object> keySet = BootstrapResourceUtils.getAllKeysInProperties(props);
        for (Object obj : keySet) {
            String key = (String)obj;
            if (!key.endsWith("additional.classpath.entry")) continue;
            String entry = props.getProperty(key);
            if (additionalClassPathEntriesMap.containsKey(key)) {
                if (quiet) continue;
                System.out.println("*** [WARNING] ignoring additional classpath entry: " + key + "=" + entry + " it was already added to the CLASSPATH as " + additionalClassPathEntriesMap.get(key));
                continue;
            }
            additionalClassPathEntriesMap.put(key, entry);
            additionalClassPathEntriesList.add(entry);
        }
    }

    private static synchronized void buildBootstrapClassLoader() {
        if (applicationClassLoader != null) {
            throw new RuntimeException("The Bootstrap ClassLoader has already been built. Please report this problem.");
        }
        ArrayList<URL> classPathUrlList = new ArrayList<URL>();
        if (bootstrapApplication != null) {
            Bootstrap.scanPropertiesForClassPathEntries(Bootstrap.getBootstrapApplicationProperties());
        }
        try {
            String userProvidedDistributionDirs = BootstrapUtils.getUserProvidedDistributionDirectories();
            List<String> additionalDistributionJarDirs = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributionDirs, null, true);
            boolean checkForVersionIncompatibilities = additionalDistributionJarDirs.size() > 0;
            ClassPathBuilderSupport cpSupport = new ClassPathBuilderSupport();
            String applicationMainJar = Bootstrap.getDistributionMainJar();
            File jar = null;
            if (applicationMainJar != null) {
                jar = new File(applicationMainJar);
                classPathUrlList.add(jar.toURI().toURL());
            }
            for (String classPathEntry : additionalClassPathEntriesList) {
                File cpEntryFile = new File(classPathEntry);
                if (cpEntryFile.isDirectory()) {
                    if (quiet) continue;
                    System.out.println("*** [WARNING] Directories cannot be added to the classpath as additional Classpath entries. Skipping " + classPathEntry);
                    continue;
                }
                classPathUrlList.add(cpEntryFile.toURI().toURL());
            }
            if (checkForVersionIncompatibilities && jar != null) {
                Bootstrap.scanManifestForClassPathElements(jar, cpSupport);
            }
            for (String dir : additionalDistributionJarDirs) {
                String additionalMainJar = Bootstrap.getDistributionMainJar(dir);
                File mainjar = new File(additionalMainJar);
                classPathUrlList.add(mainjar.toURI().toURL());
                if (!checkForVersionIncompatibilities) continue;
                Bootstrap.scanManifestForClassPathElements(mainjar, cpSupport);
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Failed to build URL when building the classpath: " + mue.getMessage());
        }
        URL[] classpathUrls = new URL[classPathUrlList.size()];
        int count = 0;
        for (URL classpathURl : classPathUrlList) {
            classpathUrls[count++] = classpathURl;
        }
        applicationClassLoader = new URLClassLoader(classpathUrls);
    }

    private static String getDistributionMainJar(String distribution) {
        File distributionDefinitionFile = new File(BootstrapUtils.getDistributionResourcesDirectory(distribution) + "DIST-INF/distribution.xml");
        if (!distributionDefinitionFile.exists()) {
            throw new RuntimeException("FATAL: Cannot run distribution " + distribution + " as it does not contain the distribution definition xml file");
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(distributionDefinitionFile);
            Element rootEl = doc.getDocumentElement();
            return BootstrapUtils.getDistributionJarFilesDirectory(distribution) + rootEl.getAttribute("mainJar");
        }
        catch (IOException | ParserConfigurationException | SAXException pce) {
            throw new RuntimeException(pce);
        }
    }

    private static String getDistributionMainJar() {
        if (distributionMainJar == null) {
            distributionMainJar = Bootstrap.getDistributionMainJar(BootstrapUtils.getCCSDistributionRootDirectory());
        }
        return distributionMainJar;
    }

    private void launchCCSApplication(String applicationName) {
        String applicationMainClassName;
        Properties applicationProperties = BootstrapUtils.getApplicationDefinitionProperties(applicationName);
        if (this.doPrintHelp()) {
            String appDescription = applicationProperties.getProperty(APPLICATION_DESCRIPTION_PROPERTY, "");
            System.out.println("\n\tCCS Application " + applicationName + " " + appDescription + "\n");
        }
        if ((applicationMainClassName = applicationProperties.getProperty("org.lsst.ccs.application.mainClass")) == null) {
            throw new RuntimeException("*** Application " + applicationName + " must define the main Class to lauch. " + "This can be done either in the Manifest of the main jar or by defining the property " + "org.lsst.ccs.application.mainClass" + " in its definition file. ");
        }
        if (Bootstrap.verbose() && Bootstrap.isQuiet()) {
            System.out.println("*** Distribution Root: " + BootstrapUtils.getCCSDistributionRootDirectory());
            System.out.println("*** Application name: " + applicationName);
            System.out.println("*** MainClass: " + applicationMainClassName);
            System.out.println("*** LD_LIBRARY_PATH: " + System.getenv("LD_LIBRARY_PATH"));
        }
        try {
            Class<?> applicationMainClass = Class.forName(applicationMainClassName);
            try {
                Method applicationMainMethod = applicationMainClass.getMethod("main", String[].class);
                String applicationMainJar = Bootstrap.getDistributionMainJar();
                File jar = null;
                if (applicationMainJar != null) {
                    jar = new File(applicationMainJar);
                    Bootstrap.scanManifestForVersions(jar);
                }
                String[] mainArgs = this.getApplicationArguments(applicationProperties);
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    Bootstrap.printBootstrapClassLoader();
                }
                try {
                    applicationMainMethod.invoke(null, new Object[]{mainArgs});
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    System.out.println("*** Failed to invoke main method in class " + applicationMainClassName);
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    System.out.println("*** Reason:  " + cause.getMessage());
                    cause.printStackTrace();
                    System.exit(1);
                }
            }
            catch (NoSuchMethodException | SecurityException | ParseException e) {
                System.out.println("*** Could not access the main method in class " + applicationMainClassName + "\n" + e.getMessage());
                System.exit(1);
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("*** Could not find class " + applicationMainClassName + " in the following classpath: ");
            Bootstrap.printBootstrapClassLoader();
            System.out.println("*************************************************************************\n" + cnfe.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty(BOOTSTRAP_ENVIRONMENT_PROPERTY, "true");
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.parseCommandLineArguments(args);
        String applicationName = Bootstrap.getBootstrapApplication();
        if (bootstrap.doPrintHelp()) {
            System.out.println("\n\tCCS Bootstrap Help \n");
            Bootstrap.printHelp(bootstrap.getBootstrapCommandLineOptions());
        }
        if (bootstrap.showClasspath) {
            if (Bootstrap.getBootstrapApplication() == null) {
                throw new IllegalArgumentException("To display the content of the classpath you have to provide an application with the --app option");
            }
            Bootstrap.printBootstrapClassLoader();
        } else if (bootstrap.showProperties != null) {
            if (Bootstrap.getBootstrapApplication() == null) {
                throw new IllegalArgumentException("To display the content of a properties file you have to provide an application with the --app option");
            }
            ResourcesUtils.printProperties(BootstrapResourceUtils.getBootstrapProperties(bootstrap.showProperties));
        } else if (bootstrap.showDistributionInfo) {
            Bootstrap.printDistributionInfo();
        } else if (bootstrap.listApplications) {
            List<String> availableApplications = BootstrapUtils.getBootstrapListOfApplications();
            if (availableApplications.isEmpty()) {
                System.out.println("No CCS applications are defined in the current distribution.");
                if (bootstrap.verbose()) {
                    if (!bootstrap.isQuiet()) {
                        System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                    }
                }
            } else {
                System.out.println("Available CCS applications :");
                if (bootstrap.verbose()) {
                    if (!bootstrap.isQuiet()) {
                        System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                    }
                }
                for (String application : availableApplications) {
                    Properties applicationProps = BootstrapUtils.getApplicationDefinitionProperties(application);
                    System.out.println("\t" + application + "\t" + applicationProps.getProperty(APPLICATION_DESCRIPTION_PROPERTY));
                }
            }
        } else if (applicationName != null) {
            List<String> availableApplications = BootstrapUtils.getBootstrapListOfApplications();
            if (!availableApplications.contains(applicationName)) {
                String error = "\n[ERROR] Application " + applicationName + " is not present in this distribution.";
                error = error + "\n        Allowed values are: ";
                for (String app : availableApplications) {
                    error = error + "\n                            " + app;
                }
                System.out.println(error + "\n");
                System.exit(1);
            }
            bootstrap.launchCCSApplication(applicationName);
        }
    }

    private static void printHelp(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "CCSbootstrap", "", o, "", true);
    }

    private static void printDistributionInfo() {
        System.out.println("\n*** Distribution info");
        System.out.println("\tDistribution path: " + BootstrapUtils.getCCSDistributionRootDirectory());
        System.out.println("\tResources ordered search path: ");
        List<String> distSearchPathList = BootstrapUtils.getOrderedListOfResourceDirectories();
        String resourcesDirList = "";
        StringBuffer b = new StringBuffer();
        for (String dir : distSearchPathList) {
            File f = new File(dir);
            String tmpDir = dir;
            if (!f.exists()) {
                tmpDir = tmpDir + " (missing)";
            }
            b.append("\t\t" + tmpDir + "\n");
        }
        resourcesDirList = resourcesDirList + b.toString();
        System.out.print(resourcesDirList);
    }

    static boolean isBootstrapEnvironment() {
        return "true".equals(System.getProperty(BOOTSTRAP_ENVIRONMENT_PROPERTY));
    }

    private static void scanManifestForClassPathElements(File file, ClassPathBuilderSupport cp) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path").trim();
            File parentDir = file.getParentFile();
            StringTokenizer classPathTokens = new StringTokenizer(manifestClassPath, " ");
            while (classPathTokens.hasMoreTokens()) {
                String manifestClassPathJar = classPathTokens.nextToken();
                cp.addClasspathEntry(parentDir.getAbsolutePath(), manifestClassPathJar);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void scanManifestForVersions(File file) {
        block11: {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                System.setProperty("org.lsst.ccs.project", manifest.getMainAttributes().getValue("CCS-Project"));
                System.setProperty("org.lsst.ccs.project.version", manifest.getMainAttributes().getValue("Implementation-Version"));
                System.setProperty("org.lsst.ccs.jenkins.build.number", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Number"));
                System.setProperty("org.lsst.ccs.jenkins.build.id", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Id"));
                System.setProperty("org.lsst.ccs.jenkins.build.url", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Url"));
                System.setProperty("org.lsst.ccs.jenkins.build.jdk", manifest.getMainAttributes().getValue("Build-Jdk"));
                System.setProperty("org.lsst.ccs.source.code.url", manifest.getMainAttributes().getValue("CCS-Source-Code-Url"));
                System.setProperty("org.lsst.ccs.source.code.revision", manifest.getMainAttributes().getValue("CCS-Source-Code-Revision"));
            }
            catch (Exception e) {
                if (jarFile == null) break block11;
                try {
                    jarFile.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private static class ClassPathElementWithVersion {
        private String fileName;
        private String resourceDir;
        private VersionComparator.Version version;

        ClassPathElementWithVersion(String resourceDir, String fileName) {
            this.fileName = fileName;
            this.resourceDir = resourceDir;
        }

        VersionComparator.Version getVersion() {
            if (this.version == null) {
                this.version = VersionComparator.getVersionFromFileName(this.fileName);
            }
            return this.version;
        }

        String getFileName() {
            return this.fileName;
        }

        URL getElementUrl() {
            File element = new File(this.resourceDir, this.fileName);
            if (element.exists()) {
                try {
                    return element.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            System.out.println("The following file does not exist : " + element.getAbsolutePath());
            System.out.println("Something went wrong with its version in the Bootstrap");
            return null;
        }
    }

    private static class ClassPathBuilderSupport {
        private HashMap<String, ClassPathElementWithVersion> classPathEntries = new HashMap();

        private ClassPathBuilderSupport() {
        }

        void addClasspathEntry(String resourceDir, String fileName) {
            String jarName = VersionComparator.stripVersion(fileName);
            ClassPathElementWithVersion existingEntry = this.classPathEntries.get(jarName);
            ClassPathElementWithVersion newEntry = new ClassPathElementWithVersion(resourceDir, fileName);
            if (existingEntry == null) {
                this.classPathEntries.put(jarName, newEntry);
            } else if (!existingEntry.fileName.equals(newEntry.fileName) && !quiet) {
                System.out.println("WARNING Classpath entry version conflict: ");
                System.out.println("\t " + newEntry.resourceDir + BootstrapUtils.FILE_SEPARATOR + newEntry.fileName);
                System.out.println("\t " + existingEntry.resourceDir + BootstrapUtils.FILE_SEPARATOR + existingEntry.fileName);
            }
        }

        Collection<ClassPathElementWithVersion> getListOfClasspathElements() {
            return this.classPathEntries.values();
        }
    }
}

