/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpvacmon;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpvacmon.GP835;

public class TestGP835 {
    protected GP835 mydev;

    @Command(name="open", description="Open a device for use")
    public void open(@Argument(name="connType", description="type of connection NETWORK(0), FTDI(1), SERIAL(2)") int itype, @Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new GP835();
        this.mydev.open(itype, MyDevId, 9600);
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="FTDI id") String host, @Argument(name="baud", description="baud") int baud) throws DriverException {
        this.mydev = new GP835();
        this.mydev.openftdi(host, baud);
        return this.mydev.getIdent();
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="getIDN", description="get the ID")
    public String getIDN() throws Exception {
        return this.mydev.getIdent();
    }

    @Command(name="getPressure", description="get the pressure")
    public double getPressure() throws Exception {
        return this.mydev.getPressure();
    }

    @Command(name="monPressure", description="monitor the pressure")
    public void monPressure() throws Exception {
        long tstart = System.currentTimeMillis();
        while (true) {
            double pres = this.mydev.getPressure();
            long time = System.currentTimeMillis();
            System.out.println("time = " + (double)time / 1000.0 + " delta_t = " + (double)(time - tstart) / 1000.0 + " Pressure = " + pres);
            this.Sleep(0.5);
        }
    }

    public void Sleep(double secs) {
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            System.out.println("Rude awakening!" + ex);
        }
    }

    @Command(name="getTestReport", description="get the test report")
    public String getTestReport() throws Exception {
        return this.mydev.getTestReport();
    }

    @Command(name="getMSP", description="get the mass spectrometer scan results")
    public String getMSP() throws Exception {
        return this.mydev.getMSP();
    }

    @Command(name="setGaugeOn", description="set the gauge on ")
    public void setGaugeOn() throws Exception {
        this.mydev.setGaugeOn();
    }

    @Command(name="setGaugeOff", description="set the gauge on ")
    public void setGaugeOff() throws Exception {
        this.mydev.setGaugeOff();
    }
}

