/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpvacmon;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class GP835
extends Scpi {
    final boolean DEBUG = true;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r";
    private int timeout = 1000;
    private double minCurrent = 3.0;
    private double maxCurrent = 24.0;
    private int minPower = 40;
    private int maxPower = 300;

    public void open(String serialname, int baud) throws DriverException {
        this.init();
        System.out.println("opening SERIAL connection to the GP Vacuum Quality Monitor");
        System.out.println("serialname = " + serialname);
        System.out.println("baud = " + baud);
        super.open(2, serialname, baud);
    }

    public void openftdi(String serialname, int baud) throws DriverException {
        this.init();
        System.out.println("opening FTDI connection to the GP Vacuum Quality Monitor");
        this.open(1, serialname, baud);
    }

    public void init() {
        this.setTerminator(this.terminator);
    }

    public void close() throws DriverException {
        this.close();
    }

    public void reset() throws DriverException {
        this.writeGP835("RST");
    }

    public String getStatus() throws DriverException {
        return this.readGP835("STB?");
    }

    public int stripStatus(String status) throws DriverException {
        if (status.contains("STB")) {
            return Integer.parseInt(status.substring(3), 16);
        }
        return Integer.parseInt(status, 16);
    }

    public int getState() throws DriverException {
        return this.stripStatus(this.getStatus());
    }

    public int stripError(String err) throws DriverException {
        if (err.contains("ESR")) {
            return Integer.parseInt(err.substring(3), 16);
        }
        return Integer.parseInt(err, 16);
    }

    public String getError() throws DriverException {
        return this.readGP835("ESR?");
    }

    public String getIdent() throws DriverException {
        return this.readGP835("*IDN?");
    }

    public String getReport() throws DriverException {
        return this.readGP835("TEST:REP?");
    }

    public double getPressure() throws DriverException {
        this.writeGP835("INST ETPR");
        this.writeGP835("OUTP ON");
        return Double.valueOf(this.readGP835("MEAS:PRES?"));
    }

    public double getFilamentPower() throws DriverException {
        return Double.valueOf(this.readGP835("INST FIL;MEAS:POW?"));
    }

    public String getMSP() throws DriverException {
        return this.readGP835("INST MSP;FORM:AMU ON;FORM:COUNT ON;OUTP ON ;INIT;FETC?");
    }

    public String getTestReport() throws DriverException {
        return this.readGP835("TEST:REP?");
    }

    public String getSelectedInstrument() throws DriverException {
        return this.readGP835("INST:SEL?");
    }

    public void setGaugeOn() throws DriverException {
        this.writeGP835("INST MSP;OUTP ON");
    }

    public void setGaugeOff() throws DriverException {
        this.writeGP835("INST MSP;OUTP OFF");
    }

    public synchronized void writeGP835(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readGP835() throws DriverException {
        return this.read();
    }

    public synchronized String readGP835(String command) throws DriverException {
        this.writeGP835(command);
        String response = this.readGP835();
        return response;
    }

    public synchronized int readIntegerGP835(String command) throws DriverException {
        this.writeGP835(command);
        return Integer.getInteger(this.readGP835());
    }

    public double[][] readAMU() throws DriverException {
        double[][] amuarray = new double[5000][2];
        String buff = this.getMSP();
        int blen = buff.length();
        int ichar = 0;
        int icrv = buff.indexOf(" CURVE ");
        if (icrv > 0) {
            int istart = buff.indexOf(" VALues ");
            if (istart > 0) {
                istart += 8;
            }
            ichar = istart;
            ByteBuffer curv = ByteBuffer.wrap(buff.substring(istart).getBytes());
            curv.order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer mspdat = curv.asShortBuffer();
            int idx = 0;
            while (ichar + 1 < blen) {
                double val;
                char thischar = buff.charAt(ichar);
                char nextchar = buff.charAt(ichar + 1);
                if (thischar == '\n' || nextchar == '\n') break;
                amuarray[idx][1] = val = (double)mspdat.get();
                ++idx;
                ichar += 2;
                System.out.println("ADC count = " + val);
            }
        }
        return amuarray;
    }

    public double[][] readDoublePairArray(String command) throws DriverException {
        try {
            System.out.println("Doing String Array read.");
            String[] reply = this.readStringArray(command);
            System.out.println("Retrieved string of values from buffer. length = " + reply.length);
            double[][] dReply = new double[2][reply.length / 2];
            int ridx = 0;
            for (int j = 0; j < reply.length; j += 2) {
                dReply[0][ridx] = Double.valueOf(reply[j]);
                dReply[1][ridx] = Double.valueOf(reply[j + 1]);
                ++ridx;
            }
            System.out.println("Binary array prepared.");
            return dReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException(e);
        }
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

