/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.ascii.AsciiIOFtdi;
import org.lsst.ccs.drivers.ascii.AsciiIONet;
import org.lsst.ccs.drivers.ascii.AsciiIOSerial;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Ascii {
    public static final int CONN_TYPE_NETWORK = 0;
    public static final int CONN_TYPE_FTDI = 1;
    public static final int CONN_TYPE_SERIAL = 2;
    static final int PARITY_NONE = 0;
    static final int PARITY_ODD = 1;
    static final int PARITY_EVEN = 2;
    static final int PARITY_MARK = 3;
    static final int PARITY_SPACE = 4;
    static final int DBITS_EIGHT = 0;
    static final int DBITS_SEVEN = 1;
    static final int SBITS_ONE = 0;
    static final int SBITS_TWO = 1;
    static final int FLOW_NONE = 0;
    static final int FLOW_RTS_CTS = 1;
    static final int FLOW_DTR_DSR = 2;
    static final int FLOW_XON_XOFF = 4;
    private static final Map<Integer, ConnType> typeMap = new HashMap<Integer, ConnType>();
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final byte[] buff = new byte[4096];
    private final boolean noNet;
    private final boolean noSerial;
    private AsciiIO io;
    private String terminator = "\r\n";
    private int timeout = 1000;
    private int buffIn;
    private int buffOut;

    public Ascii() {
        this.noNet = false;
        this.noSerial = false;
    }

    public Ascii(Option option) {
        this.noNet = option == Option.NO_NET;
        this.noSerial = option == Option.NO_SERIAL;
    }

    public synchronized void open(ConnType type, String ident, int parm1, int parm2) throws DriverException {
        AsciiIO newIo;
        if (this.io != null) {
            throw new DriverException("Device already connected");
        }
        switch (type) {
            case NET: {
                if (this.noNet) {
                    throw new DriverException("Network connection not allowed");
                }
                newIo = new AsciiIONet();
                break;
            }
            case FTDI: {
                if (this.noSerial) {
                    throw new DriverException("FTDI connection not allowed");
                }
                newIo = new AsciiIOFtdi();
                break;
            }
            case SERIAL: {
                if (this.noSerial) {
                    throw new DriverException("Serial connection not allowed");
                }
                newIo = new AsciiIOSerial();
                break;
            }
            default: {
                throw new DriverException("Connection type not handled: " + (Object)((Object)type));
            }
        }
        newIo.open(ident, parm1, parm2);
        this.io = newIo;
        this.io.setTimeout(this.timeout);
    }

    public void open(ConnType type, String ident, int parm) throws DriverException {
        this.open(type, ident, parm, 0);
    }

    @Deprecated
    public final void open(int type, String ident, int parm1, int parm2) throws DriverException {
        ConnType cType = typeMap.get(type);
        if (cType == null) {
            throw new DriverException("Invalid connection type: " + type);
        }
        this.open(cType, ident, parm1, parm2);
    }

    @Deprecated
    public void open(int type, String ident, int parm) throws DriverException {
        this.open(type, ident, parm, 0);
    }

    public static int makeDataCharacteristics(DataBits dataBits, StopBits stopBits, Parity parity, FlowCtrl flowCtrl) {
        return dataBits.getValue() << 24 | stopBits.getValue() << 16 | parity.getValue() << 8 | flowCtrl.getValue();
    }

    public synchronized void close() throws DriverException {
        this.checkOpen();
        try {
            this.io.close();
        }
        finally {
            this.io = null;
            this.buffOut = 0;
            this.buffIn = 0;
        }
    }

    public boolean closeSilent() {
        try {
            this.close();
            return true;
        }
        catch (DriverException e) {
            return false;
        }
    }

    public synchronized void write(String command) throws DriverException {
        this.checkOpen();
        this.writeBytes((command + this.terminator).getBytes());
    }

    public synchronized String read() throws DriverException {
        this.checkOpen();
        StringBuilder sBuff = null;
        try {
            int start = this.buffOut;
            int end = this.buffIn;
            int term = -1;
            while (true) {
                for (int j = start; j < end; ++j) {
                    if (this.buff[j] != 13 && this.buff[j] != 10) continue;
                    if (j == this.buffOut) {
                        ++this.buffOut;
                        continue;
                    }
                    term = j;
                    break;
                }
                if (term >= 0) {
                    String resp = new String(this.buff, this.buffOut, term - this.buffOut);
                    this.buffOut = term + 1;
                    if (sBuff == null) {
                        return resp;
                    }
                    return sBuff.append(resp).toString();
                }
                if (this.buffOut > 0) {
                    System.arraycopy(this.buff, this.buffOut, this.buff, 0, this.buffIn - this.buffOut);
                    this.buffIn -= this.buffOut;
                    this.buffOut = 0;
                }
                if (this.buffIn >= this.buff.length) {
                    if (sBuff == null) {
                        sBuff = new StringBuilder(new String(this.buff));
                    } else {
                        sBuff.append(new String(this.buff));
                    }
                    this.buffOut = 0;
                    this.buffIn = 0;
                }
                start = this.buffIn;
                this.buffIn += this.readBytes(this.buff, this.buffIn);
                end = this.buffIn;
            }
        }
        catch (DriverTimeoutException re) {
            throw re;
        }
        catch (DriverException re) {
            this.closeSilent();
            throw re;
        }
    }

    public synchronized String read(String command) throws DriverException {
        this.flush();
        this.write(command);
        return this.read();
    }

    public void writeBytes(byte[] command) throws DriverException {
        this.checkOpen();
        this.writeBytes(command, 0, command.length);
    }

    public void writeBytes(byte[] command, int offset, int leng) throws DriverException {
        this.checkOpen();
        this.io.write(command, offset, leng);
    }

    public int readBytes(byte[] buff, int offset) throws DriverException {
        this.checkOpen();
        return this.readBytes(buff, offset, buff.length - offset);
    }

    public int readBytes(byte[] buff, int offset, int leng) throws DriverException {
        this.checkOpen();
        return this.io.read(buff, offset, leng);
    }

    public synchronized void flush() throws DriverException {
        this.checkOpen();
        this.buffIn = this.buffOut;
        this.io.flush();
    }

    public void setTerminator(String term) {
        this.terminator = term;
    }

    public void setTimeout(double time) throws DriverException {
        this.setTimeout((int)(1000.0 * time));
    }

    public synchronized void setTimeout(int time) throws DriverException {
        this.timeout = time;
        if (this.io != null) {
            this.io.setTimeout(this.timeout);
        }
    }

    private void checkOpen() throws DriverException {
        if (this.io == null) {
            throw new DriverException("Device not connected");
        }
    }

    static {
        typeMap.put(0, ConnType.NET);
        typeMap.put(1, ConnType.FTDI);
        typeMap.put(2, ConnType.SERIAL);
    }

    public static enum FlowCtrl {
        NONE(0),
        RTS(1),
        DTR(2),
        XON(4),
        RTS_DTR(3),
        RTS_XON(5),
        DTR_XON(6),
        RTS_DTR_XON(7);

        int value;

        private FlowCtrl(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum StopBits {
        ONE(0),
        TWO(1);

        int value;

        private StopBits(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum DataBits {
        SEVEN(1),
        EIGHT(0);

        int value;

        private DataBits(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum Parity {
        NONE(0),
        ODD(1),
        EVEN(2),
        MARK(3),
        SPACE(4);

        int value;

        private Parity(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum ConnType {
        NET,
        FTDI,
        SERIAL;

    }

    public static enum Option {
        NO_NET,
        NO_SERIAL;

    }
}

