/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpvacmon;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class GP835
extends Scpi {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r";
    private int timeout = 1000;
    private double minCurrent = 3.0;
    private double maxCurrent = 24.0;
    private int minPower = 40;
    private int maxPower = 300;

    public void open(int itype, String serialname, int baud) throws DriverException {
        this.init();
        super.open(itype, serialname, baud);
    }

    public void openftdi(String serialname, int baud) throws DriverException {
        this.init();
        System.out.println("opening connection to the GP Vacuum Quality Monitor");
        this.open(1, serialname, baud);
    }

    public void init() {
        this.setTerminator(this.terminator);
    }

    public void close() throws DriverException {
        this.close();
    }

    public void reset() throws DriverException {
        this.writeGP835("RST");
    }

    public String getStatus() throws DriverException {
        return this.readGP835("STB?");
    }

    public int stripStatus(String status) throws DriverException {
        if (status.contains("STB")) {
            return Integer.parseInt(status.substring(3), 16);
        }
        return Integer.parseInt(status, 16);
    }

    public int getState() throws DriverException {
        return this.stripStatus(this.getStatus());
    }

    public int stripError(String err) throws DriverException {
        if (err.contains("ESR")) {
            return Integer.parseInt(err.substring(3), 16);
        }
        return Integer.parseInt(err, 16);
    }

    public String getError() throws DriverException {
        return this.readGP835("ESR?");
    }

    public String getIdent() throws DriverException {
        return this.readGP835("IDN?");
    }

    public double getPressure() throws DriverException {
        return Double.valueOf(this.readGP835("INST ETPR;OUTP ON;MEAS:PRES?"));
    }

    public void setGaugeOn() throws DriverException {
        this.writeGP835("INST MSP;OUTP ON");
    }

    public void setGaugeOff() throws DriverException {
        this.writeGP835("INST MSP;OUTP OFF");
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeGP835(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readGP835() throws DriverException {
        return this.read();
    }

    public synchronized String readGP835(String command) throws DriverException {
        this.writeGP835(command);
        return this.readGP835();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

