/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpio;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpio.GPIODriver;

public class GPIODriverUno1483
extends GPIODriver {
    private final List<GPIODriver.GPIOChip> GPIOChipsByIndex = new ArrayList<GPIODriver.GPIOChip>();
    private final List<GPIOChannelUno1483> GPIOChannelsByIndex = new ArrayList<GPIOChannelUno1483>();
    private RandomAccessFile advgpio;
    private int fd;
    public static final int SETGPIODIR = 28679;
    public static final int GETGPIODIR = 28680;
    public static final int ECSETGPIOSTATUS = 28681;
    public static final int ECGETGPIOSTATUS = 28682;
    public static final int DIR_IN = 128;
    public static final int DIR_OUT = 64;
    public static final int OUTPUT_LOW = 0;
    public static final int OUTPUT_HIGH = 1;

    public GPIODriverUno1483() throws DriverException {
        try {
            this.advgpio = new RandomAccessFile("/dev/advgpio", "rw");
            Field fdField = FileDescriptor.class.getDeclaredField("fd");
            fdField.setAccessible(true);
            this.fd = (Integer)fdField.get(this.advgpio.getFD());
        }
        catch (Exception e) {
            throw new DriverException("Could not open Uno1483 GPIO driver", (Throwable)e);
        }
        this.GPIOChipsByIndex.add(new GPIODriver.GPIOChip(this, 0, 8, "gpiochip0", "Advantech GPIO"));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 0, "DI0", 0));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 1, "DI1", 1));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 2, "DI2", 2));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 3, "DI3", 3));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 4, "DO0", 4));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 5, "DO1", 5));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 6, "DO2", 6));
        this.GPIOChannelsByIndex.add(new GPIOChannelUno1483(0, 7, "DO3", 7));
    }

    @Override
    public List<? extends GPIODriver.GPIOChip> enumerateChips() throws DriverException {
        return this.GPIOChipsByIndex;
    }

    @Override
    public List<? extends GPIODriver.GPIOChannel> enumerateExportedChannels() throws DriverException {
        return this.GPIOChannelsByIndex;
    }

    @Override
    public GPIOChannelUno1483 getChannel(int channel) throws DriverException {
        if (channel < 0 || channel >= this.GPIOChannelsByIndex.size()) {
            throw new DriverException("Invalid channel " + channel);
        }
        return this.GPIOChannelsByIndex.get(channel);
    }

    @Override
    public boolean isExported(int channel) {
        return true;
    }

    @Override
    public GPIOChannelUno1483 export(int channel) throws DriverException {
        return this.getChannel(channel);
    }

    @Override
    public List<? extends GPIODriver.GPIOChannel> exportRange(int base, int ngpio) throws DriverException {
        ArrayList<GPIOChannelUno1483> result = new ArrayList<GPIOChannelUno1483>();
        for (int channel = base; channel < base + ngpio; ++channel) {
            result.add(this.getChannel(channel));
        }
        return result;
    }

    @Override
    public void unexport(int channel) throws DriverException {
    }

    @Override
    public void unexportRange(int base, int ngpio) throws DriverException {
    }

    public final class GPIOChannelUno1483
    extends GPIODriver.GPIOChannel {
        private GPIOChannelUno1483(int chip, int channel, String name, int offset) {
            super(chip, channel, name, offset);
        }

        @Override
        public GPIODriver.GPIOChannel.Direction getDirection() throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.data[1] = 0;
            data.write();
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28680, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in GETGPIODIR ioctl", (Throwable)e);
            }
            data.read();
            switch (data.data[1]) {
                case 128: {
                    return GPIODriver.GPIOChannel.Direction.IN;
                }
                case 64: {
                    return GPIODriver.GPIOChannel.Direction.OUT;
                }
            }
            throw new DriverException("Bad value returned from GETGPIODIR " + data.data[1]);
        }

        @Override
        public void setDirection(GPIODriver.GPIOChannel.Direction dir) throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.write();
            switch (dir) {
                case IN: {
                    data.data[1] = 128;
                    break;
                }
                case OUT: {
                    data.data[1] = 64;
                    break;
                }
                default: {
                    throw new DriverException("Bad value passed to SETGPIODIR");
                }
            }
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28679, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in SETGPIODIR ioctl", (Throwable)e);
            }
        }

        @Override
        public void set() throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.data[1] = 1;
            data.write();
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28681, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in ECSETGPIOSTATUS ioctl", (Throwable)e);
            }
        }

        @Override
        public void clear() throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.data[1] = 0;
            data.write();
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28681, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in ECSETGPIOSTATUS ioctl", (Throwable)e);
            }
        }

        @Override
        public boolean read() throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.data[1] = 0;
            data.write();
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28682, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in ECGETGPIOSTATUS ioctl", (Throwable)e);
            }
            data.read();
            return data.data[1] != 0;
        }

        @Override
        public void write(boolean value) throws DriverException {
            GpioIoctlData data = new GpioIoctlData();
            data.data[0] = this.offset;
            data.data[1] = value ? 1 : 0;
            data.write();
            try {
                libc.INSTANCE.ioctl(GPIODriverUno1483.this.fd, 28681, data.getPointer());
            }
            catch (LastErrorException e) {
                throw new DriverException("Error in ECSETGPIOSTATUS ioctl", (Throwable)e);
            }
        }

        @Override
        public void lock() throws DriverException {
        }

        @Override
        public void unlock() throws DriverException {
        }
    }

    public static class GpioIoctlData
    extends Structure {
        public int[] data = new int[2];

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("data");
        }
    }

    private static interface libc
    extends Library {
        public static final libc INSTANCE = Native.load("c", libc.class);

        public int ioctl(int var1, int var2, Pointer var3) throws LastErrorException;
    }
}

