package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *****************************************************************************
 **
 **  Program to possibly provoke excessive CPU usage.
 **
 **  @author Owen Saxton
 **
 *****************************************************************************
 */
public class TestUsage {


    private final static PrintStream out = System.out;
    private final Ftdi ftd = new Ftdi();


   /**
    **************************************************************************
    **
    **  Inner class for holding command line options.
    **
    **************************************************************************
    */
    private static class Options {

        @Option(name="-n", usage="node name")
        private String node;

        @Option(name="-s", usage="serial number")
        private String serial;

        @Option(name="-i", usage="device index")
        private int index = 0;

        @Option(name="-b", usage="baud rate")
        private int baud = 115200;

    }


   /**
    **************************************************************************
    **
    **  Main program.
    **
    **  @param  args  The command-line arguments
    **
    **  @throws  Exception
    **
    **************************************************************************
    */
    public static void main(String[] args) throws Exception
    {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser(optns);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            return;
        }
        (new TestUsage()).run(optns);
        System.exit(0);
        
    }


   /**
    **************************************************************************
    **
    **  Get and display the modem status.
    **
    **************************************************************************
    */
    private void run(Options optns) throws Exception
    {
        int count = 0;
        byte[] data = new byte[32];

        while (true) {
            ftd.open(optns.node, optns.index, optns.serial);
            ftd.setBaudrate(optns.baud);
            ftd.setDataCharacteristics(Ftdi.DATABITS_8, Ftdi.STOPBITS_1,
                                       Ftdi.PARITY_NONE);
            ftd.setTimeouts(1000, 0);
            ftd.enableEvents(Ftdi.EVENT_RXCHAR);
            try {
                //ftd.awaitEvent(1000);
                ftd.read(data);
            }
            catch (DriverTimeoutException e) {
            }
            ftd.close();
            out.print("\r" + ++count);
        }
    }

}
