package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 *****************************************************************************
 **
 **  Program to test multiple thread access.
 **
 **  @author Owen Saxton
 **
 *****************************************************************************
 */
public class TestThreads extends Thread {


    private final static PrintStream out = System.out;
    private final Ftdi ftd = new Ftdi();
    private int count;
    private final String serial;


    public TestThreads(int count, String serial) {
        this.count = count;
        this.serial = serial;
    }


    @Override
    public void run() {
        for (; count > 0; count--) {
            try {
                ftd.open(0, serial);
                ftd.close();
                //yield();
            }
            catch (DriverException e) {
                out.println(e);
                count = 0;
                break;
            }
        }
    }


    public boolean isDone() {
        return count == 0;
    }


   /**
    **************************************************************************
    **
    **  Main program.
    **
    **  @param  args  The command-line arguments
    **
    **************************************************************************
    */
    public static void main(String[] args)
    {
        List<TestThreads> threads = new ArrayList<>();
        int count = 0;
        if (args.length < 1) {
            out.println("No loop count supplied");
            System.exit(0);
        }
        try {
            count = Integer.valueOf(args[0]);
        }
        catch (NumberFormatException e) {
            out.println("Invalid loop count");
            System.exit(0);
        }
        if (args.length < 2) {
            out.println("No serial numbers supplied");
            System.exit(0);
        }
        for (int j = 1; j < args.length; j++) {
            TestThreads thread = new TestThreads(count, args[j]);
            threads.add(thread);
            thread.start();
        }
        while (true) {
            try {
                Thread.sleep(1000);
            }
            catch (InterruptedException e) {
            }
            boolean done = true;
            for (TestThreads thread : threads) {
                if (!thread.isDone()) {
                    done = false;
                }
            }
            if (done) {
                System.exit(0);
            }
        }
    }

}
