package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/**
 *****************************************************************************
 **
 **  Program to display the FTDI line modem status.
 **
 **  @author Owen Saxton
 **
 *****************************************************************************
 */
public class TestModem {

    private final static PrintStream out = System.out;
    private final Ftdi ftd = new Ftdi();


   /**
    **************************************************************************
    **
    **  Inner class for holding command line options.
    **
    **************************************************************************
    */
    private static class Options {

        @Option(name="-n", usage="node name")
        private String node;

        @Option(name="-s", usage="serial number")
        private String serial;

        @Option(name="-i", usage="device index")
        private int index = 0;

        @Option(name="-b", usage="baud rate")
        private int baud = 115200;

    }


   /**
    **************************************************************************
    **
    **  Main program.
    **
    **  @param  args  The command-line arguments
    **
    **  @throws  Exception
    **
    **************************************************************************
    */
    public static void main(String[] args) throws Exception
    {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser(optns);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            return;
        }
        (new TestModem()).run(optns);
        System.exit(0);
    }


   /**
    **************************************************************************
    **
    **  Get and display the modem status.
    **
    **************************************************************************
    */
    private void run(Options optns) throws Exception
    {
        ftd.open(optns.node, optns.index, optns.serial);
        ftd.setBaudrate(optns.baud);
        ftd.setDataCharacteristics(Ftdi.DATABITS_8, Ftdi.STOPBITS_1,
                                   Ftdi.PARITY_NONE);
        out.format("Modem status = %02x\n", ftd.getModemStatus());
        ftd.close();
    }

}
