package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 ******************************************************************************
 **
 **  Interface for the FTDI access routines
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public interface FtdiInterface {

    public void open(int index, String serial) throws DriverException;

    public void open(String node, int index, String serial)
        throws DriverException;

    public void close() throws DriverException;

    public void setBaudrate(int baudrate) throws DriverException;

    public void setDataCharacteristics(int wordLength, int stopBits, int parity)
        throws DriverException;

    public void setFlowControl(int flow) throws DriverException;

    public void setTimeouts(int rcveTimeout, int xmitTimeout)
        throws DriverException;

    public void setDtr(boolean set) throws DriverException;

    public void setRts(boolean set) throws DriverException;

    public void enableEvents(int mask) throws DriverException;

    public int awaitEvent(int timeout) throws DriverException;

    public int read(byte[] data) throws DriverException;

    public int read(byte[] data, int offset, int count) throws DriverException;

    public int write(byte[] data) throws DriverException;

    public int write(byte[] data, int offset, int count) throws DriverException;

    public int getQueueStatus() throws DriverException;

    public int getModemStatus() throws DriverException;

}
