/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.lsst.ccs.command.CommandInvocationException;

public class InputConversionEngine {
    public Object convertArgToType(String arg, Class type) throws CommandInvocationException {
        try {
            if (type.equals(String.class) || type.isInstance(arg)) {
                return arg;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                long value = Long.decode(arg);
                long sign = value >> 32;
                if (sign != 0L && sign != -1L) {
                    throw new NumberFormatException();
                }
                return (int)value;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return Long.decode(arg);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return Double.valueOf(arg);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return Float.valueOf(arg);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                if ("true".equalsIgnoreCase(arg)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(arg)) {
                    return Boolean.FALSE;
                }
                throw new CommandInvocationException("Error: Can't convert string '%s' to Boolean", arg);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, arg.toUpperCase());
            }
            Constructor c = type.getConstructor(String.class);
            return c.newInstance(arg);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new CommandInvocationException("Error: Can't instantiate class %s using string '%s'", (Throwable)ex, type.getName(), arg);
        }
        catch (IllegalArgumentException | NoSuchMethodException e) {
            throw new CommandInvocationException("Error: Can't convert string '%s' to class %s", (Throwable)e, arg, type.getName());
        }
    }
}

