/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;

public class FtdiLocal
implements FtdiInterface {
    private long handle;

    static {
        System.loadLibrary("Ftdi");
    }

    @Override
    public void open(int index, String serial) throws DriverException {
        if (this.handle != 0L) {
            throw new DriverException("Device is already open");
        }
        this.handle = this.openJNI(index, serial);
        this.setDtrJNI(this.handle);
        this.setRtsJNI(this.handle);
    }

    @Override
    public void open(String node, int index, String serial) throws DriverException {
        throw new DriverException("Invalid remote open call");
    }

    @Override
    public void close() throws DriverException {
        long hndl = this.getHandle();
        this.handle = 0L;
        this.closeJNI(hndl);
    }

    @Override
    public void setBaudrate(int baudrate) throws DriverException {
        this.setBaudrateJNI(this.getHandle(), baudrate);
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws DriverException {
        this.setDataCharacteristicsJNI(this.getHandle(), wordLength, stopBits, parity);
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws DriverException {
        this.setTimeoutsJNI(this.getHandle(), rcveTimeout, xmitTimeout);
    }

    @Override
    public void setDtr(boolean set) throws DriverException {
        if (set) {
            this.setDtrJNI(this.getHandle());
        } else {
            this.clrDtrJNI(this.getHandle());
        }
    }

    @Override
    public void setRts(boolean set) throws DriverException {
        if (set) {
            this.setRtsJNI(this.getHandle());
        } else {
            this.clrRtsJNI(this.getHandle());
        }
    }

    @Override
    public int read(byte[] data) throws DriverException {
        return this.readJNI(this.getHandle(), data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws DriverException {
        return this.readJNI(this.getHandle(), data, offset, count);
    }

    @Override
    public int write(byte[] data) throws DriverException {
        return this.writeJNI(this.getHandle(), data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws DriverException {
        return this.writeJNI(this.getHandle(), data, offset, count);
    }

    @Override
    public int getQueueStatus() throws DriverException {
        return this.getQueueStatusJNI(this.getHandle());
    }

    @Override
    public int getModemStatus() throws DriverException {
        return this.getModemStatusJNI(this.getHandle());
    }

    private long getHandle() throws DriverException {
        long hndl = this.handle;
        if (hndl == 0L) {
            throw new DriverException("Device is not open");
        }
        return hndl;
    }

    private native long openJNI(int var1, String var2) throws DriverException;

    private native void closeJNI(long var1) throws DriverException;

    private native void setBaudrateJNI(long var1, int var3) throws DriverException;

    private native void setDataCharacteristicsJNI(long var1, int var3, int var4, int var5) throws DriverException;

    private native void setTimeoutsJNI(long var1, int var3, int var4) throws DriverException;

    private native void setDtrJNI(long var1) throws DriverException;

    private native void clrDtrJNI(long var1) throws DriverException;

    private native void setRtsJNI(long var1) throws DriverException;

    private native void clrRtsJNI(long var1) throws DriverException;

    private native int readJNI(long var1, byte[] var3, int var4, int var5) throws DriverException;

    private native int writeJNI(long var1, byte[] var3, int var4, int var5) throws DriverException;

    private native int getQueueStatusJNI(long var1) throws DriverException;

    private native int getModemStatusJNI(long var1) throws DriverException;
}

