/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourceDirectory;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesTreeProperties;

public class ResourcesUtils {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static List<String> getResourcesInResourcesTreeByExtension(ResourcesTree tree, String extension, int depth) {
        ArrayList<String> resources = new ArrayList<String>();
        for (ResourceDirectory dir : tree.getResourceDirectoryList()) {
            for (String resource : dir.getResources()) {
                StringTokenizer t;
                if (extension != null && !resource.endsWith("." + extension) || depth > -1 && (t = new StringTokenizer(resource, FILE_SEPARATOR)).countTokens() > depth + 1 || resources.contains(resource)) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    public static List<String> getAllResourcesInResourcesTree(ResourcesTree tree) {
        return ResourcesUtils.getResourcesInResourcesTreeByExtension(tree, null, -1);
    }

    public static Properties getMergedPropertyFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedPropertyFile(tree, fileName, false);
    }

    public static Properties getMergedPropertyFile(ResourcesTree tree, String fileName, boolean useSystem) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, useSystem, null);
    }

    public static Properties getMergedProperties(ResourcesTree tree, String[] properties, boolean useSystem, ResourcesTreeProperties parentProps) {
        ResourcesTreeProperties props = parentProps;
        if (useSystem) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding System Properties to the properties chain");
            }
            props = new ResourcesTreeProperties("SystemProperties", null, props);
            props.putAll((Map<?, ?>)System.getProperties());
        }
        try {
            InputStream defaultsIn = Bootstrap.getLoaderClass().getResourceAsStream("/ccsDefaults.properties");
            if (defaultsIn != null) {
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    System.out.println("*** Adding Properties " + BootstrapUtils.getDistributionResourcesDirectory() + "ccsDefaults.properties to properties chain");
                }
                ResourcesTreeProperties parent = props;
                props = new ResourcesTreeProperties("ccsDefaults", BootstrapUtils.getDistributionResourcesDirectory(), parent);
                props.load(defaultsIn);
                String applicationName = Bootstrap.getBootstrapApplication();
                props.put("org.lsst.ccs.application.name", applicationName == null ? "" : applicationName);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        ListIterator<ResourceDirectory> reverseIterator = resourceList.listIterator(resourceList.size());
        while (reverseIterator.hasPrevious()) {
            ResourceDirectory dir = reverseIterator.previous();
            int i = 0;
            while (i < properties.length) {
                String propertyFile = properties[i];
                if (propertyFile != null) {
                    if (!propertyFile.endsWith(".properties")) {
                        propertyFile = String.valueOf(propertyFile) + ".properties";
                    }
                    String fileLocation = null;
                    if (dir.hasResource(propertyFile)) {
                        fileLocation = propertyFile;
                    }
                    if (propertyFile.contains(FILE_SEPARATOR) && fileLocation == null && dir.hasResource(propertyFile = propertyFile.substring(propertyFile.lastIndexOf(FILE_SEPARATOR) + 1))) {
                        fileLocation = propertyFile;
                    }
                    if (fileLocation != null) {
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(new File(dir.getResouceDirectoryPath(), fileLocation));
                                ResourcesTreeProperties parent = props;
                                props = new ResourcesTreeProperties(fileLocation, dir.getResouceDirectoryPath(), parent);
                                props.load(in);
                                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                                    System.out.println("*** Adding Properties " + dir.getResouceDirectoryPath() + fileLocation + " to properties chain");
                                }
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return props;
    }

    public static void printProperties(Properties props) {
        ResourcesTreeProperties p;
        System.out.println("*****************");
        if (props instanceof ResourcesTreeProperties) {
            p = (ResourcesTreeProperties)props;
            String output = "Properties from " + p.getPropertyFileName();
            if (p.getResourceDirectory() != null) {
                output = String.valueOf(output) + " in resource directory " + p.getResourceDirectory();
            }
            System.out.println(output);
        } else {
            System.out.println("External System properties");
        }
        for (Object key : props.keySet()) {
            System.out.println("\t" + key + " = " + props.getProperty((String)key));
        }
        if (props instanceof ResourcesTreeProperties && (p = (ResourcesTreeProperties)props).hasParent()) {
            ResourcesUtils.printProperties(p.getParent());
        }
    }

    public static void loadKeySetForProperties(Properties props, Set<Object> set) {
        Set<Object> propsKey = props.keySet();
        for (Object obj : propsKey) {
            if (set.contains(obj)) continue;
            set.add(obj);
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)props).getParent() != null) {
            ResourcesUtils.loadKeySetForProperties(((ResourcesTreeProperties)props).getParent(), set);
        }
    }

    public static Properties getFlatPropertiesObject(Properties props) {
        Properties newProps = new Properties();
        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(props);
        for (Object key : keys) {
            newProps.put(key, props.getProperty((String)key));
        }
        return newProps;
    }

    public static InputStream getResourceFromResourceTree(ResourcesTree tree, String resourceName) throws FileNotFoundException {
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        for (ResourceDirectory dir : resourceList) {
            if (dir.hasResource(resourceName)) {
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    System.out.println("*** Found resource " + dir.getResouceDirectoryPath() + resourceName);
                }
                return new FileInputStream(String.valueOf(dir.getResouceDirectoryPath()) + resourceName);
            }
            if (!resourceName.contains(FILE_SEPARATOR) || !dir.hasResource(resourceName = resourceName.substring(resourceName.lastIndexOf(FILE_SEPARATOR) + 1))) continue;
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Found resource " + dir.getResouceDirectoryPath() + resourceName);
            }
            return new FileInputStream(String.valueOf(dir.getResouceDirectoryPath()) + resourceName);
        }
        return null;
    }
}

