/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.util.ArrayList;
import java.util.List;

public class Token {
    private int index;
    private String string;

    public Token(int index, String string) {
        this.index = index;
        this.string = string;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getString() {
        return this.string;
    }

    public String toString() {
        return String.valueOf(this.string != null ? this.string : "(null)") + ":" + Integer.toString(this.index);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.string != null ? this.string.hashCode() : 0);
        return hash;
    }

    static List<Token> tokenize(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (input == null) {
            return result;
        }
        int state = 0;
        int tokenIndex = -1;
        StringBuilder token = new StringBuilder("");
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        state = 1;
                        tokenIndex = i;
                        token.append(ch);
                        break;
                    }
                    if (ch == '\"') {
                        state = 2;
                        tokenIndex = i;
                        break;
                    }
                    if (ch == '\'') {
                        state = 3;
                        tokenIndex = i;
                        break;
                    }
                    if (ch == '#') {
                        state = 4;
                        break;
                    }
                    state = 1;
                    tokenIndex = i;
                    token.append(ch);
                    break;
                }
                case 1: {
                    if (Character.isWhitespace(ch)) {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = 0;
                        break;
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        token.append(ch);
                        break;
                    }
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    if (ch == '#') {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = 4;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case 2: {
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case 3: {
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    assert (false) : "Unknown state in Shell.tokenize() state machine";
                    break;
                }
            }
            ++i;
        }
        if (state == 1 || state == 2 || state == 3) {
            result.add(new Token(tokenIndex, token.toString()));
        }
        return result;
    }

    public static String escapeString(String input) {
        StringBuilder escaped = new StringBuilder(input.length() + 10);
        escaped.append('\"');
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '\"') {
                escaped.append("\"\"");
            } else {
                escaped.append(input.charAt(i));
            }
            ++i;
        }
        escaped.append('\"');
        return escaped.toString();
    }
}

