/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jline.console.completer.Completer;
import org.lsst.ccs.shell.CLIException;
import org.lsst.ccs.shell.Command;
import org.lsst.ccs.shell.CommandTable;
import org.lsst.ccs.shell.ConsoleIO;
import org.lsst.ccs.shell.Input;
import org.lsst.ccs.shell.InputConversionEngine;
import org.lsst.ccs.shell.Output;
import org.lsst.ccs.shell.OutputConversionEngine;
import org.lsst.ccs.shell.Param;
import org.lsst.ccs.shell.ShellCommand;
import org.lsst.ccs.shell.ShellDependent;
import org.lsst.ccs.shell.ShellManageable;
import org.lsst.ccs.shell.Token;
import org.lsst.ccs.shell.TokenException;
import org.lsst.ccs.shell.util.ArrayHashMultiMap;
import org.lsst.ccs.shell.util.MultiMap;

public class Shell {
    public static String PROJECT_HOMEPAGE_URL = "http://cliche.sourceforge.net";
    private Output output;
    private Input input;
    private String appName;
    private CommandTable commandTable;
    private OutputConversionEngine outputConverter = new OutputConversionEngine();
    private InputConversionEngine inputConverter = new InputConversionEngine();
    private MultiMap<String, Object> auxHandlers = new ArrayHashMultiMap<String, Object>();
    private List<Object> allHandlers = new ArrayList<Object>();
    private Throwable lastException = null;
    private List<String> path;
    private static final String HINT_FORMAT = "This is %1$s, running on Cliche Shell\nFor more information on the Shell, enter ?help";
    private static final String TIME_MS_FORMAT_STRING = "time: %d ms";
    private boolean displayTime = false;

    public Settings getSettings() {
        return new Settings(this.input, this.output, this.auxHandlers, this.displayTime);
    }

    public void setSettings(Settings s) {
        this.input = s.input;
        this.output = s.output;
        this.displayTime = s.displayTime;
        for (String prefix : s.auxHandlers.keySet()) {
            for (Object handler : s.auxHandlers.get(prefix)) {
                this.addAuxHandler(handler, prefix);
            }
        }
    }

    public Shell(Settings s, CommandTable commandTable, List<String> path) {
        this.commandTable = commandTable;
        this.path = path;
        this.setSettings(s);
    }

    public CommandTable getCommandTable() {
        return this.commandTable;
    }

    public OutputConversionEngine getOutputConverter() {
        return this.outputConverter;
    }

    public InputConversionEngine getInputConverter() {
        return this.inputConverter;
    }

    public void addMainHandler(Object handler, String prefix) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.allHandlers.add(handler);
        this.addDeclaredMethods(handler, prefix);
        this.inputConverter.addDeclaredConverters(handler);
        this.outputConverter.addDeclaredConverters(handler);
        if (handler instanceof ShellDependent) {
            ((ShellDependent)handler).cliSetShell(this);
        }
    }

    public void addAuxHandler(Object handler, String prefix) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.auxHandlers.put(prefix, handler);
        this.allHandlers.add(handler);
        this.addDeclaredMethods(handler, prefix);
        this.inputConverter.addDeclaredConverters(handler);
        this.outputConverter.addDeclaredConverters(handler);
        if (handler instanceof ShellDependent) {
            ((ShellDependent)handler).cliSetShell(this);
        }
    }

    private void addDeclaredMethods(Object handler, String prefix) throws SecurityException {
        Method[] methodArray = handler.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Command annotation = m.getAnnotation(Command.class);
            if (annotation != null) {
                this.commandTable.addMethod(m, handler, prefix);
            }
            ++n2;
        }
    }

    @Command(description="Returns last thrown exception")
    public Throwable getLastException() {
        return this.lastException;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void addCompleter(Completer completer) {
        if (this.input instanceof ConsoleIO) {
            ((ConsoleIO)this.input).addCompleter(completer);
        }
    }

    public void commandLoop() throws IOException {
        for (Object handler : this.allHandlers) {
            if (!(handler instanceof ShellManageable)) continue;
            ((ShellManageable)handler).cliEnterLoop();
        }
        if (this.input instanceof ConsoleIO) {
            ((ConsoleIO)this.input).setCommandTable(this.commandTable);
        }
        this.output.output(this.appName, this.outputConverter);
        String command = "";
        while (!command.trim().equals("exit")) {
            try {
                command = this.input.readCommand(this.path);
                this.processLine(command);
            }
            catch (TokenException te) {
                this.lastException = te;
                this.output.outputException(command, te);
            }
            catch (CLIException clie) {
                this.lastException = clie;
                if (command.trim().equals("exit")) continue;
                this.output.outputException(clie);
            }
        }
        for (Object handler : this.allHandlers) {
            if (!(handler instanceof ShellManageable)) continue;
            ((ShellManageable)handler).cliLeaveLoop();
        }
    }

    private void outputHeader(String header, Object[] parameters) {
        if (header == null || header.isEmpty()) {
            this.output.outputHeader(null);
        } else {
            this.output.outputHeader(String.format(header, parameters));
        }
    }

    public void processLine(String line) throws CLIException {
        if (line.trim().equals("?")) {
            this.output.output(String.format(HINT_FORMAT, this.appName), this.outputConverter);
        } else {
            List<Token> tokens = Token.tokenize(line);
            if (tokens.size() > 0) {
                String discriminator = tokens.get(0).getString();
                this.processCommand(discriminator, tokens);
            }
        }
    }

    private void processCommand(String discriminator, List<Token> tokens) throws CLIException {
        long time;
        assert (discriminator != null);
        assert (!discriminator.equals(""));
        ShellCommand commandToInvoke = this.commandTable.lookupCommand(discriminator, tokens);
        Class[] paramClasses = commandToInvoke.getParameterTypes();
        Object[] parameters = this.inputConverter.convertToParameters(tokens, paramClasses, commandToInvoke.isVarArgs());
        this.outputHeader(commandToInvoke.getHeader(), parameters);
        long timeBefore = Calendar.getInstance().getTimeInMillis();
        Object invocationResult = commandToInvoke.invoke(parameters);
        long timeAfter = Calendar.getInstance().getTimeInMillis();
        if (invocationResult != null) {
            this.output.output(invocationResult, this.outputConverter);
        }
        if (this.displayTime && (time = timeAfter - timeBefore) != 0L) {
            this.output.output(String.format(TIME_MS_FORMAT_STRING, time), this.outputConverter);
        }
    }

    @Command(description="Turns command execution time display on and off")
    public void setDisplayTime(@Param(name="do-display-time", description="true if do display, false otherwise") boolean displayTime) {
        this.displayTime = displayTime;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public static class Settings {
        private final Input input;
        private final Output output;
        private final MultiMap<String, Object> auxHandlers;
        private final boolean displayTime;

        public Settings(Input input, Output output, MultiMap auxHandlers, boolean displayTime) {
            this.input = input;
            this.output = output;
            this.auxHandlers = auxHandlers;
            this.displayTime = displayTime;
        }

        public Settings createWithAddedAuxHandlers(MultiMap<String, Object> addAuxHandlers) {
            ArrayHashMultiMap<String, Object> allAuxHandlers = new ArrayHashMultiMap<String, Object>(this.auxHandlers);
            allAuxHandlers.putAll(addAuxHandlers);
            return new Settings(this.input, this.output, allAuxHandlers, this.displayTime);
        }
    }
}

