/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;

public class TalkFtdi {
    private static final PrintStream out = System.out;
    private final Thread readW = new Thread(new Reader());
    private Ftdi ftd = new Ftdi();
    private int nRead = 0;
    private int nByte = 0;
    private boolean open;

    public static void main(String[] args) throws Exception {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            return;
        }
        new TalkFtdi().run(optns);
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.ftd.open(optns.node, optns.index, optns.serial);
        this.ftd.setBaudrate(optns.baud);
        this.ftd.setDataCharacteristics(8, 0, 0);
        this.open = true;
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) {
                out.format("#reads: %s; #bytes: %s\n", this.nRead, this.nByte);
                continue;
            }
            this.ftd.write(line.getBytes());
        }
        this.open = false;
        this.ftd.close();
    }

    private static class Options {
        @Option(name="-n", usage="node name")
        private String node;
        @Option(name="-s", usage="serial number")
        private String serial;
        @Option(name="-i", usage="device index")
        private int index = 0;
        @Option(name="-b", usage="baud rate")
        private int baud = 115200;

        private Options() {
        }
    }

    private class Reader
    implements Runnable {
        byte[] data = new byte[1024];

        private Reader() {
        }

        @Override
        public void run() {
            while (true) {
                int leng;
                try {
                    leng = TalkFtdi.this.ftd.read(this.data, 0, 1);
                    int nread = TalkFtdi.this.ftd.getQueueStatus();
                    if (nread > this.data.length - leng) {
                        nread = this.data.length - leng;
                    }
                    if (!TalkFtdi.this.open) break;
                    leng += TalkFtdi.this.ftd.read(this.data, leng, nread);
                }
                catch (FtdiException e) {
                    if (!TalkFtdi.this.open) break;
                    out.println((Object)e);
                    break;
                }
                out.write(this.data, 0, leng);
                TalkFtdi talkFtdi = TalkFtdi.this;
                talkFtdi.nRead = talkFtdi.nRead + 1;
                TalkFtdi talkFtdi2 = TalkFtdi.this;
                talkFtdi2.nByte = talkFtdi2.nByte + leng;
            }
        }
    }
}

