/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.lang.reflect.Method;
import java.util.List;
import org.lsst.ccs.shell.CommandNamer;
import org.lsst.ccs.shell.util.Strings;

public class DashJoinedNamer
implements CommandNamer {
    private final boolean doRemoveCommonPrefix;

    public DashJoinedNamer(boolean doRemoveCommonPrefix) {
        this.doRemoveCommonPrefix = doRemoveCommonPrefix;
    }

    @Override
    public CommandNamer.NamingInfo nameCommand(Method method) {
        List<String> words = Strings.splitJavaIdentifier(method.getName());
        if (this.doRemoveCommonPrefix && words.size() > 1 && (words.get(0).equals("cmd") || words.get(0).equals("cli"))) {
            words.remove(0);
        }
        String name = Strings.joinStrings(words, true, '-');
        String[] abbrevs = this.proposeAbbrevs(words);
        return new CommandNamer.NamingInfo(name, abbrevs);
    }

    private String[] proposeAbbrevs(List<String> words) {
        if (words.size() == 1 && words.get(0).equals("exit")) {
            return new String[0];
        }
        String abbrev1 = "";
        for (String word : words) {
            assert (word.length() > 0);
            abbrev1 = String.valueOf(abbrev1) + Character.toLowerCase(word.charAt(0));
        }
        String abbrev2 = "";
        for (String word : words) {
            abbrev2 = String.valueOf(abbrev2) + Character.toLowerCase(word.charAt(0));
            if (word.length() <= 1) continue;
            abbrev2 = String.valueOf(abbrev2) + Character.toLowerCase(word.charAt(1));
        }
        if (!abbrev2.isEmpty()) {
            return new String[]{abbrev1, abbrev2};
        }
        return new String[]{abbrev1};
    }
}

