package org.lsst.ccs.drivers.edtcl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;

public class CLImage {

    public native static void setup(int w, int h) throws EDTException;

    public native static void start(int nImages) throws EDTException;

    public native static short[][] getImage() throws EDTException;

    public native static void close() throws EDTException;

    static {
        System.loadLibrary("jedt");
    }

    public static void main(String argv[]) throws Exception {
        setup(8672, 2022);
        start(2);
        short[][] im1 = getImage();
        System.out.println("got image 1 " + im1.length + " " + im1[0].length);
        FileOutputStream st = new FileOutputStream("frame1");
        DataOutputStream dt = new DataOutputStream(new BufferedOutputStream(st));
        for (int i = 0; i < im1.length; i++)
            for (int j = 0; j < im1[i].length; j++)
                dt.writeShort(im1[i][j]);
        dt.close();
        short[][] im2 = getImage();
        System.out.println("got image 2");
        st = new FileOutputStream("frame2");
        dt = new DataOutputStream(new BufferedOutputStream(st));
        for (int i = 0; i < im2.length; i++)
            for (int j = 0; j < im2[i].length; j++)
                dt.writeShort(im2[i][j]);
        dt.close();
	close();
    }

}
