/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CompositeCommandDictionary;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.SupportedOption;

public abstract class DictionaryUtils {
    static final Map<DictionaryCommand, String> commandHelp = new HashMap<DictionaryCommand, String>();

    private DictionaryUtils() {
    }

    static String basicHelpForDictionary(Dictionary dict) {
        return DictionaryUtils.basicHelpForDictionary(dict, new Options());
    }

    static String basicHelpForDictionary(Dictionary dict, Options opts) {
        return DictionaryUtils.basicHelpForDictionary(dict, "", opts);
    }

    static String basicHelpForDictionary(Dictionary dict, String indent) {
        return DictionaryUtils.basicHelpForDictionary(dict, indent, new Options());
    }

    static String basicHelpForDictionary(Dictionary dict, String indent, Options opts) {
        StringBuilder helpOut = new StringBuilder();
        List<DictionaryCommand> sorted = new ArrayList<DictionaryCommand>();
        sorted = DictionaryUtils.fillListOfCommands(dict, sorted);
        Collections.sort(sorted, new CommandDefinitionComparator());
        DictionaryHelpGenerator helpGenerator = dict.getHelpGenerator();
        boolean showTargets = opts.hasOption(SupportedOption.getSupportedOption("targets"));
        for (DictionaryCommand def : sorted) {
            if (!showTargets && def instanceof RoutingCommandSet.RoutingCommand) continue;
            String help = DictionaryUtils.basicHelpForCommand(def);
            if (helpGenerator != null && helpGenerator.hasHelp(def)) {
                help = helpGenerator.modifyHelpForCommand(def, help, true);
            }
            helpOut.append(indent).append(help);
        }
        return helpOut.toString();
    }

    private static List<DictionaryCommand> fillListOfCommands(Dictionary dict, List<DictionaryCommand> l) {
        if (dict instanceof RoutingCommandSet.RoutingDictionary && ((RoutingCommandSet.RoutingDictionary)dict).isRouteAvailable() && !((RoutingCommandSet.RoutingDictionary)dict).hasVisibleCommands()) {
            return l;
        }
        if (dict instanceof CompositeCommandDictionary) {
            CompositeCommandDictionary ccd = (CompositeCommandDictionary)dict;
            for (Dictionary d : ccd.getDictionaries()) {
                DictionaryUtils.fillListOfCommands(d, l);
            }
        } else {
            for (DictionaryCommand def : dict.filterByVisibilityIterator()) {
                l.add(def);
            }
        }
        return l;
    }

    static String basicHelpForCommand(DictionaryCommand def) {
        if (commandHelp.containsKey(def)) {
            return commandHelp.get(def);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(def.getCommandName());
        for (DictionaryArgument param : def.getArguments()) {
            List<String> allowedValues = param.getAllowedValues();
            builder.append(' ').append(allowedValues.size() == 1 ? allowedValues.get(0) : param.getName());
        }
        if (def.isVarArgs()) {
            builder.append("...");
        }
        if (builder.length() <= 30) {
            for (int i = builder.length(); i < 31; ++i) {
                builder.append(" ");
            }
        } else {
            builder.append("\n                               ");
        }
        builder.append(def.getDescription()).append("\n");
        if (def.hasOptions()) {
            builder.append("    supported options:\n");
            for (SupportedOption opt : def.getSupportedOptions()) {
                builder.append("                   --").append(opt.getName()).append(", -").append(opt.getSingleLetterName()).append("\t").append(opt.getDescription()).append("\n");
            }
            builder.append("\n");
        }
        if (def.getAliases().length > 0) {
            builder.append("    aliases:");
            for (String alias : def.getAliases()) {
                builder.append(" ").append(alias);
            }
            builder.append("\n");
        }
        String result = builder.toString();
        commandHelp.put(def, result);
        return result;
    }

    static DictionaryCommand findCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.findCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException ex) {
            return null;
        }
    }

    static boolean containsCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.containsCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException ex) {
            return false;
        }
    }

    static boolean containsDictionaryCommand(Dictionary dict, DictionaryCommand newCmd) {
        for (DictionaryCommand oldCommand : dict) {
            ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
            cmdNameOrAliases.add(oldCommand.getCommandName());
            String[] aliases = oldCommand.getAliases();
            if (aliases != null) {
                cmdNameOrAliases.addAll(Arrays.asList(aliases));
            }
            for (String cmdNameOrAlias : cmdNameOrAliases) {
                if (!newCmd.getCommandName().equals(cmdNameOrAlias)) continue;
                if (newCmd.isVarArgs() && oldCommand.isVarArgs()) {
                    return true;
                }
                if (newCmd.isVarArgs() && newCmd.getArguments().length - 1 <= oldCommand.getArguments().length) {
                    return true;
                }
                if (oldCommand.isVarArgs() && oldCommand.getArguments().length - 1 <= newCmd.getArguments().length) {
                    return true;
                }
                if (newCmd.getArguments().length == oldCommand.getArguments().length) {
                    boolean isOk = false;
                    int i = 0;
                    int nArgs = newCmd.getArguments().length;
                    if (i < nArgs) {
                        DictionaryArgument newArg = newCmd.getArguments()[i];
                        DictionaryArgument oldArg = oldCommand.getArguments()[i];
                        if (newArg.getAllowedValues().isEmpty() || oldArg.getAllowedValues().isEmpty()) {
                            return true;
                        }
                        ArrayList<String> allowedValues = new ArrayList<String>(newArg.getAllowedValues());
                        allowedValues.retainAll(oldArg.getAllowedValues());
                        if (!allowedValues.isEmpty()) {
                            return true;
                        }
                        isOk = true;
                    }
                    if (isOk) continue;
                    return true;
                }
                int oldMaxArgs = oldCommand.getArguments().length;
                int oldMinArgs = DictionaryUtils.getDictionaryCommandMinArguments(oldCommand);
                int newMaxArgs = newCmd.getArguments().length;
                int newMinArgs = DictionaryUtils.getDictionaryCommandMinArguments(newCmd);
                if (newMinArgs <= oldMaxArgs && newMinArgs >= oldMinArgs) {
                    return true;
                }
                if (newMaxArgs > oldMaxArgs || newMaxArgs < oldMinArgs) continue;
                return true;
            }
        }
        return false;
    }

    private static int getDictionaryCommandMinArguments(DictionaryCommand dc) {
        int minArgs = 0;
        for (DictionaryArgument a : dc.getArguments()) {
            if (a.hasDefaultValue()) continue;
            ++minArgs;
        }
        return minArgs;
    }

    static boolean commandMatch(DictionaryCommand def, BasicCommand tc) throws CommandArgumentMatchException {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
        cmdNameOrAliases.add(def.getCommandName());
        String[] aliases = def.getAliases();
        if (aliases != null) {
            cmdNameOrAliases.addAll(Arrays.asList(aliases));
        }
        for (String cmdNameOrAlias : cmdNameOrAliases) {
            if (!cmdNameOrAlias.equals(command)) continue;
            boolean argumentCountOk = false;
            int cmdNumberOfArguments = def.getArguments().length;
            if (argumentCount == cmdNumberOfArguments) {
                argumentCountOk = true;
            } else if (argumentCount >= cmdNumberOfArguments - 1 && def.isVarArgs()) {
                argumentCountOk = true;
            } else if (argumentCount < cmdNumberOfArguments) {
                argumentCountOk = true;
                for (int i = argumentCount; i < cmdNumberOfArguments; ++i) {
                    if (def.getArguments()[i].hasDefaultValue()) continue;
                    argumentCountOk = false;
                    break;
                }
            }
            if (!argumentCountOk) continue;
            if (argumentCount == 0) {
                return true;
            }
            Object[] argValues = tc.getArguments();
            if (argValues != null) {
                boolean argMatch = true;
                for (int i = 0; i < argValues.length; ++i) {
                    if (i >= def.getArguments().length) {
                        return true;
                    }
                    List<String> allowedValues = def.getArguments()[i].getAllowedValues();
                    if (allowedValues != null && !allowedValues.isEmpty()) {
                        argMatch = false;
                        for (String allowedValue : allowedValues) {
                            if (!allowedValue.toLowerCase().equals(argValues[i].toString().toLowerCase())) continue;
                            argMatch = true;
                            break;
                        }
                    }
                    if (argMatch) continue;
                    DictionaryArgument[] args = def.getArguments();
                    String[] names = new String[args.length];
                    for (int j = 0; j < args.length; ++j) {
                        names[j] = args[j].getName();
                    }
                    throw new CommandArgumentMatchException(tc.getCommand(), i, names, String.valueOf(argValues[i]), allowedValues);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean areDictionariesEqual(Dictionary d1, Dictionary d2) {
        if (d1.getClass() != d2.getClass()) {
            return false;
        }
        if (d1.size() != d2.size()) {
            return false;
        }
        for (DictionaryCommand dc1 : d1) {
            DictionaryCommand dc2 = DictionaryUtils.findCommand(d2, dc1.getCommandName(), dc1.getArguments().length);
            if (dc2 == null) {
                return false;
            }
            if (DictionaryUtils.areDictionaryCommandsEqual(dc1, dc2)) continue;
            return false;
        }
        return true;
    }

    public static boolean areDictionaryCommandsEqual(DictionaryCommand dc1, DictionaryCommand dc2) {
        if (dc2.getCommandName().equals(dc1.getCommandName()) && dc2.isAutoAck() == dc1.isAutoAck() && dc2.isVarArgs() == dc1.isVarArgs() && Arrays.equals(dc2.getAliases(), dc1.getAliases()) && dc2.getCategory() == dc1.getCategory() && (dc2.getDescription() == null ? dc1.getDescription() == null : dc2.getDescription().equals(dc1.getDescription())) && dc2.getLevel() == dc1.getLevel() && dc2.getTimeout() == dc1.getTimeout() && dc2.getType() == dc1.getType()) {
            return DictionaryUtils.areDictionaryArgumentsEqual(dc1.getArguments(), dc2.getArguments());
        }
        return false;
    }

    public static boolean areDictionaryArgumentsEqual(DictionaryArgument[] da1s, DictionaryArgument[] da2s) {
        if (da2s.length == da1s.length) {
            for (int i = 0; i < da2s.length; ++i) {
                DictionaryArgument da2 = da2s[i];
                DictionaryArgument da1 = da1s[i];
                if (!da2.hasDefaultValue() && da1.hasDefaultValue()) {
                    return false;
                }
                if (da2.getDefaultValue() == null ? da1.getDefaultValue() != null : !da2.getDefaultValue().equals(da1.getDefaultValue())) {
                    return false;
                }
                if (!da2.getDescription().equals(da1.getDescription())) {
                    return false;
                }
                if (!da2.getName().equals(da1.getName())) {
                    return false;
                }
                if (!da2.getSimpleType().equals(da1.getSimpleType())) {
                    return false;
                }
                if (!da2.getType().equals(da1.getType())) {
                    return false;
                }
                if (da2.getAllowedValues().equals(da1.getAllowedValues())) continue;
                return false;
            }
        }
        return true;
    }

    private static class CommandDefinitionComparator
    implements Comparator<DictionaryCommand> {
        private CommandDefinitionComparator() {
        }

        @Override
        public int compare(DictionaryCommand o1, DictionaryCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }

    private static class BasicCommandNullArgs
    implements BasicCommand {
        private static final long serialVersionUID = -744230510544974099L;
        private final String commandName;
        private final int argumentCount;

        BasicCommandNullArgs(String commandName, int argumentCount) {
            this.commandName = commandName;
            this.argumentCount = argumentCount;
        }

        @Override
        public int getArgumentCount() {
            return this.argumentCount;
        }

        @Override
        public String getCommand() {
            return this.commandName;
        }

        @Override
        public Object getArgument(int i) {
            return null;
        }

        @Override
        public Object[] getArguments() {
            return null;
        }

        public String toString() {
            return this.prettyToString();
        }

        @Override
        public Options getOptions() {
            return new Options();
        }
    }
}

