/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.eaton;

import java.io.IOException;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.eaton.EpduG3;

public class TestEpduG3 {
    private static final PrintStream out = System.out;
    private final EpduG3 pdu = new EpduG3();

    @Command(name="open", description="Open connection to a PDU")
    public void open(@Argument(name="conntype", description="Connection type") Session.ConnType connType, @Argument(name="devcid", description="Device ID") String devcId, @Argument(name="username", description="User name") String userName, @Argument(name="password", description="Password") String password) throws DriverException {
        this.pdu.open(connType, devcId, userName, password);
    }

    @Command(name="open", description="Open connection to a PDU")
    public void open(@Argument(name="conntype", description="Connection type") Session.ConnType connType, @Argument(name="devcid", description="Device ID") String devcId) throws DriverException {
        this.pdu.open(connType, devcId);
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.pdu.close();
    }

    @Command(name="product", description="Show the product name")
    public String product() throws DriverException {
        return this.pdu.getProductName();
    }

    @Command(name="serial", description="Show the serial number")
    public String serial() throws DriverException {
        return this.pdu.getSerialNumber();
    }

    @Command(name="version", description="Show the firmware version")
    public String version() throws DriverException {
        return this.pdu.getFWVersion();
    }

    @Command(name="temperature", description="Show the temperature")
    public String temperature() throws DriverException {
        return String.format("%.2f C", this.pdu.readTemperature());
    }

    @Command(name="outletcount", description="Show the outlet count")
    public String outletCount() throws DriverException {
        return "Outlet count: " + this.pdu.getOutletCount();
    }

    @Command(name="outletstate", description="Show the state of an outlet")
    public String outletState(@Argument(name="outlet", description="Outlet number") int outlet) throws DriverException {
        return this.pdu.isOutletOn(outlet) ? "on" : "off";
    }

    @Command(name="outletstate", description="Show the state of all outlets")
    public String outletState() throws DriverException {
        boolean[] states = this.pdu.getOutletOnStates();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < states.length; ++j) {
            if (j % 6 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %s", j + 1, states[j] ? "on " : "off"));
        }
        return text.toString();
    }

    @Command(name="outleton", description="Turn outlet power on")
    public void outletOn(@Argument(name="outlet", description="Outlet number") int outlet) throws DriverException {
        this.pdu.powerOutletOn(outlet, 0);
    }

    @Command(name="outleton", description="Turn outlet power on")
    public void outletOn(@Argument(name="outlet", description="Outlet number") int outlet, @Argument(name="delay", description="Delay (sec)") int delay) throws DriverException {
        this.pdu.powerOutletOn(outlet, delay);
    }

    @Command(name="outletoff", description="Turn outlet power off")
    public void outletOff(@Argument(name="outlet", description="Outlet number") int outlet) throws DriverException {
        this.pdu.powerOutletOff(outlet, 0);
    }

    @Command(name="outletoff", description="Turn outlet power off")
    public void outletOff(@Argument(name="outlet", description="Outlet number") int outlet, @Argument(name="delay", description="Delay (sec)") int delay) throws DriverException {
        this.pdu.powerOutletOff(outlet, delay);
    }

    @Command(name="outletcurrent", description="Show outlet current")
    public String outletCurrent(@Argument(name="outlet", description="Outlet number") int outlet) throws DriverException {
        return String.format("%.3f amps", this.pdu.readOutletCurrent(outlet));
    }

    @Command(name="outletcurrent", description="Show all outlet currents")
    public String outletCurrent() throws DriverException {
        double[] currents = this.pdu.readOutletCurrent();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < currents.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.3f", j + 1, currents[j]));
        }
        return text.toString();
    }

    @Command(name="outletpower", description="Show outlet power")
    public String outletPower(@Argument(name="outlet", description="Outlet number") int outlet) throws DriverException {
        return String.format("%.2f watts", this.pdu.readOutletPower(outlet));
    }

    @Command(name="outletpower", description="Show all outlet power values")
    public String outletPower() throws DriverException {
        double[] powers = this.pdu.readOutletPower();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < powers.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.2f", j + 1, powers[j]));
        }
        return text.toString();
    }

    @Command(name="talk", description="Talk to the PDU interactively")
    public void talk() throws DriverException, IOException {
        String cmnd;
        out.println("Type ctrl-D to exit");
        ConsoleReader reader = new ConsoleReader();
        while ((cmnd = reader.readLine(this.pdu.getPrompt())) != null) {
            this.pdu.send(cmnd);
            String[] resp = this.pdu.receive();
            for (int j = 1; j < resp.length; ++j) {
                out.println(resp[j]);
            }
        }
        out.println();
    }
}

