/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.eaton;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class EpduG3
extends Session {
    private static final int DEFAULT_BAUDRATE = 9600;
    private static final int LOG_TIMEOUT = 50;
    private static final int RUN_TIMEOUT = 50;
    private Integer numPhases;
    private Integer numGangs;
    private Integer numOutlets;

    public EpduG3() {
        super(1, "pdu#", "Login:", "Password:", null, Ascii.Terminator.CR);
    }

    public void open(Session.ConnType connType, String ident, String username, String password) throws DriverException {
        this.open(connType, ident, 9600, username, password, 50, 50);
    }

    public void open(Session.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 9600, 50);
    }

    @Override
    public void close() throws DriverException {
        try {
            super.close();
        }
        finally {
            this.numPhases = null;
            this.numGangs = null;
            this.numOutlets = null;
        }
    }

    public String getProductName() throws DriverException {
        return this.receiveString("get PDU.PowerSummary.iProduct");
    }

    public String getSerialNumber() throws DriverException {
        return this.receiveString("get PDU.PowerSummary.iSerialNumber");
    }

    public String getFWVersion() throws DriverException {
        return this.receiveString("get PDU.PowerSummary.iVersion");
    }

    public double readTemperature() throws DriverException {
        return this.receiveDouble("get PDU.PowerSummary.Temperature") - 273.15;
    }

    public int getPhaseCount() throws DriverException {
        if (this.numPhases == null) {
            this.numPhases = this.receiveInt("get PDU.Input[1].Phase.Count");
        }
        return this.numPhases;
    }

    public int getGangCount() throws DriverException {
        if (this.numGangs == null) {
            this.numGangs = this.receiveInt("get PDU.Gang.Count");
        }
        return this.numGangs;
    }

    public int getGangPhase(int gang) throws DriverException {
        this.checkGangNumber(gang);
        return this.receiveInt("get PDU.Gang[" + gang + "].PhaseID");
    }

    public int[] getGangPhase() throws DriverException {
        return this.receiveInts("get PDU.Gang[x].PhaseID");
    }

    public double readGangVoltage(int gang) throws DriverException {
        this.checkGangNumber(gang);
        return this.receiveDouble("get PDU.Gang[" + gang + "].Voltage");
    }

    public double[] readGangVoltage() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.Gang[x].Voltage");
        this.equalsGangCount(values.length);
        return values;
    }

    public double readGangCurrent(int gang) throws DriverException {
        this.checkGangNumber(gang);
        return this.receiveDouble("get PDU.Gang[" + gang + "].Current");
    }

    public double[] readGangCurrent() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.Gang[x].Current");
        this.equalsGangCount(values.length);
        return values;
    }

    public double readGangPower(int gang) throws DriverException {
        this.checkGangNumber(gang);
        return this.receiveDouble("get PDU.Gang[" + gang + "].ActivePower");
    }

    public double[] readGangPower() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.Gang[x].ActivePower");
        this.equalsGangCount(values.length);
        return values;
    }

    public int getOutletCount() throws DriverException {
        if (this.numOutlets == null) {
            this.numOutlets = this.receiveInt("get PDU.OutletSystem.Outlet.Count");
        }
        return this.numOutlets;
    }

    public int getOutletGang(int outlet) throws DriverException {
        this.checkOutletNumber(outlet);
        return this.receiveInt("get PDU.OutletSystem.Outlet[" + outlet + "].GangID");
    }

    public int[] getOutletGang() throws DriverException {
        return this.receiveInts("get PDU.OutletSystem.Outlet[x].GangID");
    }

    public boolean isOutletOn(int outlet) throws DriverException {
        this.checkOutletNumber(outlet);
        return this.receiveInt("get PDU.OutletSystem.Outlet[" + outlet + "].PresentStatus.SwitchOnOff") == 1;
    }

    public boolean[] getOutletOnStates() throws DriverException {
        int[] states = this.receiveInts("get PDU.OutletSystem.Outlet[x].PresentStatus.SwitchOnOff");
        this.equalsOutletCount(states.length);
        boolean[] onStates = new boolean[states.length];
        for (int j = 0; j < states.length; ++j) {
            onStates[j] = states[j] == 1;
        }
        return onStates;
    }

    public void powerOutletOn(int outlet, int delay) throws DriverException {
        this.checkOutletNumber(outlet);
        this.receiveInt("set PDU.OutletSystem.Outlet[" + outlet + "].DelayBeforeStartup " + delay);
    }

    public void powerOutletOff(int outlet, int delay) throws DriverException {
        this.checkOutletNumber(outlet);
        this.receiveInt("set PDU.OutletSystem.Outlet[" + outlet + "].DelayBeforeShutdown " + delay);
    }

    public double getOutletConfigCurrent(int outlet) throws DriverException {
        this.checkOutletNumber(outlet);
        return this.receiveDouble("get PDU.OutletSystem.Outlet[" + outlet + "].ConfigCurrent");
    }

    public double[] getOutletConfigCurrent() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.OutletSystem.Outlet[x].ConfigCurrent");
        this.equalsOutletCount(values.length);
        return values;
    }

    public double readOutletCurrent(int outlet) throws DriverException {
        this.checkOutletNumber(outlet);
        return this.receiveDouble("get PDU.OutletSystem.Outlet[" + outlet + "].Current");
    }

    public double[] readOutletCurrent() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.OutletSystem.Outlet[x].Current");
        this.equalsOutletCount(values.length);
        return values;
    }

    public double readOutletPower(int outlet) throws DriverException {
        this.checkOutletNumber(outlet);
        return this.receiveDouble("get PDU.OutletSystem.Outlet[" + outlet + "].ActivePower");
    }

    public double[] readOutletPower() throws DriverException {
        double[] values = this.receiveDoubles("get PDU.OutletSystem.Outlet[x].ActivePower");
        this.equalsOutletCount(values.length);
        return values;
    }

    public synchronized String receiveString(String command) throws DriverException {
        String[] resp = this.receive(command);
        if (resp.length < 2) {
            throw new DriverException("No response received");
        }
        if (resp.length > 2) {
            StringBuilder text = new StringBuilder();
            for (int j = 1; j < resp.length; ++j) {
                text.append(resp[j]);
                text.append("/");
            }
            throw new DriverException("Excess response received: " + text);
        }
        return resp[1];
    }

    public int receiveInt(String command) throws DriverException {
        String resp = this.receiveString(command);
        try {
            return Integer.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid integer: " + resp);
        }
    }

    public double receiveDouble(String command) throws DriverException {
        String resp = this.receiveString(command);
        try {
            return Double.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid double: " + resp);
        }
    }

    public synchronized String[] receiveStrings(String command) throws DriverException {
        return this.receiveString(command).split("\\|");
    }

    public synchronized int[] receiveInts(String command) throws DriverException {
        String[] resp = this.receiveStrings(command);
        int[] values = new int[resp.length];
        for (int j = 0; j < values.length; ++j) {
            try {
                values[j] = Integer.valueOf(resp[j]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DriverException("Invalid integer: " + resp[j]);
            }
        }
        return values;
    }

    public synchronized double[] receiveDoubles(String command) throws DriverException {
        String[] resp = this.receiveStrings(command);
        double[] values = new double[resp.length];
        for (int j = 0; j < values.length; ++j) {
            try {
                values[j] = Double.valueOf(resp[j]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DriverException("Invalid double: " + resp[j]);
            }
        }
        return values;
    }

    private void checkGangNumber(int gang) throws DriverException {
        if (gang <= 0 || gang > this.getGangCount()) {
            throw new DriverException("Invalid gang number: " + gang);
        }
    }

    private void checkOutletNumber(int outlet) throws DriverException {
        if (outlet <= 0 || outlet > this.getOutletCount()) {
            throw new DriverException("Invalid outlet number: " + outlet);
        }
    }

    private void equalsGangCount(int count) throws DriverException {
        if (count != this.getGangCount()) {
            throw new DriverException("Incorrect number of values returned: " + count);
        }
    }

    private void equalsOutletCount(int count) throws DriverException {
        if (count != this.getOutletCount()) {
            throw new DriverException("Incorrect number of values returned: " + count);
        }
    }
}

