/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;

public class LogManagement {
    public static final ErrorManager ERROR_MANAGER = new ErrorManager();

    static {
        InputStream is = LogManagement.class.getResourceAsStream("/logging.properties");
        if (is != null) {
            LogManagement.reloadConfigurationFrom(" global resource logging.properties ", is);
        } else {
            LogManagement.cleanConsole();
            ERROR_MANAGER.error("WARNING: no access to global resource logging.properties (but cleaning Console access)", null, 4);
        }
    }

    public static void cleanConsole() {
        Handler[] handlers;
        Logger globalHandler = Logger.getLogger("");
        Handler[] handlerArray = handlers = globalHandler.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler.getClass().equals(ConsoleHandler.class)) {
                globalHandler.removeHandler(handler);
            }
            ++n2;
        }
    }

    static void reloadConfigurationFrom(String name, InputStream is) {
        LogManager manager = LogManager.getLogManager();
        try {
            manager.readConfiguration(is);
            assert (Tracer.trace("handlers=" + manager.getProperty("handlers")));
        }
        catch (IOException e) {
            ERROR_MANAGER.error("can't open " + name, e, 4);
        }
    }
}

