/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dscud;

import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.dscud.Dscud;
import org.lsst.ccs.drivers.dscud.DscudException;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestDscud
implements CmndProcess.Dispatch {
    private static final int INT_TYPE_ALL = 255;
    private static final int MAX_INT_SAVED = 64;
    private static final String[] fifoStatus = new String[]{"U", "E", "H", "HE", "F", "FE", "FH", "FHE", "O", "OE", "OH", "OHE", "OF", "OFE", "OFH", "OFHE"};
    private static final int CMD_INIT = 0;
    private static final int CMD_FREE = 1;
    private static final int CMD_SHOW = 2;
    private static final int CMD_DIOSET = 3;
    private static final int CMD_DIOINBYTE = 4;
    private static final int CMD_DIOINWORD = 5;
    private static final int CMD_DIOOUTBYTE = 6;
    private static final int CMD_DIOOUTWORD = 7;
    private static final int CMD_DIOINBIT = 8;
    private static final int CMD_DIOOUTBIT = 9;
    private static final int CMD_DIOSETBIT = 10;
    private static final int CMD_DIOCLRBIT = 11;
    private static final int CMD_DIOSHOW = 12;
    private static final int CMD_ADSET = 13;
    private static final int CMD_ADSETCHAN = 14;
    private static final int CMD_ADSAMPLE = 15;
    private static final int CMD_ADSAMPAVG = 16;
    private static final int CMD_ADSAMPINT = 17;
    private static final int CMD_ADSCAN = 18;
    private static final int CMD_ADSCANAVG = 19;
    private static final int CMD_ADSCANINT = 20;
    private static final int CMD_ADAUTOCAL = 21;
    private static final int CMD_ADCALVERIFY = 22;
    private static final int CMD_ADCTOV = 23;
    private static final int CMD_ADVTOC = 24;
    private static final int CMD_ADSHOW = 25;
    private static final int CMD_ADSHOWFIFO = 26;
    private static final int CMD_DASET = 27;
    private static final int CMD_DASETPOL = 28;
    private static final int CMD_DACONV = 29;
    private static final int CMD_DASCAN = 30;
    private static final int CMD_DAAUTOCAL = 31;
    private static final int CMD_DACALVERIFY = 32;
    private static final int CMD_DACTOV = 33;
    private static final int CMD_DAVTOC = 34;
    private static final int CMD_DASHOW = 35;
    private static final int CMD_INP = 36;
    private static final int CMD_INPW = 37;
    private static final int CMD_INPL = 38;
    private static final int CMD_INPWS = 39;
    private static final int CMD_OUT = 40;
    private static final int CMD_OUTW = 41;
    private static final int CMD_OUTL = 42;
    private static final int CMD_OUTWS = 43;
    private static final int CMD_DSHOW = 44;
    private static final int CMD_SHOWREGS = 45;
    private static final int CMD_SHOWERROR = 46;
    private static final int CMD_CTRSETVALUE = 47;
    private static final int CMD_CTRSETRATE = 48;
    private static final int CMD_CTRREAD = 49;
    private static final int CMD_CTRSHOW = 50;
    private static final int CMD_TIMEREAD = 51;
    private static final int CMD_INTSTART = 52;
    private static final int CMD_INTSTOP = 53;
    private static final int CMD_INTCANCEL = 54;
    private static final int CMD_INTPAUSE = 55;
    private static final int CMD_INTRESUME = 56;
    private static final int CMD_INTSHOW = 57;
    private static final int CMD_DUMP = 58;
    private static final int CMD_THRSHOW = 59;
    private static final int CMD_THRSTOP = 60;
    private static final int CMD_THRDAEMON = 61;
    private static final int CMD_REGREAD = 62;
    private static final int CMD_REGWRITE = 63;
    private static final int CMD_SHOWBOARD = 64;
    private static final int CMD_SHOWTIMER = 65;
    private static final int NUM_CMDS = 66;
    private static final String[] helpInit = new String[]{"Initialize a board", "init <type> <address> <level> <clkfreq0> <clkfreq1> <clkslct1>", "type       The board type (default helios)", "address    The board address (default 0x280)", "level      The interrupt level (default 5)", "clkfreq0   The frequency of clock 0 (default 0: 10 MHz)", "clkfreq1   The frequency of clock 1 (default 0: 10 MHz)", "clkslct1   The source for clock 1 (default 0: internal)"};
    private static final String[] helpShow = new String[]{"Show the current initialization parameters", "show"};
    private static final String[] helpShowregs = new String[]{"Read and display the board's registers", "showregs"};
    private static final String[] helpShowerror = new String[]{"Show last error, or the string for a code", "showerror <code>", "code   The error code (default last occuring error)"};
    private static final String[] helpFree = new String[]{"Free the board", "free"};
    private static final String[] helpAdset = new String[]{"Set parameters for analog input (ADCs)", "adset <chan> <gain> <range> <polarity> <loadcal> <scanint> <diff>", "chan      The analog channel to use in sample operations", "gain      The input gain to use (0 - 3)", "range     The input range to use (0 - 1)", "polarity  The polarity of the input (0 - 1)", "loadcal   If non-zero, load calibration values", "scanint   The interval between successive channels in a scan (0 - 5)", "diff      0 = single-ended input; 1 = differential input"};
    private static final String[] helpAdsetchan = new String[]{"Set ADC channel range for sampling", "adsetchan <lowchan> <highchan>", "lowchan    The first channel to use (0 - 15)", "highchan   The last channel to use (0 - 15, >= lowchan)"};
    private static final String[] helpAdshow = new String[]{"Show the current analog input parameters", "adshow"};
    private static final String[] helpAdshowfifo = new String[]{"Show the state of the analog input FIFO", "adshowfifo"};
    private static final String[] helpAdsample = new String[]{"Read and display current ADC channel value", "adsamp"};
    private static final String[] helpAdsampavg = new String[]{"Average several reads of current ADC channel", "adsampavg <count>", "count   The number of samples to read and average"};
    private static final String[] helpAdsampint = new String[]{"Read ADC channels using interrupts", "adsampint <nsamp> <lowchan> <highchan> <rate> <clksrc> <depth> <thresh>", "nsamp      The number of samples to read", "lowchan    The lowest channel number to read", "highchan   The highest channel number to read", "rate       The sample rate (Hz); cannot exceed 100000", "clksrc     The clock frequency; 0 = 100 KHz, 1 = 10 MHz", "depth      The FIFO depth to use, or -1 to disable the FIFO", "thresh     The FIFO threshold for triggering readouts"};
    private static final String[] helpAdscan = new String[]{"Read and display a set of ADC channels", "adscan <lowchan> <highchan>", "lowchan    The first channel to scan (0 - 15)", "highchan   The last channel to scan (0 - 15, >= lowscan)"};
    private static final String[] helpAdscanavg = new String[]{"Average several reads of a set of ADC channels", "adscanavg <lowchan> <highchan> <count>", "lowchan    The first channel to scan (0 - 15)", "highchan   The last channel to scan (0 - 15, >= lowscan)", "count      The number of samples to read and average"};
    private static final String[] helpAdscanint = new String[]{"Scan ADC channels using interrupts", "adscanint <nsamp> <lowchan> <highchan> <rate> <clksrc> <depth> <thresh>", "nsamp      The number of samples to read", "lowchan    The lowest channel number to read", "highchan   The highest channel number to read", "rate       The sample rate (Hz); cannot exceed 100000", "clksrc     The clock frequency; 0 = 100 KHz, 1 = 10 MHz", "depth      The FIFO depth to use, or -1 to disable the FIFO", "thresh     The FIFO threshold for triggering readouts"};
    private static final String[] helpAdautocal = new String[]{"Perform auto calibration of analog input", "adautocal <range> <bootrange>", "range      The range (0 - 15, or 255) to be auto-calibrated", "bootrange  The calibration range (0 - 15) to load at boot time"};
    private static final String[] helpAdcalverify = new String[]{"Verify the analog input auto calibration", "adcalverify <range> <bootrange>", "range      The range (0 - 15) to be verified"};
    private static final String[] helpAdctov = new String[]{"Convert analog input code to voltage", "adctov <code>", "code   The code value (-32768 - 32767) to be converted"};
    private static final String[] helpAdvtoc = new String[]{"Convert analog input voltage to code", "advtoc <voltage>", "voltage  The voltage to be converted to a code value"};
    private static final String[] helpDaset = new String[]{"Set parameters for analog output", "daset <polarity> <loadcal> <range> <gain> <simupdate> <polenab> <urset> <urchan>", "polarity   The polarity of the output (0 - 1)", "loadcal    If non-zero, load calibration values first", "range      The range to use for conversions: 0 = 5.0, 1 = 10.0", "gain       The output gain to use (0 - 2)", "simupdate  If non-zero, output all voltages simultaneously", "polenab    If non-zero, use software polarity, not hardware", "urset      If non-zero, the gain is set on a unique channel", "urchan     The unique channel for the gain setting"};
    private static final String[] helpDasetpol = new String[]{"Set the polarity for analog output", "dasetpol <polarity>", "polarity  The polarity of the analog output (0 - 1)"};
    private static final String[] helpDashow = new String[]{"Show the current analog output parameters", "dashow"};
    private static final String[] helpDaautocal = new String[]{"Perform auto calibration of analog output", "daautocal <range>", "range  The range (0 - 15) to be auto-calibrated"};
    private static final String[] helpDacalverify = new String[]{"Verify the analog output auto calibration", "dacalverify <range>", "range  The range (0 - 15) to be verified"};
    private static final String[] helpDaconv = new String[]{"Write a value to an analog output channel", "daconv <chan> <code>", "chan    The analog output channel to use (0 - 3)", "code    The value to output"};
    private static final String[] helpDascan = new String[]{"Write values to a set of analog output channels", "dascan"};
    private static final String[] helpDactov = new String[]{"Convert analog output code to voltage", "dactov <code>", "code   The code value (0 - 4095) to be converted"};
    private static final String[] helpDavtoc = new String[]{"Convert analog output voltage to code", "davtoc <voltage>", "voltage  The voltage to be converted to a code value"};
    private static final String[] helpDioset = new String[]{"Set digital I/O parameters", "dioset <id> <value>", "id       The ID of the entity to set", "value    The value to set"};
    private static final String[] helpDioshow = new String[]{"Show the current digital I/O parameters", "dioshow"};
    private static final String[] helpDioinbyte = new String[]{"Read and display a byte from a digital I/O port", "dioinbyte <port>", "port    The digital I/O port to read"};
    private static final String[] helpDioinword = new String[]{"Read and display a word (16-bit) from a digital I/O port", "dioinword <port>", "port    The digital I/O port to read"};
    private static final String[] helpDiooutbyte = new String[]{"Write a byte to a digital I/O port", "diooutbyte <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDiooutword = new String[]{"Write a word (16-bit) to a digital I/O port", "diooutword <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDioinbit = new String[]{"Read and display a bit from a digital I/O port", "dioinbit <port> <bitnum>", "port    The digital I/O port to read", "bitnum  The number of the bit to read"};
    private static final String[] helpDiooutbit = new String[]{"Write a bit to a digital I/O port", "diooutbit <port> <bitnum> <value>", "port    The digital I/O port to write to", "bitnum  The number of the bit to write", "value   The value to set the bit to"};
    private static final String[] helpDiosetbit = new String[]{"Set a bit in a digital I/O port", "diosetbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to set"};
    private static final String[] helpDioclearbit = new String[]{"Clear a bit in a digital I/O port", "dioclearbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to clear"};
    private static final String[] helpCtrshow = new String[]{"Show the current counter parameters", "ctrshow [<option>]", "option  Display option bits: 1 = times, 2 = counts"};
    private static final String[] helpCtrsetvalue = new String[]{"Set the value of a counter", "ctrsetvalue <value> <counter> <code>", "value    The value to initialize the counter to", "counter  The counter to be initialized", "code     The control code to use"};
    private static final String[] helpCtrsetrate = new String[]{"Set the frequency of a counter", "ctrsetrate <freq> <counter>", "freq     The frequency to initialize the counter to", "counter  The counter to be initialized (default all)"};
    private static final String[] helpCtrread = new String[]{"Read the value of a counter", "ctrread <counter>", "counter  The counter to be read"};
    private static final String[] helpIntshow = new String[]{"Show counter interrupt statistics", "intshow [<option>]", "option  Display option bits: 1 = intervals, 2 = counts, 4 = combined"};
    private static final String[] helpIntstart = new String[]{"Start counter interrupts", "intstart <rate> <clock> <source> [<method>]", "rate     The interrupt rate, or 0 if pre-programmed", "clock    The clock frequency to use: 0 = 100 KHz, 1 = 10 MHz", "source   The interrupt source: 0 = ctr0, 1 = ctr1, 2 = ext (dflt 1)", "method   The interrupt handling method: 0 = local, 1 = DSC (dflt 0)"};
    private static final String[] helpIntstop = new String[]{"Stop counter interrupts", "intstop"};
    private static final String[] helpIntcancel = new String[]{"Cancel active interrupt processing", "intcancel <type>", "type   The type (cou, dioi, ad, da or all) of interrupt to cancel"};
    private static final String[] helpIntpause = new String[]{"Pause all interrupt processing", "intpause"};
    private static final String[] helpIntresume = new String[]{"Resume all interrupt processing", "intresume"};
    private static final String[] helpDshow = new String[]{"Show the current direct I/O parameters", "dshow"};
    private static final String[] helpInp = new String[]{"Read and display a byte from I/O space", "inp <address>", "address  The address from which to read a byte"};
    private static final String[] helpInpw = new String[]{"Read and display a 16-bit word from I/O space", "inpw <address>", "address  The address from which to read a 16-bit word"};
    private static final String[] helpInpl = new String[]{"Read and display a 32-bit word from I/O space", "inpl <address>", "address  The address from which to read a 32-bit integer"};
    private static final String[] helpInpws = new String[]{"Read and display 16-bit words from I/O space FIFO", "inpws <address> <count>", "address  The address from which to read 16-bit words", "count    The number of words to read at <address>"};
    private static final String[] helpOut = new String[]{"Write a byte to I/O space", "out <address> <value>", "address  The address at which to write a byte", "value    The value to write"};
    private static final String[] helpOutw = new String[]{"Write a 16-bit word to I/O space", "outw <address> <value>", "address  The address at which to write a 16-bit word", "value    The value to write"};
    private static final String[] helpOutl = new String[]{"Write a 32-bit word to I/O space", "outl <address> <value>", "address  The address at which to write a 32-bit integer", "value    The value to write"};
    private static final String[] helpOutws = new String[]{"Write 16-bit words to I/O space FIFO", "outws <address> <value1>... <value8>", "address  The address at which to write 16-bit words", "valuen   The values to write at <address>"};
    private static final String[] helpRegread = new String[]{"Read a board register", "regread <register>", "register  The register number from which to read a byte"};
    private static final String[] helpRegwrite = new String[]{"Write to a board register", "regwrite <register> <value>", "register  The register number to which to write a byte", "value     The value to write"};
    private static final String[] helpTimeread = new String[]{"Time reading from an address", "timeread <count> <address> <width>", "count    The number of times to perform the read", "address  The address at which to read (default board address)", "width    The size (1, 2 or 4) of the word to read (default 1)"};
    private static final String[] helpDump = new String[]{"Dump memory contents", "dump <address> <nbytes>", "address  The address at which to start the dump", "nbytes   The number of bytes to dump"};
    private static final String[] helpShowtimer = new String[]{"Show the value of the interval timer (ms)", "showtimer"};
    private static final String[] helpShowboard = new String[]{"Show the code for a named board type", "showboard"};
    private static final String[] helpThrshow = new String[]{"Show thread information", "thrshow"};
    private static final String[] helpThrstop = new String[]{"Stop a thread", "thrstop <name>"};
    private static final String[] helpThrdaemon = new String[]{"Check or set a thread's daemon status", "thrdaemon <name> <op>"};
    private static final CmndProcess.Lookup brdTypes = new CmndProcess.Lookup(1);
    private static final CmndProcess.Lookup diffTypes;
    private static final CmndProcess.Lookup gainTypes;
    private static final CmndProcess.Lookup sintTypes;
    private static final CmndProcess.Lookup polTypes;
    private static final CmndProcess.Lookup rngTypes;
    private static final CmndProcess.Lookup itypTypes;
    private static final CmndProcess.Command cmnd;
    private final Output out;
    private final Dscud board;
    private final CmndProcess proc;
    private short baseAddr = (short)640;
    private byte boardType = (byte)35;
    private byte intLevel = (byte)5;
    private byte clkFreq0 = 0;
    private byte clkFreq1 = 0;
    private byte clkSlct1 = 0;
    private boolean initd = false;
    private int adAvgCount = 1;
    private int adSmpCount = 1;
    private int adCurr = 0;
    private int adThresh = 0;
    private short adFifoDepth = 0;
    private byte adChan = 0;
    private byte adGain = 0;
    private byte adRange = 1;
    private byte adPolarity = 0;
    private byte adScanIntv = 0;
    private byte adDiff = 0;
    private byte adLowChan = 0;
    private byte adHighChan = (byte)15;
    private byte adLow = 0;
    private byte adHigh = 0;
    private byte adClksrc = 0;
    private float adRate = 100000.0f;
    private boolean adLoadCal = false;
    private int daCode = 0;
    private int[] daCodes = new int[4];
    private int[] daChanEnab = new int[4];
    private byte daPolarity = 0;
    private byte daGain = 0;
    private byte daUrChan = 0;
    private byte daChan = 0;
    private float daRange = 5.0f;
    private boolean daLoadCal = false;
    private boolean daSimUpd = false;
    private boolean daPolEnab = false;
    private boolean daUrSet = false;
    private short dioWord = 0;
    private byte dioPort = 0;
    private byte dioByte = 0;
    private byte dioBit = 0;
    private byte[] dioConfig = new byte[2];
    private int dAddress = 0;
    private int dLong = 0;
    private int dCount = 1;
    private short dReg = 0;
    private short dWord = 0;
    private short[] dWords = new short[8];
    private byte dByte = 0;
    private byte dWidth = 1;
    private int ctrValue = 0;
    private byte ctrSelect = 1;
    private byte ctrCode = 0;
    private float ctrRate = 1.0f;
    private long intStart = 0L;
    private long intStop = 0L;
    private long intLast = 0L;
    private long intSavst = 0L;
    private long[] intTimes = new long[64];
    private int intType = 0;
    private int intCount = 0;
    private int intSaved = 0;
    private int[] intCounts = new int[64];
    private byte intClock = 0;
    private byte intSrce = 1;
    private float intRate = 100.0f;
    private boolean intDsc = false;
    private int dmpAddr = 0;
    private int dmpCount = 4;
    private int dmpWidth = 4;
    private static final String[] heliosDesc;
    private static final String[] pageDesc;

    static {
        brdTypes.add("Helios", 35);
        diffTypes = new CmndProcess.Lookup(2);
        diffTypes.add("SINGLE_ENDED", 0);
        diffTypes.add("DIFFERENTIAL", 1);
        gainTypes = new CmndProcess.Lookup(4);
        gainTypes.add("GAIN_1", 0);
        gainTypes.add("GAIN_2", 1);
        gainTypes.add("GAIN_4", 2);
        gainTypes.add("GAIN_8", 3);
        sintTypes = new CmndProcess.Lookup(6);
        sintTypes.add("SCAN_INTERVAL_4", 5);
        sintTypes.add("SCAN_INTERVAL_5", 3);
        sintTypes.add("SCAN_INTERVAL_9", 4);
        sintTypes.add("SCAN_INTERVAL_10", 2);
        sintTypes.add("SCAN_INTERVAL_15", 1);
        sintTypes.add("SCAN_INTERVAL_20", 0);
        polTypes = new CmndProcess.Lookup(2);
        polTypes.add("BIPOLAR", 0);
        polTypes.add("UNIPOLAR", 1);
        rngTypes = new CmndProcess.Lookup(2);
        rngTypes.add("RANGE_5", 0);
        rngTypes.add("RANGE_10", 1);
        itypTypes = new CmndProcess.Lookup(10);
        itypTypes.add("Inactive", 0);
        itypTypes.add("AD", 1);
        itypTypes.add("DA", 2);
        itypTypes.add("DIOIN", 4);
        itypTypes.add("USER", 8);
        itypTypes.add("COUNTER", 16);
        itypTypes.add("DIOREAD", 32);
        itypTypes.add("OPTO", 64);
        itypTypes.add("DIOWRITE", -128);
        itypTypes.add("ALL", 255);
        cmnd = new CmndProcess.Command(66);
        cmnd.add("init", 0, helpInit, "kwbbbb", brdTypes);
        cmnd.add("show", 2, helpShow, "", new CmndProcess.Lookup[0]);
        cmnd.add("showregs", 45, helpShowregs, "", new CmndProcess.Lookup[0]);
        cmnd.add("showerror", 46, helpShowerror, "b", new CmndProcess.Lookup[0]);
        cmnd.add("free", 1, helpFree, "", new CmndProcess.Lookup[0]);
        cmnd.add("adset", 13, helpAdset, "bbbbbbb", new CmndProcess.Lookup[0]);
        cmnd.add("adsetchan", 14, helpAdsetchan, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("adshow", 25, helpAdshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("adshowfifo", 26, helpAdshowfifo, "", new CmndProcess.Lookup[0]);
        cmnd.add("adsamp", 15, helpAdsample, "", new CmndProcess.Lookup[0]);
        cmnd.add("adsampavg", 16, helpAdsampavg, "i", new CmndProcess.Lookup[0]);
        cmnd.add("adsampint", 17, helpAdsampint, "wbbfbwi", new CmndProcess.Lookup[0]);
        cmnd.add("adscan", 18, helpAdscan, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("adscanavg", 19, helpAdscanavg, "bbi", new CmndProcess.Lookup[0]);
        cmnd.add("adscanint", 20, helpAdscanint, "wbbfbwi", new CmndProcess.Lookup[0]);
        cmnd.add("adautocal", 21, helpAdautocal, "Bb", new CmndProcess.Lookup[0]);
        cmnd.add("adcalverify", 22, helpAdcalverify, "B", new CmndProcess.Lookup[0]);
        cmnd.add("adctov", 23, helpAdctov, "W", new CmndProcess.Lookup[0]);
        cmnd.add("advtoc", 24, helpAdvtoc, "D", new CmndProcess.Lookup[0]);
        cmnd.add("daset", 27, helpDaset, "bbbbbbbb", new CmndProcess.Lookup[0]);
        cmnd.add("dasetpol", 28, helpDasetpol, "b", new CmndProcess.Lookup[0]);
        cmnd.add("dashow", 35, helpDashow, "", new CmndProcess.Lookup[0]);
        cmnd.add("daconv", 29, helpDaconv, "bi", new CmndProcess.Lookup[0]);
        cmnd.add("dascan", 30, helpDascan, "bibibibi", new CmndProcess.Lookup[0]);
        cmnd.add("daautocal", 31, helpDaautocal, "B", new CmndProcess.Lookup[0]);
        cmnd.add("dacalverify", 32, helpDacalverify, "B", new CmndProcess.Lookup[0]);
        cmnd.add("dactov", 33, helpDactov, "I", new CmndProcess.Lookup[0]);
        cmnd.add("davtoc", 34, helpDavtoc, "D", new CmndProcess.Lookup[0]);
        cmnd.add("dioset", 3, helpDioset, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("dioshow", 12, helpDioshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbyte", 4, helpDioinbyte, "b", new CmndProcess.Lookup[0]);
        cmnd.add("dioinword", 5, helpDioinword, "b", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbyte", 6, helpDiooutbyte, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("diooutword", 7, helpDiooutword, "bw", new CmndProcess.Lookup[0]);
        cmnd.add("dioinbit", 8, helpDioinbit, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("diooutbit", 9, helpDiooutbit, "bbb", new CmndProcess.Lookup[0]);
        cmnd.add("diosetbit", 10, helpDiosetbit, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("dioclearbit", 11, helpDioclearbit, "bb", new CmndProcess.Lookup[0]);
        cmnd.add("ctrshow", 50, helpCtrshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("ctrsetvalue", 47, helpCtrsetvalue, "ibb", new CmndProcess.Lookup[0]);
        cmnd.add("ctrsetrate", 48, helpCtrsetrate, "fb", new CmndProcess.Lookup[0]);
        cmnd.add("ctrread", 49, helpCtrread, "b", new CmndProcess.Lookup[0]);
        cmnd.add("intshow", 57, helpIntshow, "b", new CmndProcess.Lookup[0]);
        cmnd.add("intstart", 52, helpIntstart, "fbbb", new CmndProcess.Lookup[0]);
        cmnd.add("intstop", 53, helpIntstop, "", new CmndProcess.Lookup[0]);
        cmnd.add("intcancel", 54, helpIntcancel, "K", itypTypes);
        cmnd.add("intpause", 55, helpIntpause, "", new CmndProcess.Lookup[0]);
        cmnd.add("intresume", 56, helpIntresume, "", new CmndProcess.Lookup[0]);
        cmnd.add("dshow", 44, helpDshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("inp", 36, helpInp, "i", new CmndProcess.Lookup[0]);
        cmnd.add("inpw", 37, helpInpw, "i", new CmndProcess.Lookup[0]);
        cmnd.add("inpl", 38, helpInpl, "i", new CmndProcess.Lookup[0]);
        cmnd.add("inpws", 39, helpInpws, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("out", 40, helpOut, "ib", new CmndProcess.Lookup[0]);
        cmnd.add("outw", 41, helpOutw, "iw", new CmndProcess.Lookup[0]);
        cmnd.add("outl", 42, helpOutl, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("outws", 43, helpOutws, "iiwwwwwwww", new CmndProcess.Lookup[0]);
        cmnd.add("regread", 62, helpRegread, "w", new CmndProcess.Lookup[0]);
        cmnd.add("regwrite", 63, helpRegwrite, "wb", new CmndProcess.Lookup[0]);
        cmnd.add("timeread", 51, helpTimeread, "iib", new CmndProcess.Lookup[0]);
        cmnd.add("dump", 58, helpDump, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("showtimer", 65, helpShowtimer, "", new CmndProcess.Lookup[0]);
        cmnd.add("showboard", 64, helpShowboard, "S", new CmndProcess.Lookup[0]);
        cmnd.add("thrshow", 59, helpThrshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("thrstop", 60, helpThrstop, "S", new CmndProcess.Lookup[0]);
        cmnd.add("thrdaemon", 61, helpThrdaemon, "Si", new CmndProcess.Lookup[0]);
        heliosDesc = new String[]{"| AD7  | AD6  | AD5  | AD4  | AD3  | AD2  | AD1  | AD0  |", "| AD15 | AD14 | AD13 | AD12 | AD11 | AD10 | AD9  | AD8  |", "|  H3  |  H2  |  H1  |  H0  |  L3  |  L2  |  L1  |  L0  |", "|ADBUSY|SE/DIF|ADWAIT|DACBSY|  OF  |SCANEN| ADG1 | ADG0 |", "|CKSEL1|FRQSL1|FRQSL0|ADCLK |  -   |TINTE |DINTE |AINTE |", "|  -   |  -   | FT5  | FT4  | FT3  | FT2  | FT1  | FT0  |", "|  -   |  -   | FD5  | FD4  | FD3  | FD2  | FD1  | FD0  |", "|  -   | TINT | DINT | AINT |ADCH3 |ADCH2 |ADCH1 |ADCH0 |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  B7  |  B6  |  B5  |  B4  |  B3  |  B2  |  B1  |  B0  |", "|  C7  |  C6  |  C5  |  C4  |  C3  |  C2  |  C1  |  C0  |", "|DIOCTR|DAMODE|DASIM | DIRA |DIRCH |  -   | DIRB |DIRCL |", "|CTRD7 |CTRD6 |CTRD5 |CTRD4 |CTRD3 |CTRD2 |CTRD1 |CTRD0 |", "|CTRD15|CTRD14|CTRD13|CTRD12|CTRD11|CTRD10|CTRD9 |CTRD8 |", "|CTRD23|CTRD22|CTRD21|CTRD20|CTRD19|CTRD18|CTRD17|CTRD16|", "|                  FPGA Revision Code                   |", "|  D7  |  D6  |  D5  |  D4  |  D3  |  D2  |  D1  |  D0  |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  -   |TDBUSY|EEBUSY|CALMUX|  -   |  -   |  -   |  -   |", "|                       Not Used                        |", "|  -   |  -   |  -   |  -   |  -   |  -   |  -   |EXFIFO|", "| DAUR |DACH1 |DACH0 |  -   |ADPOL |  -   | ADSD |  -   |", "|  -   |  -   |  -   |DASIZE|DAPOL |  -   | DAG1 | DAG0 |", "|                D/A Simultaneous Update                |", "| FD07 | FD06 | FD05 | FD04 | FD03 | FD02 | FD01 | FD00 |", "| FD11 | FD10 | FD09 | FD08 |  OF  |  FF  |  HF  |  EF  |"};
        pageDesc = new String[]{"Counter/Timer Access", "AutoCal Control", "Expanded FIFO and AD/DA Control"};
    }

    TestDscud(Output out) {
        this.out = out != null ? out : new ConsOut();
        this.board = new Dscud();
        this.proc = new CmndProcess();
        this.proc.add(this, cmnd);
    }

    TestDscud() {
        this(null);
    }

    public static void main(String[] args) {
        new TestDscud().run();
        System.exit(0);
    }

    public void run() {
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null) {
                try {
                    if (this.proc.process(line)) continue;
                    break;
                }
                catch (DscudException e) {
                    this.out.println(e);
                }
            }
        }
        catch (Exception e) {
            this.out.println(e);
        }
        this.cleanup();
    }

    @Override
    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 0: {
                this.procInit(found, args);
                break;
            }
            case 2: {
                this.procShow(found, args);
                break;
            }
            case 45: {
                this.procShowregs(found, args);
                break;
            }
            case 46: {
                this.procShowerror(found, args);
                break;
            }
            case 1: {
                this.procFree(found, args);
                break;
            }
            case 13: {
                this.procAdset(found, args);
                break;
            }
            case 14: {
                this.procAdsetchan(found, args);
                break;
            }
            case 25: {
                this.procAdshow(found, args);
                break;
            }
            case 26: {
                this.procAdshowfifo(found, args);
                break;
            }
            case 15: {
                this.procAdsample(found, args);
                break;
            }
            case 16: {
                this.procAdsampavg(found, args);
                break;
            }
            case 17: {
                this.procAdsampint(found, args);
                break;
            }
            case 18: {
                this.procAdscan(found, args);
                break;
            }
            case 19: {
                this.procAdscanavg(found, args);
                break;
            }
            case 20: {
                this.procAdscanint(found, args);
                break;
            }
            case 21: {
                this.procAdautocal(found, args);
                break;
            }
            case 22: {
                this.procAdcalverify(found, args);
                break;
            }
            case 23: {
                this.procAdctov(found, args);
                break;
            }
            case 24: {
                this.procAdvtoc(found, args);
                break;
            }
            case 27: {
                this.procDaset(found, args);
                break;
            }
            case 28: {
                this.procDasetpol(found, args);
                break;
            }
            case 35: {
                this.procDashow(found, args);
                break;
            }
            case 29: {
                this.procDaconv(found, args);
                break;
            }
            case 30: {
                this.procDascan(found, args);
                break;
            }
            case 31: {
                this.procDaautocal(found, args);
                break;
            }
            case 32: {
                this.procDacalverify(found, args);
                break;
            }
            case 33: {
                this.procDactov(found, args);
                break;
            }
            case 34: {
                this.procDavtoc(found, args);
                break;
            }
            case 3: {
                this.procDioset(found, args);
                break;
            }
            case 12: {
                this.procDioshow(found, args);
                break;
            }
            case 4: {
                this.procDioinbyte(found, args);
                break;
            }
            case 6: {
                this.procDiooutbyte(found, args);
                break;
            }
            case 5: {
                this.procDioinword(found, args);
                break;
            }
            case 7: {
                this.procDiooutword(found, args);
                break;
            }
            case 8: {
                this.procDioinbit(found, args);
                break;
            }
            case 9: {
                this.procDiooutbit(found, args);
                break;
            }
            case 10: {
                this.procDiosetbit(found, args);
                break;
            }
            case 11: {
                this.procDioclrbit(found, args);
                break;
            }
            case 50: {
                this.procCtrshow(found, args);
                break;
            }
            case 47: {
                this.procCtrsetvalue(found, args);
                break;
            }
            case 48: {
                this.procCtrsetrate(found, args);
                break;
            }
            case 49: {
                this.procCtrread(found, args);
                break;
            }
            case 57: {
                this.procIntshow(found, args);
                break;
            }
            case 52: {
                this.procIntstart(found, args);
                break;
            }
            case 53: {
                this.procIntstop(found, args);
                break;
            }
            case 54: {
                this.procIntcancel(found, args);
                break;
            }
            case 55: {
                this.procIntpause(found, args);
                break;
            }
            case 56: {
                this.procIntresume(found, args);
                break;
            }
            case 44: {
                this.procDshow(found, args);
                break;
            }
            case 36: {
                this.procInp(found, args);
                break;
            }
            case 37: {
                this.procInpw(found, args);
                break;
            }
            case 38: {
                this.procInpl(found, args);
                break;
            }
            case 39: {
                this.procInpws(found, args);
                break;
            }
            case 40: {
                this.procOut(found, args);
                break;
            }
            case 41: {
                this.procOutw(found, args);
                break;
            }
            case 42: {
                this.procOutl(found, args);
                break;
            }
            case 43: {
                this.procOutws(found, args);
                break;
            }
            case 62: {
                this.procRegread(found, args);
                break;
            }
            case 63: {
                this.procRegwrite(found, args);
                break;
            }
            case 51: {
                this.procTimeread(found, args);
                break;
            }
            case 58: {
                this.procDump(found, args);
                break;
            }
            case 65: {
                this.procShowtimer(found, args);
                break;
            }
            case 64: {
                this.procShowboard(found, args);
                break;
            }
            case 59: {
                this.procThrshow(found, args);
                break;
            }
            case 60: {
                this.procThrstop(found, args);
                break;
            }
            case 61: {
                this.procThrdaemon(found, args);
                break;
            }
            default: {
                this.out.println("Command not fully implemented");
            }
        }
        return true;
    }

    private void procInit(int found, Object[] args) {
        if (this.initd) {
            this.initd = false;
            this.board.freeBoard();
        }
        if ((found & 1) != 0) {
            this.boardType = (byte)((Integer)args[0]).intValue();
        }
        if ((found & 2) != 0) {
            this.baseAddr = (Short)args[1];
        }
        if ((found & 4) != 0) {
            this.intLevel = (Byte)args[2];
        }
        if ((found & 8) != 0) {
            this.clkFreq0 = (Byte)args[3];
        }
        if ((found & 0x10) != 0) {
            this.clkFreq1 = (Byte)args[4];
        }
        if ((found & 0x20) != 0) {
            this.clkSlct1 = (Byte)args[5];
        }
        this.dAddress = this.baseAddr;
        this.board.initBoard(this.boardType, this.baseAddr, this.intLevel, this.clkFreq0, this.clkFreq1, this.clkSlct1);
        this.initd = true;
    }

    private void procShow(int found, Object[] args) {
        this.out.println("Initialization parameters:");
        this.out.println("  Board type       = " + brdTypes.decode(this.boardType));
        this.out.format("  Base address     = %04x\n", this.baseAddr);
        this.out.println("  Interrupt level  = " + this.intLevel);
        this.out.format("  Clock0 frequency = %s (%s)\n", this.clkFreq0, this.clkFreq0 == 0 ? "10 MHz" : "1 MHz");
        this.out.format("  Clock1 frequency = %s (%s)\n", this.clkFreq1, this.clkFreq1 == 0 ? "10 MHz" : "100 KHz");
        this.out.format("  Clock1 source    = %s (%s)\n", this.clkSlct1, this.clkSlct1 == 0 ? "Internal" : "External");
    }

    private void procShowregs(int found, Object[] args) {
        if (this.boardType == 35) {
            short r;
            byte[] regs = new byte[24];
            short r2 = 0;
            while (r2 < 12) {
                regs[r2] = this.board.registerRead(r2);
                r2 = (short)(r2 + 1);
            }
            byte p = 0;
            while (p < 3) {
                this.board.registerWrite((short)1, p);
                r = 12;
                while (r < 16) {
                    regs[4 * p + r] = this.board.registerRead(r);
                    r = (short)(r + 1);
                }
                p = (byte)(p + 1);
            }
            this.out.println("Main registers:");
            r2 = 0;
            while (r2 < 12) {
                if ((r2 == 5 || r2 == 6) && (regs[20] & 1) != 0) {
                    this.out.format("  %2s: %02x  %s\n", r2, regs[r2], heliosDesc[r2 + 19]);
                } else {
                    this.out.format("  %2s: %02x  %s\n", r2, regs[r2], heliosDesc[r2]);
                }
                r2 = (short)(r2 + 1);
            }
            p = 0;
            while (p < 3) {
                this.out.format("\nPage %s: %s\n", p, pageDesc[p]);
                r = 12;
                while (r < 16) {
                    int ri = 4 * p + r;
                    this.out.format("  %2s: %02x  %s\n", r, regs[ri], heliosDesc[ri]);
                    r = (short)(r + 1);
                }
                p = (byte)(p + 1);
            }
        } else {
            this.out.println("Unknown board type (" + this.boardType + ")");
        }
    }

    private void procShowerror(int found, Object[] args) {
        if ((found & 1) != 0) {
            byte eCode = (Byte)args[0];
            this.out.println(String.valueOf(eCode) + ": " + Dscud.getErrorString(eCode));
        } else {
            String[] text = new String[1];
            int eCode = Dscud.getLastError(text);
            this.out.println(String.valueOf(eCode) + ": " + text[0]);
        }
    }

    private void procFree(int found, Object[] args) {
        this.initd = false;
        this.board.freeBoard();
    }

    private void procAdset(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adChan = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.adGain = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.adRange = (Byte)args[2];
        }
        if ((found & 8) != 0) {
            this.adPolarity = (Byte)args[3];
        }
        if ((found & 0x10) != 0) {
            boolean bl = this.adLoadCal = (Byte)args[4] != 0;
        }
        if ((found & 0x20) != 0) {
            this.adScanIntv = (Byte)args[5];
        }
        if ((found & 0x40) != 0) {
            this.adDiff = (Byte)args[6];
        }
        this.board.adSetSettings(this.adChan, this.adGain, this.adRange, this.adPolarity, this.adLoadCal, this.adScanIntv, this.adDiff);
        this.adLow = this.adHigh = this.adChan;
        this.adCurr = this.adHigh;
    }

    private void procAdsetchan(int found, Object[] args) {
        short[] cfr_ignored_0 = new short[16];
        if ((found & 1) != 0) {
            this.adLowChan = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.adHighChan = (Byte)args[1];
        }
        this.board.adSetChannel(this.adLowChan, this.adHighChan);
        this.adLow = this.adLowChan;
        this.adCurr = this.adLow;
        this.adHigh = this.adHighChan;
    }

    private void procAdshow(int found, Object[] args) {
        this.out.println("Analog input parameters:");
        this.out.println("  Sample channel    = " + this.adChan);
        this.out.format("  Gain              = %s (%s)\n", this.adGain, gainTypes.decode(this.adGain));
        this.out.format("  Range             = %s (%s)\n", this.adRange, rngTypes.decode(this.adRange));
        this.out.format("  Polarity          = %s (%s)\n", this.adPolarity, polTypes.decode(this.adPolarity));
        this.out.println("  Load calibration  = " + this.adLoadCal);
        this.out.format("  Scan interval     = %s (%s)\n", this.adScanIntv, sintTypes.decode(this.adScanIntv));
        this.out.format("  Differential      = %s (%s)\n", this.adDiff, diffTypes.decode(this.adDiff));
        this.out.println("  Low channel reqd  = " + this.adLowChan);
        this.out.println("  High channel reqd = " + this.adHighChan);
        this.out.println("  Averaging count   = " + this.adAvgCount);
        this.out.println("  Intr sample count = " + this.adSmpCount);
        this.out.println("  Interrupt rate    = " + this.adRate);
        this.out.println("  Intr clock source = " + this.adClksrc);
        this.out.println("  Intr FIFO depth   = " + this.adFifoDepth);
        this.out.println("  Intr threshold    = " + this.adThresh);
        this.out.println("  Current channel   = " + this.adCurr);
        this.out.println("  Low channel set   = " + this.adLow);
        this.out.println("  High channel set  = " + this.adHigh);
    }

    private void procAdshowfifo(int found, Object[] args) {
        this.out.print("Analog input FIFO status: ");
        byte reg5 = this.board.registerRead((short)5);
        byte reg6 = this.board.registerRead((short)6);
        this.board.registerWrite((short)1, (byte)2);
        byte reg12 = this.board.registerRead((short)12);
        if ((reg12 & 1) == 0) {
            this.out.format("mode = basic, threshold = %s, depth = %s.\n", reg5, reg6);
        } else {
            String fstatus = fifoStatus[reg6 & 0xF];
            int depth = (reg6 & 0xF0) << 8 | reg5 & 0xFF;
            this.out.format("mode = expanded, status = %s, depth = %s.\n", fstatus, depth);
        }
    }

    private void procAdsample(int found, Object[] args) {
        short value = this.board.adSample();
        double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value);
        this.out.format("Channel %s: %04x ", this.adCurr, value);
        if (volts > -1.0 && volts < 1.0) {
            this.out.format("(%.5f)\n", volts);
        } else {
            this.out.format("(%.6g)\n", volts);
        }
        if (this.adCurr == this.adHigh) {
            this.adCurr = this.adLow;
        } else if (++this.adCurr >= 16) {
            this.adCurr = 0;
        }
    }

    private void procAdsampavg(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adAvgCount = (Integer)args[0];
        }
        double value = this.board.adSampleAvg(this.adAvgCount);
        double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, (short)(value + 0.5));
        this.out.format("Channel %s: %.1f ", this.adCurr, value);
        if (volts > -1.0 && volts < 1.0) {
            this.out.format("(%.5f)\n", volts);
        } else {
            this.out.format("(%.6g)\n", volts);
        }
        int nchan = this.adHigh - this.adLow + 1;
        if (nchan <= 0) {
            nchan += 16;
        }
        int j = 0;
        while (j < this.adAvgCount % nchan) {
            if (this.adCurr == this.adHigh) {
                this.adCurr = this.adLow;
            } else if (++this.adCurr >= 16) {
                this.adCurr = 0;
            }
            ++j;
        }
    }

    private void procAdsampint(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adSmpCount = ((Short)args[0]).shortValue();
        }
        if ((found & 2) != 0) {
            this.adLowChan = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.adHighChan = (Byte)args[2];
        }
        if ((found & 8) != 0) {
            this.adRate = ((Float)args[3]).floatValue();
        }
        if ((found & 0x10) != 0) {
            this.adClksrc = (Byte)args[4];
        }
        if ((found & 0x20) != 0) {
            this.adFifoDepth = (Short)args[5];
        }
        if ((found & 0x40) != 0) {
            this.adThresh = (Integer)args[6];
        }
        short[] value = new short[this.adSmpCount];
        this.board.adSampleInt(this.adSmpCount, this.adLowChan, this.adHighChan, this.adRate, this.adClksrc, this.adFifoDepth, this.adThresh, value);
        this.adLow = this.adLowChan;
        this.adCurr = this.adLow;
        this.adHigh = this.adHighChan;
        int j = 0;
        while (j < this.adSmpCount) {
            if (j > 0) {
                this.out.print((j & 3) == 0 ? "\n" : " ");
            }
            double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
            this.out.format("%2s: %04x ", this.adCurr, value[j]);
            if (volts > -1.0 && volts < 1.0) {
                this.out.format("(% -8.5f)", volts);
            } else {
                this.out.format("(% -8.6g)", volts);
            }
            if (this.adCurr == this.adHigh) {
                this.adCurr = this.adLow;
            } else if (++this.adCurr >= 16) {
                this.adCurr = 0;
            }
            ++j;
        }
        this.out.println();
    }

    private void procAdscan(int found, Object[] args) {
        short[] value = new short[16];
        if ((found & 1) != 0) {
            this.adLowChan = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.adHighChan = (Byte)args[1];
        }
        this.board.adScan(this.adLowChan, this.adHighChan, value);
        this.adLow = this.adLowChan < this.adHighChan ? this.adLowChan : this.adHighChan;
        this.adHigh = this.adLowChan > this.adHighChan ? this.adLowChan : this.adHighChan;
        this.adCurr = this.adLow;
        int j = 0;
        while (j < this.adHigh - this.adLow + 1) {
            if (j > 0) {
                this.out.print((j & 3) == 0 ? "\n" : " ");
            }
            double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
            this.out.format("%2s: %04x ", this.adCurr, value[j]);
            if (volts > -1.0 && volts < 1.0) {
                this.out.format("(% -8.5f)", volts);
            } else {
                this.out.format("(% -8.6g)", volts);
            }
            ++j;
            ++this.adCurr;
        }
        this.out.println();
    }

    private void procAdscanavg(int found, Object[] args) {
        double[] value = new double[16];
        if ((found & 1) != 0) {
            this.adLowChan = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.adHighChan = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.adAvgCount = (Integer)args[2];
        }
        this.board.adScanAvg(this.adLowChan, this.adHighChan, value, this.adAvgCount);
        this.adLow = this.adLowChan < this.adHighChan ? this.adLowChan : this.adHighChan;
        this.adHigh = this.adLowChan > this.adHighChan ? this.adLowChan : this.adHighChan;
        this.adCurr = this.adLow;
        int j = 0;
        while (j < this.adHigh - this.adLow + 1) {
            if (j > 0) {
                this.out.print(j % 3 == 0 ? "\n" : "    ");
            }
            double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, (short)(value[j] + 0.5));
            this.out.format("%2s: %7.1f ", this.adCurr, value[j]);
            if (volts > -1.0 && volts < 1.0) {
                this.out.format("(% -8.5f)", volts);
            } else {
                this.out.format("(% -8.6g)", volts);
            }
            ++j;
            ++this.adCurr;
        }
        this.out.println();
    }

    private void procAdscanint(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.adSmpCount = ((Short)args[0]).shortValue();
        }
        if ((found & 2) != 0) {
            this.adLowChan = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.adHighChan = (Byte)args[2];
        }
        if ((found & 8) != 0) {
            this.adRate = ((Float)args[3]).floatValue();
        }
        if ((found & 0x10) != 0) {
            this.adClksrc = (Byte)args[4];
        }
        if ((found & 0x20) != 0) {
            this.adFifoDepth = (Short)args[5];
        }
        if ((found & 0x40) != 0) {
            this.adThresh = (Integer)args[6];
        }
        short[] value = new short[this.adSmpCount];
        this.board.adScanInt(this.adSmpCount, this.adLowChan, this.adHighChan, this.adRate, this.adClksrc, this.adFifoDepth, this.adThresh, value);
        this.adLow = this.adLowChan;
        this.adCurr = this.adLow;
        this.adHigh = this.adHighChan;
        int j = 0;
        while (j < this.adSmpCount) {
            if (j > 0) {
                this.out.print((j & 3) == 0 ? "\n" : " ");
            }
            double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
            this.out.format("%2s: %04x ", this.adCurr, value[j]);
            if (volts > -1.0 && volts < 1.0) {
                this.out.format("(% -8.5f)", volts);
            } else {
                this.out.format("(% -8.6g)", volts);
            }
            if (this.adCurr == this.adHigh) {
                this.adCurr = this.adLow;
            } else if (++this.adCurr >= 16) {
                this.adCurr = 0;
            }
            ++j;
        }
        this.out.println();
    }

    private void procAdautocal(int found, Object[] args) {
        byte range = (Byte)args[0];
        byte bootRange = (found & 2) != 0 ? (Byte)args[1] : (byte)0;
        this.board.adAutoCal(range, bootRange);
    }

    private void procAdcalverify(int found, Object[] args) {
        float[] offset = new float[]{0.0f};
        float[] gain = new float[]{0.0f};
        byte range = (Byte)args[0];
        this.board.adCalVerify(range, offset, gain);
        this.out.format("Offset error = %1.4f, gain error = %1.4f\n", Float.valueOf(offset[0]), Float.valueOf(gain[0]));
    }

    private void procAdctov(int found, Object[] args) {
        short code = (Short)args[0];
        double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, code);
        if (volts > -1.0 && volts < 1.0) {
            this.out.format("Voltage = %.5f\n", volts);
        } else {
            this.out.format("Voltage = %.6g\n", volts);
        }
    }

    private void procAdvtoc(int found, Object[] args) {
        double volts = (Double)args[0];
        short code = this.board.voltageToAdCode(this.adPolarity, this.adGain, this.adRange, volts);
        this.out.println("Code = " + code);
    }

    private void procDaset(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daPolarity = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            boolean bl = this.daLoadCal = (Byte)args[1] != 0;
        }
        if ((found & 4) != 0) {
            float f = this.daRange = (Byte)args[2] != 0 ? 10.0f : 5.0f;
        }
        if ((found & 8) != 0) {
            this.daGain = (Byte)args[3];
        }
        if ((found & 0x10) != 0) {
            boolean bl = this.daSimUpd = (Byte)args[4] != 0;
        }
        if ((found & 0x20) != 0) {
            boolean bl = this.daPolEnab = (Byte)args[5] != 0;
        }
        if ((found & 0x40) != 0) {
            boolean bl = this.daUrSet = (Byte)args[6] != 0;
        }
        if ((found & 0x80) != 0) {
            this.daUrChan = (Byte)args[7];
        }
        this.board.daSetSettings(this.daPolarity, this.daLoadCal, this.daRange, this.daGain, this.daSimUpd, this.daPolEnab, this.daUrSet, this.daUrChan);
    }

    private void procDasetpol(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daPolarity = (Byte)args[0];
        }
        this.board.daSetPolarity(this.daPolarity);
    }

    private void procDashow(int found, Object[] args) {
        this.out.println("Analog output parameters:");
        this.out.format("  Polarity            = %s (%s)\n", this.daPolarity, polTypes.decode(1 - this.daPolarity));
        this.out.println("  Load calibration    = " + this.daLoadCal);
        this.out.println("  Range               = " + this.daRange);
        this.out.format("  Gain                = %s (%s)\n", this.daGain, gainTypes.decode(this.daGain));
        this.out.println("  Simultaneous update = " + this.daSimUpd);
        this.out.println("  Polarity enable     = " + this.daPolEnab);
        this.out.println("  Set unique range    = " + this.daUrSet);
        this.out.println("  Unique channel      = " + this.daUrChan);
    }

    private void procDaconv(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.daChan = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.daCode = (Integer)args[1];
        }
        this.board.daConvert(this.daChan, this.daCode);
    }

    private void procDascan(int found, Object[] args) {
        if (found != 0) {
            int j = 0;
            while (j < this.daChanEnab.length) {
                this.daChanEnab[j] = 0;
                ++j;
            }
            j = 0;
            while (j < 2 * this.daChanEnab.length) {
                if ((found & 1 << j) != 0) {
                    byte chan = (Byte)args[j];
                    this.daChanEnab[chan] = 1;
                    if ((found & 1 << j + 1) != 0) {
                        this.daCodes[chan] = (Integer)args[j + 1];
                    }
                }
                j += 2;
            }
        }
        this.board.daConvertScan(this.daChanEnab, this.daCodes);
    }

    private void procDaautocal(int found, Object[] args) {
        byte range = (Byte)args[0];
        this.board.daAutoCal(range);
    }

    private void procDacalverify(int found, Object[] args) {
        float[] offset = new float[]{0.0f};
        float[] gain = new float[]{0.0f};
        byte range = (Byte)args[0];
        this.board.daCalVerify(range, offset, gain);
        this.out.format("Offset error = %1.4f, gain error = %1.4f\n", Float.valueOf(offset[0]), Float.valueOf(gain[0]));
    }

    private void procDactov(int found, Object[] args) {
        int code = (Integer)args[0];
        double volts = this.board.daCodeToVoltage(this.daPolarity, this.daGain, this.daRange, code);
        this.out.format("Voltage = %1.5f\n", volts);
    }

    private void procDavtoc(int found, Object[] args) {
        double volts = (Double)args[0];
        int code = this.board.voltageToDaCode(this.daPolarity, this.daGain, this.daRange, volts);
        this.out.println("Code = " + code);
    }

    private void procDioset(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioConfig[0] = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioConfig[1] = (Byte)args[1];
        }
        this.board.dioSetConfig(this.dioConfig);
    }

    private void procDioshow(int found, Object[] args) {
        this.out.println("Digital I/O parameters:");
        this.out.format("  Configuration = (%02x, %02x)\n", this.dioConfig[0], this.dioConfig[1]);
        this.out.println("  Port          = " + this.dioPort);
        this.out.format("  Word output   = %04x\n", this.dioWord);
        this.out.format("  Byte output   = %02x\n", this.dioByte);
        this.out.println("  Bit number    = " + this.dioBit);
    }

    private void procDioinbyte(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        byte value = this.board.dioInputByte(this.dioPort);
        this.out.format("Value = 0x%02x\n", value);
    }

    private void procDiooutbyte(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioByte = (Byte)args[1];
        }
        this.board.dioOutputByte(this.dioPort, this.dioByte);
    }

    private void procDioinword(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        short value = this.board.dioInputWord(this.dioPort);
        this.out.format("Value = 0x%04x\n", value);
    }

    private void procDiooutword(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioWord = (Short)args[1];
        }
        this.board.dioOutputWord(this.dioPort, this.dioWord);
    }

    private void procDioinbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Byte)args[1];
        }
        byte value = this.board.dioInputBit(this.dioPort, this.dioBit);
        this.out.println("Value = " + value);
    }

    private void procDiooutbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.dioByte = (Byte)args[2];
        }
        this.board.dioOutputBit(this.dioPort, this.dioBit, this.dioByte);
    }

    private void procDiosetbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Byte)args[1];
        }
        this.board.dioSetBit(this.dioPort, this.dioBit);
    }

    private void procDioclrbit(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dioPort = (Byte)args[0];
        }
        if ((found & 2) != 0) {
            this.dioBit = (Byte)args[1];
        }
        this.board.dioClearBit(this.dioPort, this.dioBit);
    }

    private void procCtrshow(int found, Object[] args) {
        this.out.println("Counter Parameters:");
        this.out.println("  Counter      = " + this.ctrSelect);
        this.out.println("  Direct value = " + this.ctrValue);
        this.out.format("  Direct code  = %02x\n", this.ctrCode);
        this.out.println("  Rate         = " + this.ctrRate);
    }

    private void procCtrsetvalue(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.ctrValue = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.ctrSelect = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.ctrCode = (Byte)args[2];
        }
        this.board.counterDirectSet(this.ctrCode, this.ctrValue, this.ctrSelect);
    }

    private void procCtrsetrate(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.ctrRate = ((Float)args[0]).floatValue();
        }
        if ((found & 2) != 0) {
            byte ctr = (Byte)args[1];
            this.board.counterSetRateSingle(this.ctrRate, ctr);
        } else {
            this.board.counterSetRate(this.ctrRate);
        }
    }

    private void procCtrread(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.ctrSelect = (Byte)args[0];
        }
        int value = this.board.counterRead(this.ctrSelect);
        this.out.println("Counter = " + value);
    }

    private void procIntshow(int found, Object[] args) {
        boolean times = false;
        boolean counts = false;
        boolean comb = false;
        if ((found & 1) != 0) {
            byte option = (Byte)args[0];
            if ((option & 1) != 0) {
                times = true;
            }
            if ((option & 2) != 0) {
                counts = true;
            }
            if ((option & 4) != 0) {
                comb = true;
            }
        }
        long intvl = this.intStop;
        float rate = 0.0f;
        int count = this.intCount;
        if (intvl == 0L) {
            intvl = System.nanoTime();
        }
        if ((intvl -= this.intStart) != 0L) {
            rate = 1.0E9f * (float)count / (float)intvl;
        }
        this.out.println("Interrupt Parameters:");
        this.out.format("  Type         = %s (%s)\n", this.intType, itypTypes.decode(this.intType));
        this.out.println("  Req. Rate    = " + this.intRate);
        this.out.println("  Clock        = " + this.intClock);
        this.out.println("  Source       = " + this.intSrce);
        this.out.println("  Count        = " + this.intCount);
        this.out.println("  Actual Rate  = " + rate);
        if (times) {
            this.out.print("  Interval samples (nsec):");
            long prev = this.intSavst;
            int j = 0;
            while (j < this.intSaved) {
                if ((j & 3) == 0) {
                    this.out.println();
                }
                this.out.format("%14s", this.intTimes[j] - prev);
                prev = this.intTimes[j];
                ++j;
            }
            this.out.println();
        }
        if (counts) {
            this.out.print("  Counter samples:");
            int j = 0;
            while (j < this.intSaved) {
                if ((j & 7) == 0) {
                    this.out.println();
                }
                this.out.format("%7s", this.intCounts[j]);
                ++j;
            }
            this.out.println();
        }
        if (comb) {
            this.out.println("  Combined samples:");
            int j = 0;
            while (j < 2) {
                this.out.format("%13s %5s %8s %8s", "Intvl(ns)", "Cntr", "Dvn(ns)", "Dly(ns)");
                ++j;
            }
            this.out.println();
            j = 0;
            while (j < 2) {
                this.out.format("%13s %5s %8s %8s", "---------", "----", "-------", "-------");
                ++j;
            }
            long prev = this.intSavst;
            int expTime = (int)(1.0E9 / (double)this.intRate);
            int mult = this.intClock == 0 ? 10000 : 100;
            int cntMax = expTime / mult;
            if (cntMax >= 65536) {
                expTime = (cntMax -= 65536) * mult;
            }
            int j2 = 0;
            while (j2 < this.intSaved) {
                if ((j2 & 1) == 0) {
                    this.out.println();
                }
                int period = (int)(this.intTimes[j2] - prev);
                int delay = cntMax - this.intCounts[j2];
                if (delay < 0) {
                    delay += 65536;
                }
                this.out.format("%13s %5s %8s %8s", period, this.intCounts[j2], period - expTime, mult * delay);
                prev = this.intTimes[j2];
                ++j2;
            }
            this.out.println();
        }
        if (times || counts || comb) {
            this.intSaved = 0;
            this.intSavst = this.intLast;
        }
    }

    private void procIntstart(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.intRate = ((Float)args[0]).floatValue();
        }
        if ((found & 2) != 0) {
            this.intClock = (Byte)args[1];
        }
        if ((found & 4) != 0) {
            this.intSrce = (Byte)args[2];
        }
        if ((found & 8) != 0) {
            this.intDsc = (Byte)args[3] != 0;
        }
        byte source = (byte)(this.intSrce >> 1);
        byte counter = (byte)(this.intSrce & 1);
        this.intStart = this.intLast = System.nanoTime();
        this.intSavst = this.intLast;
        this.intStop = 0L;
        this.intCount = 0;
        this.intSaved = 0;
        int type = this.board.userInt(source, counter, this.intClock, this.intRate, this, "intProc", this.intDsc);
        if (type != 0) {
            this.intType = type;
            this.out.format("Interrupt type = %s (%s)\n", this.intType, itypTypes.decode(this.intType));
        }
    }

    private void procIntstop(int found, Object[] args) {
        this.board.cancelOpType(this.intType);
        this.intType = 0;
        this.intStop = System.nanoTime();
    }

    private void procIntcancel(int found, Object[] args) {
        int type = (Integer)args[0];
        if (type == 255) {
            this.board.cancelOp();
        } else {
            this.board.cancelOpType(type);
        }
    }

    private void procIntpause(int found, Object[] args) {
        this.board.pauseOp();
    }

    private void procIntresume(int found, Object[] args) {
        this.board.resumeOp();
    }

    private void procDshow(int found, Object[] args) {
        this.out.println("Direct I/O  Parameters:");
        this.out.println("  Register     = " + this.dReg);
        this.out.format("  Address      = %08x\n", this.dAddress);
        this.out.format("  Byte value   = %02x\n", this.dByte);
        this.out.format("  Word value   = %04x\n", this.dWord);
        this.out.format("  Long value   = %08x\n", this.dLong);
        this.out.println("  Repeat count = " + this.dCount);
        this.out.println("  Word size    = " + this.dWidth);
        this.out.print("  Word array   =");
        int j = 0;
        while (j < this.dWords.length) {
            this.out.format(" %04x", this.dWords[j]);
            j = (short)(j + 1);
        }
        this.out.println();
    }

    private void procInp(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        byte value = Dscud.inp(this.dAddress);
        this.out.format("Value = 0x%02x\n", value);
    }

    private void procInpw(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        short value = Dscud.inpw(this.dAddress);
        this.out.format("Value = 0x%04x\n", value);
    }

    private void procInpl(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        int value = Dscud.inpl(this.dAddress);
        this.out.format("Value = 0x%08x\n", value);
    }

    private void procInpws(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dCount = (Integer)args[1];
        }
        if (this.dCount > Short.MAX_VALUE) {
            this.dCount = Short.MAX_VALUE;
        }
        short[] value = new short[this.dCount];
        Dscud.inpws(this.dAddress, value, (short)this.dCount);
        this.out.print("Values =");
        int j = 0;
        while (j < this.dCount) {
            if (j > 0 && (j & 7) == 0) {
                this.out.print("\n        ");
            }
            this.out.format(" %04x", value[j]);
            ++j;
        }
        this.out.println();
    }

    private void procOut(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dByte = (Byte)args[1];
        }
        Dscud.outp(this.dAddress, this.dByte);
    }

    private void procOutw(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dWord = (Short)args[1];
        }
        Dscud.outpw(this.dAddress, this.dWord);
    }

    private void procOutl(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dLong = (Integer)args[1];
        }
        Dscud.outpl(this.dAddress, this.dLong);
    }

    private void procOutws(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dAddress = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dCount = (Integer)args[1];
        }
        if (this.dCount > this.dWords.length) {
            this.dCount = this.dWords.length;
        }
        int j = 0;
        while (j < this.dCount) {
            if ((found & 1 << j + 2) != 0) {
                this.dWords[j] = (Short)args[j + 2];
            }
            ++j;
        }
        Dscud.outpws(this.dAddress, this.dWords, (short)this.dCount);
    }

    private void procRegread(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dReg = (Short)args[0];
        }
        byte value = this.board.registerRead(this.dReg);
        this.out.format("Value = 0x%02x\n", value);
    }

    private void procRegwrite(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dReg = (Short)args[0];
        }
        if ((found & 2) != 0) {
            this.dByte = (Byte)args[1];
        }
        this.board.registerWrite(this.dReg, this.dByte);
    }

    private void procTimeread(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.dCount = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dAddress = (Integer)args[1];
        }
        if ((found & 4) != 0) {
            this.dWidth = (Byte)args[2];
        }
        long msec = System.currentTimeMillis();
        if (this.dWidth == 4) {
            int j = 0;
            while (j < this.dCount) {
                Dscud.inpl(this.dAddress);
                ++j;
            }
        } else if (this.dWidth == 2) {
            int j = 0;
            while (j < this.dCount) {
                Dscud.inpw(this.dAddress);
                ++j;
            }
        } else {
            int j = 0;
            while (j < this.dCount) {
                Dscud.inp(this.dAddress);
                ++j;
            }
        }
        msec = System.currentTimeMillis() - msec;
        this.out.println("Performed " + this.dCount + " operations in " + msec + " msec");
    }

    private void procDump(int found, Object[] args) {
        int mask;
        if ((found & 1) != 0) {
            this.dmpAddr = (Integer)args[0];
        }
        if ((found & 2) != 0) {
            this.dmpCount = (Integer)args[1];
        }
        if ((found & 4) != 0) {
            this.dmpWidth = (Integer)args[2];
        }
        int n = this.dmpWidth == 1 ? 15 : (mask = this.dmpWidth == 2 ? 7 : 3);
        String frmt = this.dmpWidth == 1 ? "2" : (this.dmpWidth == 2 ? "4" : "8");
        frmt = " %0" + frmt + "x";
        int j = 0;
        while (j < this.dmpCount) {
            if ((j & mask) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%08x:", this.dmpAddr);
            }
            this.out.format(frmt, Dscud.peek(this.dmpAddr, this.dmpWidth));
            this.dmpAddr += this.dmpWidth;
            ++j;
        }
        if (this.dmpCount > 0) {
            this.out.println();
        }
    }

    private void procShowtimer(int found, Object[] args) {
        this.out.println("Timer value = " + Dscud.getTime() + " ms");
    }

    private void procShowboard(int found, Object[] args) {
        this.out.println("Board type = " + Dscud.getBoardMacro((String)args[0]));
    }

    private void procThrshow(int found, Object[] args) {
        Thread[] threads = new Thread[Thread.activeCount()];
        int nThread = Thread.enumerate(threads);
        this.out.println("Thread information:");
        int j = 0;
        while (j < nThread) {
            this.out.println("  " + threads[j]);
            ++j;
        }
    }

    private void procThrstop(int found, Object[] args) {
        String name = (String)args[0];
        Thread[] threads = new Thread[Thread.activeCount()];
        int nThread = Thread.enumerate(threads);
        int j = 0;
        while (j < nThread) {
            if (threads[j].getName().equals(name)) {
                threads[j].stop();
                return;
            }
            ++j;
        }
        this.out.println("Thread " + name + " not found");
    }

    private void procThrdaemon(int found, Object[] args) {
        int oper = -1;
        String name = (String)args[0];
        if ((found & 2) != 0) {
            oper = (Integer)args[1];
        }
        Thread[] threads = new Thread[Thread.activeCount()];
        int nThread = Thread.enumerate(threads);
        int j = 0;
        while (j < nThread) {
            if (threads[j].getName().equals(name)) break;
            ++j;
        }
        if (j >= nThread) {
            this.out.println("Thread " + name + " not found");
        } else if (oper < 0) {
            this.out.format("Thread %s is%s a daemon\n", name, threads[j].isDaemon() ? "" : " not");
        } else {
            threads[j].setDaemon(oper > 0);
        }
    }

    public void cleanup() {
        try {
            this.board.freeBoard();
        }
        catch (DscudException dscudException) {}
    }

    private void intProc() {
        this.intLast = System.nanoTime();
        if (this.intSaved < 64) {
            this.intTimes[this.intSaved] = this.intLast;
            this.board.registerWrite((short)1, (byte)0);
            this.board.registerWrite((short)15, (byte)-64);
            this.intCounts[this.intSaved] = this.board.registerRead((short)12) & 0xFF | this.board.registerRead((short)13) << 8 & 0xFF00;
            ++this.intSaved;
        }
        ++this.intCount;
    }
}

