/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dscud;

import java.io.IOException;
import java.util.Scanner;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.dscud.Dscud;
import org.lsst.ccs.drivers.dscud.DscudException;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestDscud
implements CmndProc.Dispatch {
    private ConsoleReader reader;
    private static final int INT_TYPE_ALL = 255;
    private static final int CMD_INIT = 0;
    private static final int CMD_FREE = 1;
    private static final int CMD_SHOW = 2;
    private static final int CMD_DIOSET = 3;
    private static final int CMD_DIOINBYTE = 4;
    private static final int CMD_DIOINWORD = 5;
    private static final int CMD_DIOOUTBYTE = 6;
    private static final int CMD_DIOOUTWORD = 7;
    private static final int CMD_DIOINBIT = 8;
    private static final int CMD_DIOOUTBIT = 9;
    private static final int CMD_DIOSETBIT = 10;
    private static final int CMD_DIOCLRBIT = 11;
    private static final int CMD_DIOSHOW = 12;
    private static final int CMD_ADSET = 13;
    private static final int CMD_ADSETCHAN = 14;
    private static final int CMD_ADSAMPLE = 15;
    private static final int CMD_ADSAMPAVG = 16;
    private static final int CMD_ADSAMPINT = 17;
    private static final int CMD_ADSCAN = 18;
    private static final int CMD_ADSCANAVG = 19;
    private static final int CMD_ADSCANINT = 20;
    private static final int CMD_ADAUTOCAL = 21;
    private static final int CMD_ADCALVERIFY = 22;
    private static final int CMD_ADCTOV = 23;
    private static final int CMD_ADVTOC = 24;
    private static final int CMD_ADSHOW = 25;
    private static final int CMD_ADSHOWFIFO = 26;
    private static final int CMD_DASET = 27;
    private static final int CMD_DASETPOL = 28;
    private static final int CMD_DACONV = 29;
    private static final int CMD_DASCAN = 30;
    private static final int CMD_DAAUTOCAL = 31;
    private static final int CMD_DACALVERIFY = 32;
    private static final int CMD_DACTOV = 33;
    private static final int CMD_DAVTOC = 34;
    private static final int CMD_DASHOW = 35;
    private static final int CMD_INP = 36;
    private static final int CMD_INPW = 37;
    private static final int CMD_INPL = 38;
    private static final int CMD_INPWS = 39;
    private static final int CMD_OUT = 40;
    private static final int CMD_OUTW = 41;
    private static final int CMD_OUTL = 42;
    private static final int CMD_OUTWS = 43;
    private static final int CMD_DSHOW = 44;
    private static final int CMD_SHOWREGS = 45;
    private static final int CMD_SHOWERROR = 46;
    private static final int CMD_CTRSETVALUE = 47;
    private static final int CMD_CTRSETRATE = 48;
    private static final int CMD_CTRREAD = 49;
    private static final int CMD_CTRSHOW = 50;
    private static final int CMD_TIMEREAD = 51;
    private static final int CMD_INTSTART = 52;
    private static final int CMD_INTSTOP = 53;
    private static final int CMD_INTCANCEL = 54;
    private static final int CMD_INTPAUSE = 55;
    private static final int CMD_INTRESUME = 56;
    private static final int CMD_INTSHOW = 57;
    private static final int CMD_DUMP = 58;
    private static final int CMD_THRSHOW = 59;
    private static final int CMD_THRSTOP = 60;
    private static final int CMD_THRDAEMON = 61;
    private static final int CMD_REGREAD = 62;
    private static final int CMD_REGWRITE = 63;
    private static final int CMD_SHOWBOARD = 64;
    private static final int CMD_SHOWTIMER = 65;
    private static final int NUM_CMDS = 66;
    private static final String[] helpInit = new String[]{"Initialize a board", "init <type> <address> <level> <clkfreq0> <clkfreq1> <clkslct1>", "type       The board type (default helios)", "address    The board address (default 0x280)", "level      The interrupt level (default 5)", "clkfreq0   The frequency of clock 0 (default 0: 10 MHz)", "clkfreq1   The frequency of clock 1 (default 0: 10 MHz)", "clkslct1   The source for clock 1 (default 0: internal)"};
    private static final String[] helpShow = new String[]{"Show the current initialization parameters", "show"};
    private static final String[] helpShowregs = new String[]{"Read and display the board's registers", "showregs"};
    private static final String[] helpShowerror = new String[]{"Show last error, or the string for a code", "showerror <code>", "code   The error code (default last occuring error)"};
    private static final String[] helpFree = new String[]{"Free the board", "free"};
    private static final String[] helpAdset = new String[]{"Set parameters for analog input (ADCs)", "adset <chan> <gain> <range> <polarity> <loadcal> <scanint> <diff>", "chan      The analog channel to use in sample operations", "gain      The input gain to use (0 - 3)", "range     The input range to use (0 - 1)", "polarity  The polarity of the input (0 - 1)", "loadcal   If non-zero, load calibration values", "scanint   The interval between successive channels in a scan (0 - 5)", "diff      0 = single-ended input; 1 = differential input"};
    private static final String[] helpAdsetchan = new String[]{"Set ADC channel range for sampling", "adsetchan <lowchan> <highchan>", "lowchan    The first channel to use (0 - 15)", "highchan   The last channel to use (0 - 15, >= lowchan)"};
    private static final String[] helpAdshow = new String[]{"Show the current analog input parameters", "adshow"};
    private static final String[] helpAdshowfifo = new String[]{"Show the state of the analog input FIFO", "adshowfifo"};
    private static final String[] helpAdsample = new String[]{"Read and display current ADC channel value", "adsamp"};
    private static final String[] helpAdsampavg = new String[]{"Average several reads of current ADC channel", "adsampavg <count>", "count   The number of samples to read and average"};
    private static final String[] helpAdsampint = new String[]{"Read ADC channels using interrupts", "adsampint <nsamp> <lowchan> <highchan> <rate> <clksrc> <depth> <thresh>", "nsamp      The number of samples to read", "lowchan    The lowest channel number to read", "highchan   The highest channel number to read", "rate       The sample rate (Hz); cannot exceed 100000", "clksrc     The clock frequency; 0 = 100 KHz, 1 = 10 MHz", "depth      The FIFO depth to use, or -1 to disable the FIFO", "thresh     The FIFO threshold for triggering readouts"};
    private static final String[] helpAdscan = new String[]{"Read and display a set of ADC channels", "adscan <lowchan> <highchan>", "lowchan    The first channel to scan (0 - 15)", "highchan   The last channel to scan (0 - 15, >= lowscan)"};
    private static final String[] helpAdscanavg = new String[]{"Average several reads of a set of ADC channels", "adscanavg <lowchan> <highchan> <count>", "lowchan    The first channel to scan (0 - 15)", "highchan   The last channel to scan (0 - 15, >= lowscan)", "count      The number of samples to read and average"};
    private static final String[] helpAdscanint = new String[]{"Scan ADC channels using interrupts", "adscanint <nsamp> <lowchan> <highchan> <rate> <clksrc> <depth> <thresh>", "nsamp      The number of samples to read", "lowchan    The lowest channel number to read", "highchan   The highest channel number to read", "rate       The sample rate (Hz); cannot exceed 100000", "clksrc     The clock frequency; 0 = 100 KHz, 1 = 10 MHz", "depth      The FIFO depth to use, or -1 to disable the FIFO", "thresh     The FIFO threshold for triggering readouts"};
    private static final String[] helpAdautocal = new String[]{"Perform auto calibration of analog input", "adautocal <range> <bootrange>", "range      The range (0 - 15, or 255) to be auto-calibrated", "bootrange  The calibration range (0 - 15) to load at boot time"};
    private static final String[] helpAdcalverify = new String[]{"Verify the analog input auto calibration", "adcalverify <range> <bootrange>", "range      The range (0 - 15) to be verified"};
    private static final String[] helpAdctov = new String[]{"Convert analog input code to voltage", "adctov <code>", "code   The code value (-32768 - 32767) to be converted"};
    private static final String[] helpAdvtoc = new String[]{"Convert analog input voltage to code", "advtoc <voltage>", "voltage  The voltage to be converted to a code value"};
    private static final String[] helpDaset = new String[]{"Set parameters for analog output", "daset <polarity> <loadcal> <range> <gain> <simupdate> <polenab> <urset> <urchan>", "polarity   The polarity of the output (0 - 1)", "loadcal    If non-zero, load calibration values first", "range      The range to use for conversions: 0 = 5.0, 1 = 10.0", "gain       The output gain to use (0 - 2)", "simupdate  If non-zero, output all voltages simultaneously", "polenab    If non-zero, use software polarity, not hardware", "urset      If non-zero, the gain is set on a unique channel", "urchan     The unique channel for the gain setting"};
    private static final String[] helpDasetpol = new String[]{"Set the polarity for analog output", "dasetpol <polarity>", "polarity  The polarity of the analog output (0 - 1)"};
    private static final String[] helpDashow = new String[]{"Show the current analog output parameters", "dashow"};
    private static final String[] helpDaautocal = new String[]{"Perform auto calibration of analog output", "daautocal <range>", "range  The range (0 - 15) to be auto-calibrated"};
    private static final String[] helpDacalverify = new String[]{"Verify the analog output auto calibration", "dacalverify <range>", "range  The range (0 - 15) to be verified"};
    private static final String[] helpDaconv = new String[]{"Write a value to an analog output channel", "daconv <chan> <code>", "chan    The analog output channel to use (0 - 3)", "code    The value to output"};
    private static final String[] helpDascan = new String[]{"Write values to a set of analog output channels", "dascan"};
    private static final String[] helpDactov = new String[]{"Convert analog output code to voltage", "dactov <code>", "code   The code value (0 - 4095) to be converted"};
    private static final String[] helpDavtoc = new String[]{"Convert analog output voltage to code", "davtoc <voltage>", "voltage  The voltage to be converted to a code value"};
    private static final String[] helpDioset = new String[]{"Set digital I/O parameters", "dioset <id> <value>", "id       The ID of the entity to set", "value    The value to set"};
    private static final String[] helpDioshow = new String[]{"Show the current digital I/O parameters", "dioshow"};
    private static final String[] helpDioinbyte = new String[]{"Read and display a byte from a digital I/O port", "dioinbyte <port>", "port    The digital I/O port to read"};
    private static final String[] helpDioinword = new String[]{"Read and display a word (16-bit) from a digital I/O port", "dioinword <port>", "port    The digital I/O port to read"};
    private static final String[] helpDiooutbyte = new String[]{"Write a byte to a digital I/O port", "diooutbyte <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDiooutword = new String[]{"Write a word (16-bit) to a digital I/O port", "diooutword <port> <value>", "port    The digital I/O port to write to", "value   The value to write"};
    private static final String[] helpDioinbit = new String[]{"Read and display a bit from a digital I/O port", "dioinbit <port> <bitnum>", "port    The digital I/O port to read", "bitnum  The number of the bit to read"};
    private static final String[] helpDiooutbit = new String[]{"Write a bit to a digital I/O port", "diooutbit <port> <bitnum> <value>", "port    The digital I/O port to write to", "bitnum  The number of the bit to write", "value   The value to set the bit to"};
    private static final String[] helpDiosetbit = new String[]{"Set a bit in a digital I/O port", "diosetbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to set"};
    private static final String[] helpDioclearbit = new String[]{"Clear a bit in a digital I/O port", "dioclearbit <port> <bitnum>", "port    The digital I/O port to write to", "bitnum  The number of the bit to clear"};
    private static final String[] helpCtrshow = new String[]{"Show the current counter parameters", "ctrshow [<option>]", "option  Display option bits: 1 = times, 2 = counts"};
    private static final String[] helpCtrsetvalue = new String[]{"Set the value of a counter", "ctrsetvalue <value> <counter> <code>", "value    The value to initialize the counter to", "counter  The counter to be initialized", "code     The control code to use"};
    private static final String[] helpCtrsetrate = new String[]{"Set the frequency of a counter", "ctrsetrate <freq> <counter>", "freq     The frequency to initialize the counter to", "counter  The counter to be initialized (default all)"};
    private static final String[] helpCtrread = new String[]{"Read the value of a counter", "ctrread <counter>", "counter  The counter to be read"};
    private static final String[] helpIntshow = new String[]{"Show counter interrupt statistics", "intshow [<option>]", "option  Display option bits: 1 = intervals, 2 = counts, 4 = combined"};
    private static final String[] helpIntstart = new String[]{"Start counter interrupts", "intstart <rate> <clock> <source> [<method>]", "rate     The interrupt rate, or 0 if pre-programmed", "clock    The clock frequency to use: 0 = 100 KHz, 1 = 10 MHz", "source   The interrupt source: 0 = ctr0, 1 = ctr1, 2 = ext (dflt 1)", "method   The interrupt handling method: 0 = local, 1 = DSC (dflt 0)"};
    private static final String[] helpIntstop = new String[]{"Stop counter interrupts", "intstop"};
    private static final String[] helpIntcancel = new String[]{"Cancel active interrupt processing", "intcancel <type>", "type   The type (cou, dioi, ad, da or all) of interrupt to cancel"};
    private static final String[] helpIntpause = new String[]{"Pause all interrupt processing", "intpause"};
    private static final String[] helpIntresume = new String[]{"Resume all interrupt processing", "intresume"};
    private static final String[] helpDshow = new String[]{"Show the current direct I/O parameters", "dshow"};
    private static final String[] helpInp = new String[]{"Read and display a byte from I/O space", "inp <address>", "address  The address from which to read a byte"};
    private static final String[] helpInpw = new String[]{"Read and display a 16-bit word from I/O space", "inpw <address>", "address  The address from which to read a 16-bit word"};
    private static final String[] helpInpl = new String[]{"Read and display a 32-bit word from I/O space", "inpl <address>", "address  The address from which to read a 32-bit integer"};
    private static final String[] helpInpws = new String[]{"Read and display 16-bit words from I/O space FIFO", "inpws <address> <count>", "address  The address from which to read 16-bit words", "count    The number of words to read at <address>"};
    private static final String[] helpOut = new String[]{"Write a byte to I/O space", "out <address> <value>", "address  The address at which to write a byte", "value    The value to write"};
    private static final String[] helpOutw = new String[]{"Write a 16-bit word to I/O space", "outw <address> <value>", "address  The address at which to write a 16-bit word", "value    The value to write"};
    private static final String[] helpOutl = new String[]{"Write a 32-bit word to I/O space", "outl <address> <value>", "address  The address at which to write a 32-bit integer", "value    The value to write"};
    private static final String[] helpOutws = new String[]{"Write 16-bit words to I/O space FIFO", "outws <address> <value1>... <value8>", "address  The address at which to write 16-bit words", "valuen   The values to write at <address>"};
    private static final String[] helpRegread = new String[]{"Read a board register", "regread <register>", "register  The register number from which to read a byte"};
    private static final String[] helpRegwrite = new String[]{"Write to a board register", "regwrite <register> <value>", "register  The register number to which to write a byte", "value     The value to write"};
    private static final String[] helpTimeread = new String[]{"Time reading from an address", "timeread <count> <address> <width>", "count    The number of times to perform the read", "address  The address at which to read (default board address)", "width    The size (1, 2 or 4) of the word to read (default 1)"};
    private static final String[] helpDump = new String[]{"Dump memory contents", "dump <address> <nbytes>", "address  The address at which to start the dump", "nbytes   The number of bytes to dump"};
    private static final String[] helpShowtimer = new String[]{"Show the value of the interval timer (ms)", "showtimer"};
    private static final String[] helpShowboard = new String[]{"Show the code for a named board type", "showboard"};
    private static final String[] helpThrshow = new String[]{"Show thread information", "thrshow"};
    private static final String[] helpThrstop = new String[]{"Stop a thread", "thrstop <name>"};
    private static final String[] helpThrdaemon = new String[]{"Check or set a thread's daemon status", "thrdaemon <name> <op>"};
    private static final String[] fifoStatus = new String[]{"U", "E", "H", "HE", "F", "FE", "FH", "FHE", "O", "OE", "OH", "OHE", "OF", "OFE", "OFH", "OFHE"};
    private static final int MAX_INT_SAVED = 64;
    private final Output out;
    private Dscud board;
    private CmndProc proc;
    private CmndProc.Lookup brdTypes;
    private CmndProc.Lookup diffTypes;
    private CmndProc.Lookup gainTypes;
    private CmndProc.Lookup sintTypes;
    private CmndProc.Lookup polTypes;
    private CmndProc.Lookup rngTypes;
    private CmndProc.Lookup itypTypes;
    private short baseAddr = (short)640;
    private byte boardType = (byte)35;
    private byte intLevel = (byte)5;
    private byte clkFreq0 = 0;
    private byte clkFreq1 = 0;
    private byte clkSlct1 = 0;
    private boolean initd = false;
    private int adAvgCount = 1;
    private int adSmpCount = 1;
    private int adCurr = 0;
    private int adThresh = 0;
    private short adFifoDepth = 0;
    private byte adChan = 0;
    private byte adGain = 0;
    private byte adRange = 1;
    private byte adPolarity = 0;
    private byte adScanIntv = 0;
    private byte adDiff = 0;
    private byte adLowChan = 0;
    private byte adHighChan = (byte)15;
    private byte adLow = 0;
    private byte adHigh = 0;
    private byte adClksrc = 0;
    private float adRate = 100000.0f;
    private boolean adLoadCal = false;
    private int daCode = 0;
    private int[] daCodes = new int[4];
    private int[] daChanEnab = new int[4];
    private byte daPolarity = 0;
    private byte daGain = 0;
    private byte daUrChan = 0;
    private byte daChan = 0;
    private float daRange = 5.0f;
    private boolean daLoadCal = false;
    private boolean daSimUpd = false;
    private boolean daPolEnab = false;
    private boolean daUrSet = false;
    private short dioWord = 0;
    private byte dioPort = 0;
    private byte dioByte = 0;
    private byte dioBit = 0;
    private byte[] dioConfig = new byte[2];
    private int dAddress = 0;
    private int dLong = 0;
    private int dCount = 1;
    private short dReg = 0;
    private short dWord = 0;
    private short[] dWords = new short[8];
    private byte dByte = 0;
    private byte dWidth = 1;
    private int ctrValue = 0;
    private byte ctrSelect = 1;
    private byte ctrCode = 0;
    private float ctrRate = 1.0f;
    private long intStart = 0L;
    private long intStop = 0L;
    private long intLast = 0L;
    private long intSavst = 0L;
    private long[] intTimes = new long[64];
    private int intType = 0;
    private int intCount = 0;
    private int intSaved = 0;
    private int[] intCounts = new int[64];
    private byte intClock = 0;
    private byte intSrce = 1;
    private float intRate = 100.0f;
    private boolean intDsc = false;
    private int dmpAddr = 0;
    private int dmpCount = 4;
    private int dmpWidth = 4;
    private static final String[] heliosDesc = new String[]{"| AD7  | AD6  | AD5  | AD4  | AD3  | AD2  | AD1  | AD0  |", "| AD15 | AD14 | AD13 | AD12 | AD11 | AD10 | AD9  | AD8  |", "|  H3  |  H2  |  H1  |  H0  |  L3  |  L2  |  L1  |  L0  |", "|ADBUSY|SE/DIF|ADWAIT|DACBSY|  OF  |SCANEN| ADG1 | ADG0 |", "|CKSEL1|FRQSL1|FRQSL0|ADCLK |  -   |TINTE |DINTE |AINTE |", "|  -   |  -   | FT5  | FT4  | FT3  | FT2  | FT1  | FT0  |", "|  -   |  -   | FD5  | FD4  | FD3  | FD2  | FD1  | FD0  |", "|  -   | TINT | DINT | AINT |ADCH3 |ADCH2 |ADCH1 |ADCH0 |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  B7  |  B6  |  B5  |  B4  |  B3  |  B2  |  B1  |  B0  |", "|  C7  |  C6  |  C5  |  C4  |  C3  |  C2  |  C1  |  C0  |", "|DIOCTR|DAMODE|DASIM | DIRA |DIRCH |  -   | DIRB |DIRCL |", "|CTRD7 |CTRD6 |CTRD5 |CTRD4 |CTRD3 |CTRD2 |CTRD1 |CTRD0 |", "|CTRD15|CTRD14|CTRD13|CTRD12|CTRD11|CTRD10|CTRD9 |CTRD8 |", "|CTRD23|CTRD22|CTRD21|CTRD20|CTRD19|CTRD18|CTRD17|CTRD16|", "|                  FPGA Revision Code                   |", "|  D7  |  D6  |  D5  |  D4  |  D3  |  D2  |  D1  |  D0  |", "|  A7  |  A6  |  A5  |  A4  |  A3  |  A2  |  A1  |  A0  |", "|  -   |TDBUSY|EEBUSY|CALMUX|  -   |  -   |  -   |  -   |", "|                       Not Used                        |", "|  -   |  -   |  -   |  -   |  -   |  -   |  -   |EXFIFO|", "| DAUR |DACH1 |DACH0 |  -   |ADPOL |  -   | ADSD |  -   |", "|  -   |  -   |  -   |DASIZE|DAPOL |  -   | DAG1 | DAG0 |", "|                D/A Simultaneous Update                |", "| FD07 | FD06 | FD05 | FD04 | FD03 | FD02 | FD01 | FD00 |", "| FD11 | FD10 | FD09 | FD08 |  OF  |  FF  |  HF  |  EF  |"};
    private static final String[] pageDesc = new String[]{"Counter/Timer Access", "AutoCal Control", "Expanded FIFO and AD/DA Control"};

    TestDscud(Output iOut) throws IOException {
        this.out = iOut != null ? iOut : new ConsOut();
        CmndProc.Command cmnd = new CmndProc.Command(66);
        cmnd.add("init", 0, helpInit);
        cmnd.add("show", 2, helpShow);
        cmnd.add("showregs", 45, helpShowregs);
        cmnd.add("showerror", 46, helpShowerror);
        cmnd.add("free", 1, helpFree);
        cmnd.add("adset", 13, helpAdset);
        cmnd.add("adsetchan", 14, helpAdsetchan);
        cmnd.add("adshow", 25, helpAdshow);
        cmnd.add("adshowfifo", 26, helpAdshowfifo);
        cmnd.add("adsamp", 15, helpAdsample);
        cmnd.add("adsampavg", 16, helpAdsampavg);
        cmnd.add("adsampint", 17, helpAdsampint);
        cmnd.add("adscan", 18, helpAdscan);
        cmnd.add("adscanavg", 19, helpAdscanavg);
        cmnd.add("adscanint", 20, helpAdscanint);
        cmnd.add("adautocal", 21, helpAdautocal);
        cmnd.add("adcalverify", 22, helpAdcalverify);
        cmnd.add("adctov", 23, helpAdctov);
        cmnd.add("advtoc", 24, helpAdvtoc);
        cmnd.add("daset", 27, helpDaset);
        cmnd.add("dasetpol", 28, helpDasetpol);
        cmnd.add("dashow", 35, helpDashow);
        cmnd.add("daconv", 29, helpDaconv);
        cmnd.add("dascan", 30, helpDascan);
        cmnd.add("daautocal", 31, helpDaautocal);
        cmnd.add("dacalverify", 32, helpDacalverify);
        cmnd.add("dactov", 33, helpDactov);
        cmnd.add("davtoc", 34, helpDavtoc);
        cmnd.add("dioset", 3, helpDioset);
        cmnd.add("dioshow", 12, helpDioshow);
        cmnd.add("dioinbyte", 4, helpDioinbyte);
        cmnd.add("dioinword", 5, helpDioinword);
        cmnd.add("diooutbyte", 6, helpDiooutbyte);
        cmnd.add("diooutword", 7, helpDiooutword);
        cmnd.add("dioinbit", 8, helpDioinbit);
        cmnd.add("diooutbit", 9, helpDiooutbit);
        cmnd.add("diosetbit", 10, helpDiosetbit);
        cmnd.add("dioclearbit", 11, helpDioclearbit);
        cmnd.add("ctrshow", 50, helpCtrshow);
        cmnd.add("ctrsetvalue", 47, helpCtrsetvalue);
        cmnd.add("ctrsetrate", 48, helpCtrsetrate);
        cmnd.add("ctrread", 49, helpCtrread);
        cmnd.add("intshow", 57, helpIntshow);
        cmnd.add("intstart", 52, helpIntstart);
        cmnd.add("intstop", 53, helpIntstop);
        cmnd.add("intcancel", 54, helpIntcancel);
        cmnd.add("intpause", 55, helpIntpause);
        cmnd.add("intresume", 56, helpIntresume);
        cmnd.add("dshow", 44, helpDshow);
        cmnd.add("inp", 36, helpInp);
        cmnd.add("inpw", 37, helpInpw);
        cmnd.add("inpl", 38, helpInpl);
        cmnd.add("inpws", 39, helpInpws);
        cmnd.add("out", 40, helpOut);
        cmnd.add("outw", 41, helpOutw);
        cmnd.add("outl", 42, helpOutl);
        cmnd.add("outws", 43, helpOutws);
        cmnd.add("regread", 62, helpRegread);
        cmnd.add("regwrite", 63, helpRegwrite);
        cmnd.add("timeread", 51, helpTimeread);
        cmnd.add("dump", 58, helpDump);
        cmnd.add("showtimer", 65, helpShowtimer);
        cmnd.add("showboard", 64, helpShowboard);
        cmnd.add("thrshow", 59, helpThrshow);
        cmnd.add("thrstop", 60, helpThrstop);
        cmnd.add("thrdaemon", 61, helpThrdaemon);
        this.brdTypes = new CmndProc.Lookup(1);
        this.brdTypes.add("Helios", 35);
        this.diffTypes = new CmndProc.Lookup(2);
        this.diffTypes.add("SINGLE_ENDED", 0);
        this.diffTypes.add("DIFFERENTIAL", 1);
        this.gainTypes = new CmndProc.Lookup(4);
        this.gainTypes.add("GAIN_1", 0);
        this.gainTypes.add("GAIN_2", 1);
        this.gainTypes.add("GAIN_4", 2);
        this.gainTypes.add("GAIN_8", 3);
        this.sintTypes = new CmndProc.Lookup(6);
        this.sintTypes.add("SCAN_INTERVAL_4", 5);
        this.sintTypes.add("SCAN_INTERVAL_5", 3);
        this.sintTypes.add("SCAN_INTERVAL_9", 4);
        this.sintTypes.add("SCAN_INTERVAL_10", 2);
        this.sintTypes.add("SCAN_INTERVAL_15", 1);
        this.sintTypes.add("SCAN_INTERVAL_20", 0);
        this.polTypes = new CmndProc.Lookup(2);
        this.polTypes.add("BIPOLAR", 0);
        this.polTypes.add("UNIPOLAR", 1);
        this.rngTypes = new CmndProc.Lookup(2);
        this.rngTypes.add("RANGE_5", 0);
        this.rngTypes.add("RANGE_10", 1);
        this.itypTypes = new CmndProc.Lookup(10);
        this.itypTypes.add("Inactive", 0);
        this.itypTypes.add("AD", 1);
        this.itypTypes.add("DA", 2);
        this.itypTypes.add("DIOIN", 4);
        this.itypTypes.add("USER", 8);
        this.itypTypes.add("COUNTER", 16);
        this.itypTypes.add("DIOREAD", 32);
        this.itypTypes.add("OPTO", 64);
        this.itypTypes.add("DIOWRITE", -128);
        this.itypTypes.add("ALL", 255);
        this.board = new Dscud();
        this.proc = new CmndProc();
        this.proc.add((CmndProc.Dispatch)this, cmnd);
        this.reader = new ConsoleReader();
    }

    TestDscud() throws IOException {
        this(null);
    }

    public static void main(String[] args) throws IOException {
        TestDscud test = new TestDscud();
        test.run();
        test.cleanup();
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (DscudException e) {
                this.out.println((Object)e);
            }
        }
    }

    public boolean dispatch(int cCode, Scanner scan) {
        Object[] args = new Object[16];
        switch (cCode) {
            case 0: {
                int type;
                String sType;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"swbbbb", (Object[])args);
                if (found < 0) break;
                if (this.initd) {
                    this.initd = false;
                    this.board.freeBoard();
                }
                if ((found & 1) != 0 && !(sType = (String)args[0]).equals("*") && (type = this.brdTypes.encode(sType, true)) >= 0) {
                    this.boardType = (byte)type;
                }
                if ((found & 2) != 0) {
                    this.baseAddr = (Short)args[1];
                }
                if ((found & 4) != 0) {
                    this.intLevel = (Byte)args[2];
                }
                if ((found & 8) != 0) {
                    this.clkFreq0 = (Byte)args[3];
                }
                if ((found & 0x10) != 0) {
                    this.clkFreq1 = (Byte)args[4];
                }
                if ((found & 0x20) != 0) {
                    this.clkSlct1 = (Byte)args[5];
                }
                this.dAddress = this.baseAddr;
                this.board.initBoard(this.boardType, this.baseAddr, this.intLevel, this.clkFreq0, this.clkFreq1, this.clkSlct1);
                this.initd = true;
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Initialization parameters:");
                this.out.println((Object)("  Board type       = " + this.brdTypes.decode((int)this.boardType)));
                this.out.format("  Base address     = %04x\n", new Object[]{this.baseAddr});
                this.out.println((Object)("  Interrupt level  = " + this.intLevel));
                this.out.format("  Clock0 frequency = %s (%s)\n", new Object[]{this.clkFreq0, this.clkFreq0 == 0 ? "10 MHz" : "1 MHz"});
                this.out.format("  Clock1 frequency = %s (%s)\n", new Object[]{this.clkFreq1, this.clkFreq1 == 0 ? "10 MHz" : "100 KHz"});
                this.out.format("  Clock1 source    = %s (%s)\n", new Object[]{this.clkSlct1, this.clkSlct1 == 0 ? "Internal" : "External"});
                break;
            }
            case 45: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.showRegs();
                break;
            }
            case 46: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    byte eCode = (Byte)args[0];
                    this.out.println((Object)(String.valueOf(eCode) + ": " + Dscud.getErrorString(eCode)));
                    break;
                }
                String[] text = new String[1];
                int eCode = Dscud.getLastError(text);
                this.out.println((Object)(String.valueOf(eCode) + ": " + text[0]));
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.initd = false;
                this.board.freeBoard();
                break;
            }
            case 13: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bbbbbbb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.adChan = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.adGain = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.adRange = (Byte)args[2];
                }
                if ((found & 8) != 0) {
                    this.adPolarity = (Byte)args[3];
                }
                if ((found & 0x10) != 0) {
                    boolean bl = this.adLoadCal = (Byte)args[4] != 0;
                }
                if ((found & 0x20) != 0) {
                    this.adScanIntv = (Byte)args[5];
                }
                if ((found & 0x40) != 0) {
                    this.adDiff = (Byte)args[6];
                }
                this.board.adSetSettings(this.adChan, this.adGain, this.adRange, this.adPolarity, this.adLoadCal, this.adScanIntv, this.adDiff);
                this.adLow = this.adHigh = this.adChan;
                this.adCurr = this.adHigh;
                break;
            }
            case 14: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                short[] cfr_ignored_0 = new short[16];
                if ((found & 1) != 0) {
                    this.adLowChan = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.adHighChan = (Byte)args[1];
                }
                this.board.adSetChannel(this.adLowChan, this.adHighChan);
                this.adLow = this.adLowChan;
                this.adCurr = this.adLow;
                this.adHigh = this.adHighChan;
                break;
            }
            case 25: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Analog input parameters:");
                this.out.println((Object)("  Sample channel    = " + this.adChan));
                this.out.format("  Gain              = %s (%s)\n", new Object[]{this.adGain, this.gainTypes.decode((int)this.adGain)});
                this.out.format("  Range             = %s (%s)\n", new Object[]{this.adRange, this.rngTypes.decode((int)this.adRange)});
                this.out.format("  Polarity          = %s (%s)\n", new Object[]{this.adPolarity, this.polTypes.decode((int)this.adPolarity)});
                this.out.println((Object)("  Load calibration  = " + this.adLoadCal));
                this.out.format("  Scan interval     = %s (%s)\n", new Object[]{this.adScanIntv, this.sintTypes.decode((int)this.adScanIntv)});
                this.out.format("  Differential      = %s (%s)\n", new Object[]{this.adDiff, this.diffTypes.decode((int)this.adDiff)});
                this.out.println((Object)("  Low channel reqd  = " + this.adLowChan));
                this.out.println((Object)("  High channel reqd = " + this.adHighChan));
                this.out.println((Object)("  Averaging count   = " + this.adAvgCount));
                this.out.println((Object)("  Intr sample count = " + this.adSmpCount));
                this.out.println((Object)("  Interrupt rate    = " + this.adRate));
                this.out.println((Object)("  Intr clock source = " + this.adClksrc));
                this.out.println((Object)("  Intr FIFO depth   = " + this.adFifoDepth));
                this.out.println((Object)("  Intr threshold    = " + this.adThresh));
                this.out.println((Object)("  Current channel   = " + this.adCurr));
                this.out.println((Object)("  Low channel set   = " + this.adLow));
                this.out.println((Object)("  High channel set  = " + this.adHigh));
                break;
            }
            case 26: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.print((Object)"Analog input FIFO status: ");
                byte reg5 = this.board.registerRead((short)5);
                byte reg6 = this.board.registerRead((short)6);
                this.board.registerWrite((short)1, (byte)2);
                byte reg12 = this.board.registerRead((short)12);
                if ((reg12 & 1) == 0) {
                    this.out.format("mode = basic, threshold = %s, depth = %s.\n", new Object[]{reg5, reg6});
                    break;
                }
                String fstatus = fifoStatus[reg6 & 0xF];
                int depth = (reg6 & 0xF0) << 8 | reg5 & 0xFF;
                this.out.format("mode = expanded, status = %s, depth = %s.\n", new Object[]{fstatus, depth});
                break;
            }
            case 15: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                short value = this.board.adSample();
                double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value);
                this.out.format("Channel %s: %04x ", new Object[]{this.adCurr, value});
                if (volts > -1.0 && volts < 1.0) {
                    this.out.format("(%.5f)\n", new Object[]{volts});
                } else {
                    this.out.format("(%.6g)\n", new Object[]{volts});
                }
                if (this.adCurr == this.adHigh) {
                    this.adCurr = this.adLow;
                    break;
                }
                if (++this.adCurr < 16) break;
                this.adCurr = 0;
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.adAvgCount = (Integer)args[0];
                }
                double value = this.board.adSampleAvg(this.adAvgCount);
                double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, (short)(value + 0.5));
                this.out.format("Channel %s: %.1f ", new Object[]{this.adCurr, value});
                if (volts > -1.0 && volts < 1.0) {
                    this.out.format("(%.5f)\n", new Object[]{volts});
                } else {
                    this.out.format("(%.6g)\n", new Object[]{volts});
                }
                int nchan = this.adHigh - this.adLow + 1;
                if (nchan <= 0) {
                    nchan += 16;
                }
                int j = 0;
                while (j < this.adAvgCount % nchan) {
                    if (this.adCurr == this.adHigh) {
                        this.adCurr = this.adLow;
                    } else if (++this.adCurr >= 16) {
                        this.adCurr = 0;
                    }
                    ++j;
                }
                break;
            }
            case 17: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"wbbfbwi", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.adSmpCount = ((Short)args[0]).shortValue();
                }
                if ((found & 2) != 0) {
                    this.adLowChan = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.adHighChan = (Byte)args[2];
                }
                if ((found & 8) != 0) {
                    this.adRate = ((Float)args[3]).floatValue();
                }
                if ((found & 0x10) != 0) {
                    this.adClksrc = (Byte)args[4];
                }
                if ((found & 0x20) != 0) {
                    this.adFifoDepth = (Short)args[5];
                }
                if ((found & 0x40) != 0) {
                    this.adThresh = (Integer)args[6];
                }
                short[] value = new short[this.adSmpCount];
                this.board.adSampleInt(this.adSmpCount, this.adLowChan, this.adHighChan, this.adRate, this.adClksrc, this.adFifoDepth, this.adThresh, value);
                this.adLow = this.adLowChan;
                this.adCurr = this.adLow;
                this.adHigh = this.adHighChan;
                int j = 0;
                while (j < this.adSmpCount) {
                    if (j > 0) {
                        this.out.print((Object)((j & 3) == 0 ? "\n" : " "));
                    }
                    double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
                    this.out.format("%2s: %04x ", new Object[]{this.adCurr, value[j]});
                    if (volts > -1.0 && volts < 1.0) {
                        this.out.format("(% -8.5f)", new Object[]{volts});
                    } else {
                        this.out.format("(% -8.6g)", new Object[]{volts});
                    }
                    if (this.adCurr == this.adHigh) {
                        this.adCurr = this.adLow;
                    } else if (++this.adCurr >= 16) {
                        this.adCurr = 0;
                    }
                    ++j;
                }
                this.out.println();
                break;
            }
            case 18: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                short[] value = new short[16];
                if ((found & 1) != 0) {
                    this.adLowChan = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.adHighChan = (Byte)args[1];
                }
                this.board.adScan(this.adLowChan, this.adHighChan, value);
                this.adLow = this.adLowChan < this.adHighChan ? this.adLowChan : this.adHighChan;
                this.adHigh = this.adLowChan > this.adHighChan ? this.adLowChan : this.adHighChan;
                int j = 0;
                int adCurr = this.adLow;
                while (j < this.adHigh - this.adLow + 1) {
                    if (j > 0) {
                        this.out.print((Object)((j & 3) == 0 ? "\n" : " "));
                    }
                    double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
                    this.out.format("%2s: %04x ", new Object[]{adCurr, value[j]});
                    if (volts > -1.0 && volts < 1.0) {
                        this.out.format("(% -8.5f)", new Object[]{volts});
                    } else {
                        this.out.format("(% -8.6g)", new Object[]{volts});
                    }
                    ++j;
                    ++adCurr;
                }
                this.out.println();
                break;
            }
            case 19: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bbi", (Object[])args);
                if (found < 0) break;
                double[] value = new double[16];
                if ((found & 1) != 0) {
                    this.adLowChan = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.adHighChan = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.adAvgCount = (Integer)args[2];
                }
                this.board.adScanAvg(this.adLowChan, this.adHighChan, value, this.adAvgCount);
                this.adLow = this.adLowChan < this.adHighChan ? this.adLowChan : this.adHighChan;
                this.adHigh = this.adLowChan > this.adHighChan ? this.adLowChan : this.adHighChan;
                int j = 0;
                int adCurr = this.adLow;
                while (j < this.adHigh - this.adLow + 1) {
                    if (j > 0) {
                        this.out.print((Object)(j % 3 == 0 ? "\n" : "    "));
                    }
                    double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, (short)(value[j] + 0.5));
                    this.out.format("%2s: %7.1f ", new Object[]{adCurr, value[j]});
                    if (volts > -1.0 && volts < 1.0) {
                        this.out.format("(% -8.5f)", new Object[]{volts});
                    } else {
                        this.out.format("(% -8.6g)", new Object[]{volts});
                    }
                    ++j;
                    ++adCurr;
                }
                this.out.println();
                break;
            }
            case 20: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"wbbfbwi", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.adSmpCount = ((Short)args[0]).shortValue();
                }
                if ((found & 2) != 0) {
                    this.adLowChan = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.adHighChan = (Byte)args[2];
                }
                if ((found & 8) != 0) {
                    this.adRate = ((Float)args[3]).floatValue();
                }
                if ((found & 0x10) != 0) {
                    this.adClksrc = (Byte)args[4];
                }
                if ((found & 0x20) != 0) {
                    this.adFifoDepth = (Short)args[5];
                }
                if ((found & 0x40) != 0) {
                    this.adThresh = (Integer)args[6];
                }
                short[] value = new short[this.adSmpCount];
                this.board.adScanInt(this.adSmpCount, this.adLowChan, this.adHighChan, this.adRate, this.adClksrc, this.adFifoDepth, this.adThresh, value);
                this.adLow = this.adLowChan;
                this.adCurr = this.adLow;
                this.adHigh = this.adHighChan;
                int j = 0;
                while (j < this.adSmpCount) {
                    if (j > 0) {
                        this.out.print((Object)((j & 3) == 0 ? "\n" : " "));
                    }
                    double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, value[j]);
                    this.out.format("%2s: %04x ", new Object[]{this.adCurr, value[j]});
                    if (volts > -1.0 && volts < 1.0) {
                        this.out.format("(% -8.5f)", new Object[]{volts});
                    } else {
                        this.out.format("(% -8.6g)", new Object[]{volts});
                    }
                    if (this.adCurr == this.adHigh) {
                        this.adCurr = this.adLow;
                    } else if (++this.adCurr >= 16) {
                        this.adCurr = 0;
                    }
                    ++j;
                }
                this.out.println();
                break;
            }
            case 21: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Bb", (Object[])args);
                if (found < 0) break;
                byte range = (Byte)args[0];
                byte bootRange = (found & 2) != 0 ? (Byte)args[1] : (byte)0;
                this.board.adAutoCal(range, bootRange);
                break;
            }
            case 22: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"B", (Object[])args);
                if (found < 0) break;
                float[] offset = new float[]{0.0f};
                float[] gain = new float[]{0.0f};
                byte range = (Byte)args[0];
                this.board.adCalVerify(range, offset, gain);
                this.out.format("Offset error = %1.4f, gain error = %1.4f\n", new Object[]{Float.valueOf(offset[0]), Float.valueOf(gain[0])});
                break;
            }
            case 23: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"W", (Object[])args);
                if (found < 0) break;
                short code = (Short)args[0];
                double volts = this.board.adCodeToVoltage(this.adPolarity, this.adGain, this.adRange, code);
                if (volts > -1.0 && volts < 1.0) {
                    this.out.format("Voltage = %.5f\n", new Object[]{volts});
                    break;
                }
                this.out.format("Voltage = %.6g\n", new Object[]{volts});
                break;
            }
            case 24: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"D", (Object[])args);
                if (found < 0) break;
                double volts = (Double)args[0];
                short code = this.board.voltageToAdCode(this.adPolarity, this.adGain, this.adRange, volts);
                this.out.println((Object)("Code = " + code));
                break;
            }
            case 27: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bbbbbbbb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.daPolarity = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    boolean bl = this.daLoadCal = (Byte)args[1] != 0;
                }
                if ((found & 4) != 0) {
                    float f = this.daRange = (Byte)args[2] != 0 ? 10.0f : 5.0f;
                }
                if ((found & 8) != 0) {
                    this.daGain = (Byte)args[3];
                }
                if ((found & 0x10) != 0) {
                    boolean bl = this.daSimUpd = (Byte)args[4] != 0;
                }
                if ((found & 0x20) != 0) {
                    boolean bl = this.daPolEnab = (Byte)args[5] != 0;
                }
                if ((found & 0x40) != 0) {
                    boolean bl = this.daUrSet = (Byte)args[6] != 0;
                }
                if ((found & 0x80) != 0) {
                    this.daUrChan = (Byte)args[7];
                }
                this.board.daSetSettings(this.daPolarity, this.daLoadCal, this.daRange, this.daGain, this.daSimUpd, this.daPolEnab, this.daUrSet, this.daUrChan);
                break;
            }
            case 28: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.daPolarity = (Byte)args[0];
                }
                this.board.daSetPolarity(this.daPolarity);
                break;
            }
            case 35: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Analog output parameters:");
                this.out.format("  Polarity            = %s (%s)\n", new Object[]{this.daPolarity, this.polTypes.decode(1 - this.daPolarity)});
                this.out.println((Object)("  Load calibration    = " + this.daLoadCal));
                this.out.println((Object)("  Range               = " + this.daRange));
                this.out.format("  Gain                = %s (%s)\n", new Object[]{this.daGain, this.gainTypes.decode((int)this.daGain)});
                this.out.println((Object)("  Simultaneous update = " + this.daSimUpd));
                this.out.println((Object)("  Polarity enable     = " + this.daPolEnab));
                this.out.println((Object)("  Set unique range    = " + this.daUrSet));
                this.out.println((Object)("  Unique channel      = " + this.daUrChan));
                break;
            }
            case 29: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bi", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.daChan = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.daCode = (Integer)args[1];
                }
                this.board.daConvert(this.daChan, this.daCode);
                break;
            }
            case 30: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bibibibi", (Object[])args);
                if (found < 0) break;
                if (found != 0) {
                    int j = 0;
                    while (j < this.daChanEnab.length) {
                        this.daChanEnab[j] = 0;
                        ++j;
                    }
                    j = 0;
                    while (j < 2 * this.daChanEnab.length) {
                        if ((found & 1 << j) != 0) {
                            byte chan = (Byte)args[j];
                            this.daChanEnab[chan] = 1;
                            if ((found & 1 << j + 1) != 0) {
                                this.daCodes[chan] = (Integer)args[j + 1];
                            }
                        }
                        j += 2;
                    }
                }
                this.board.daConvertScan(this.daChanEnab, this.daCodes);
                break;
            }
            case 31: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"B", (Object[])args);
                if (found < 0) break;
                byte range = (Byte)args[0];
                this.board.daAutoCal(range);
                break;
            }
            case 32: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"B", (Object[])args);
                if (found < 0) break;
                float[] offset = new float[]{0.0f};
                float[] gain = new float[]{0.0f};
                byte range = (Byte)args[0];
                this.board.daCalVerify(range, offset, gain);
                this.out.format("Offset error = %1.4f, gain error = %1.4f\n", new Object[]{Float.valueOf(offset[0]), Float.valueOf(gain[0])});
                break;
            }
            case 33: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                int code = (Integer)args[0];
                double volts = this.board.daCodeToVoltage(this.daPolarity, this.daGain, this.daRange, code);
                this.out.format("Voltage = %1.5f\n", new Object[]{volts});
                break;
            }
            case 34: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"D", (Object[])args);
                if (found < 0) break;
                double volts = (Double)args[0];
                int code = this.board.voltageToDaCode(this.daPolarity, this.daGain, this.daRange, volts);
                this.out.println((Object)("Code = " + code));
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioConfig[0] = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioConfig[1] = (Byte)args[1];
                }
                this.board.dioSetConfig(this.dioConfig);
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Digital I/O parameters:");
                this.out.format("  Configuration = (%02x, %02x)\n", new Object[]{this.dioConfig[0], this.dioConfig[1]});
                this.out.println((Object)("  Port          = " + this.dioPort));
                this.out.format("  Word output   = %04x\n", new Object[]{this.dioWord});
                this.out.format("  Byte output   = %02x\n", new Object[]{this.dioByte});
                this.out.println((Object)("  Bit number    = " + this.dioBit));
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                byte value = this.board.dioInputByte(this.dioPort);
                this.out.format("Value = 0x%02x\n", new Object[]{value});
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioByte = (Byte)args[1];
                }
                this.board.dioOutputByte(this.dioPort, this.dioByte);
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                short value = this.board.dioInputWord(this.dioPort);
                this.out.format("Value = 0x%04x\n", new Object[]{value});
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bw", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioWord = (Short)args[1];
                }
                this.board.dioOutputWord(this.dioPort, this.dioWord);
                break;
            }
            case 8: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioBit = (Byte)args[1];
                }
                byte value = this.board.dioInputBit(this.dioPort, this.dioBit);
                this.out.println((Object)("Value = " + value));
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bbb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioBit = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.dioByte = (Byte)args[2];
                }
                this.board.dioOutputBit(this.dioPort, this.dioBit, this.dioByte);
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioBit = (Byte)args[1];
                }
                this.board.dioSetBit(this.dioPort, this.dioBit);
                break;
            }
            case 11: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"bb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dioPort = (Byte)args[0];
                }
                if ((found & 2) != 0) {
                    this.dioBit = (Byte)args[1];
                }
                this.board.dioClearBit(this.dioPort, this.dioBit);
                break;
            }
            case 50: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Counter Parameters:");
                this.out.println((Object)("  Counter      = " + this.ctrSelect));
                this.out.println((Object)("  Direct value = " + this.ctrValue));
                this.out.format("  Direct code  = %02x\n", new Object[]{this.ctrCode});
                this.out.println((Object)("  Rate         = " + this.ctrRate));
                break;
            }
            case 47: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ibb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.ctrValue = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.ctrSelect = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.ctrCode = (Byte)args[2];
                }
                this.board.counterDirectSet(this.ctrCode, this.ctrValue, this.ctrSelect);
                break;
            }
            case 48: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"fb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.ctrRate = ((Float)args[0]).floatValue();
                }
                if ((found & 2) != 0) {
                    byte ctr = (Byte)args[1];
                    this.board.counterSetRateSingle(this.ctrRate, ctr);
                    break;
                }
                this.board.counterSetRate(this.ctrRate);
                break;
            }
            case 49: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.ctrSelect = (Byte)args[0];
                }
                int value = this.board.counterRead(this.ctrSelect);
                this.out.println((Object)("Counter = " + value));
                break;
            }
            case 57: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"b", (Object[])args);
                if (found < 0) break;
                boolean times = false;
                boolean counts = false;
                boolean comb = false;
                if ((found & 1) != 0) {
                    byte option = (Byte)args[0];
                    if ((option & 1) != 0) {
                        times = true;
                    }
                    if ((option & 2) != 0) {
                        counts = true;
                    }
                    if ((option & 4) != 0) {
                        comb = true;
                    }
                }
                long intvl = this.intStop;
                float rate = 0.0f;
                int count = this.intCount;
                if (intvl == 0L) {
                    intvl = System.nanoTime();
                }
                if ((intvl -= this.intStart) != 0L) {
                    rate = 1.0E9f * (float)count / (float)intvl;
                }
                this.out.println((Object)"Interrupt Parameters:");
                this.out.format("  Type         = %s (%s)\n", new Object[]{this.intType, this.itypTypes.decode(this.intType)});
                this.out.println((Object)("  Req. Rate    = " + this.intRate));
                this.out.println((Object)("  Clock        = " + this.intClock));
                this.out.println((Object)("  Source       = " + this.intSrce));
                this.out.println((Object)("  Count        = " + this.intCount));
                this.out.println((Object)("  Actual Rate  = " + rate));
                if (times) {
                    this.out.print((Object)"  Interval samples (nsec):");
                    long prev = this.intSavst;
                    int j = 0;
                    while (j < this.intSaved) {
                        if ((j & 3) == 0) {
                            this.out.println();
                        }
                        this.out.format("%14s", new Object[]{this.intTimes[j] - prev});
                        prev = this.intTimes[j];
                        ++j;
                    }
                    this.out.println();
                }
                if (counts) {
                    this.out.print((Object)"  Counter samples:");
                    int j = 0;
                    while (j < this.intSaved) {
                        if ((j & 7) == 0) {
                            this.out.println();
                        }
                        this.out.format("%7s", new Object[]{this.intCounts[j]});
                        ++j;
                    }
                    this.out.println();
                }
                if (comb) {
                    this.out.println((Object)"  Combined samples:");
                    int j = 0;
                    while (j < 2) {
                        this.out.format("%13s %5s %8s %8s", new Object[]{"Intvl(ns)", "Cntr", "Dvn(ns)", "Dly(ns)"});
                        ++j;
                    }
                    this.out.println();
                    j = 0;
                    while (j < 2) {
                        this.out.format("%13s %5s %8s %8s", new Object[]{"---------", "----", "-------", "-------"});
                        ++j;
                    }
                    long prev = this.intSavst;
                    int expTime = (int)(1.0E9 / (double)this.intRate);
                    int mult = this.intClock == 0 ? 10000 : 100;
                    int cntMax = expTime / mult;
                    if (cntMax >= 65536) {
                        expTime = (cntMax -= 65536) * mult;
                    }
                    int j2 = 0;
                    while (j2 < this.intSaved) {
                        if ((j2 & 1) == 0) {
                            this.out.println();
                        }
                        int period = (int)(this.intTimes[j2] - prev);
                        int delay = cntMax - this.intCounts[j2];
                        if (delay < 0) {
                            delay += 65536;
                        }
                        this.out.format("%13s %5s %8s %8s", new Object[]{period, this.intCounts[j2], period - expTime, mult * delay});
                        prev = this.intTimes[j2];
                        ++j2;
                    }
                    this.out.println();
                }
                if (!times && !counts && !comb) break;
                this.intSaved = 0;
                this.intSavst = this.intLast;
                break;
            }
            case 52: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"fbbb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.intRate = ((Float)args[0]).floatValue();
                }
                if ((found & 2) != 0) {
                    this.intClock = (Byte)args[1];
                }
                if ((found & 4) != 0) {
                    this.intSrce = (Byte)args[2];
                }
                if ((found & 8) != 0) {
                    this.intDsc = (Byte)args[3] != 0;
                }
                byte source = (byte)(this.intSrce >> 1);
                byte counter = (byte)(this.intSrce & 1);
                this.intStart = this.intLast = System.nanoTime();
                this.intSavst = this.intLast;
                this.intStop = 0L;
                this.intCount = 0;
                this.intSaved = 0;
                int type = this.board.userInt(source, counter, this.intClock, this.intRate, this, "intProc", this.intDsc);
                if (type == 0) break;
                this.intType = type;
                this.out.format("Interrupt type = %s (%s)\n", new Object[]{this.intType, this.itypTypes.decode(this.intType)});
                break;
            }
            case 53: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.board.cancelOpType(this.intType);
                this.intType = 0;
                this.intStop = System.nanoTime();
                break;
            }
            case 54: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"S", (Object[])args);
                if (found < 0) break;
                int type = this.itypTypes.encode((String)args[0], true);
                if (type == 255) {
                    this.board.cancelOp();
                    break;
                }
                if (type < 0) break;
                this.board.cancelOpType(type);
                break;
            }
            case 55: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.board.pauseOp();
                break;
            }
            case 56: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.board.resumeOp();
                break;
            }
            case 44: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)"Direct I/O  Parameters:");
                this.out.println((Object)("  Register     = " + this.dReg));
                this.out.format("  Address      = %08x\n", new Object[]{this.dAddress});
                this.out.format("  Byte value   = %02x\n", new Object[]{this.dByte});
                this.out.format("  Word value   = %04x\n", new Object[]{this.dWord});
                this.out.format("  Long value   = %08x\n", new Object[]{this.dLong});
                this.out.println((Object)("  Repeat count = " + this.dCount));
                this.out.println((Object)("  Word size    = " + this.dWidth));
                this.out.print((Object)"  Word array   =");
                int j = 0;
                while (j < this.dWords.length) {
                    this.out.format(" %04x", new Object[]{this.dWords[j]});
                    j = (short)(j + 1);
                }
                this.out.println();
                break;
            }
            case 36: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                byte value = Dscud.inp(this.dAddress);
                this.out.format("Value = 0x%02x\n", new Object[]{value});
                break;
            }
            case 37: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                short value = Dscud.inpw(this.dAddress);
                this.out.format("Value = 0x%04x\n", new Object[]{value});
                break;
            }
            case 38: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                int value = Dscud.inpl(this.dAddress);
                this.out.format("Value = 0x%08x\n", new Object[]{value});
                break;
            }
            case 39: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dCount = (Integer)args[1];
                }
                if (this.dCount > Short.MAX_VALUE) {
                    this.dCount = Short.MAX_VALUE;
                }
                short[] value = new short[this.dCount];
                Dscud.inpws(this.dAddress, value, (short)this.dCount);
                this.out.print((Object)"Values =");
                int j = 0;
                while (j < this.dCount) {
                    if (j > 0 && (j & 7) == 0) {
                        this.out.print((Object)"\n        ");
                    }
                    this.out.format(" %04x", new Object[]{value[j]});
                    ++j;
                }
                this.out.println();
                break;
            }
            case 40: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ib", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dByte = (Byte)args[1];
                }
                Dscud.outp(this.dAddress, this.dByte);
                break;
            }
            case 41: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iw", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dWord = (Short)args[1];
                }
                Dscud.outpw(this.dAddress, this.dWord);
                break;
            }
            case 42: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dLong = (Integer)args[1];
                }
                Dscud.outpl(this.dAddress, this.dLong);
                break;
            }
            case 43: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iiwwwwwwww", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dAddress = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dCount = (Integer)args[1];
                }
                if (this.dCount > this.dWords.length) {
                    this.dCount = this.dWords.length;
                }
                int j = 0;
                while (j < this.dCount) {
                    if ((found & 1 << j + 2) != 0) {
                        this.dWords[j] = (Short)args[j + 2];
                    }
                    ++j;
                }
                Dscud.outpws(this.dAddress, this.dWords, (short)this.dCount);
                break;
            }
            case 62: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"w", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dReg = (Short)args[0];
                }
                byte value = this.board.registerRead(this.dReg);
                this.out.format("Value = 0x%02x\n", new Object[]{value});
                break;
            }
            case 63: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"wb", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dReg = (Short)args[0];
                }
                if ((found & 2) != 0) {
                    this.dByte = (Byte)args[1];
                }
                this.board.registerWrite(this.dReg, this.dByte);
                break;
            }
            case 51: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iib", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dCount = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dAddress = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dWidth = (Byte)args[2];
                }
                long msec = System.currentTimeMillis();
                if (this.dWidth == 4) {
                    int j = 0;
                    while (j < this.dCount) {
                        Dscud.inpl(this.dAddress);
                        ++j;
                    }
                } else if (this.dWidth == 2) {
                    int j = 0;
                    while (j < this.dCount) {
                        Dscud.inpw(this.dAddress);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < this.dCount) {
                        Dscud.inp(this.dAddress);
                        ++j;
                    }
                }
                msec = System.currentTimeMillis() - msec;
                this.out.println((Object)("Performed " + this.dCount + " operations in " + msec + " msec"));
                break;
            }
            case 58: {
                int mask;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.dmpAddr = (Integer)args[0];
                }
                if ((found & 2) != 0) {
                    this.dmpCount = (Integer)args[1];
                }
                if ((found & 4) != 0) {
                    this.dmpWidth = (Integer)args[2];
                }
                int n = this.dmpWidth == 1 ? 15 : (mask = this.dmpWidth == 2 ? 7 : 3);
                String frmt = this.dmpWidth == 1 ? "2" : (this.dmpWidth == 2 ? "4" : "8");
                frmt = " %0" + frmt + "x";
                int j = 0;
                while (j < this.dmpCount) {
                    if ((j & mask) == 0) {
                        if (j != 0) {
                            this.out.println();
                        }
                        this.out.format("%08x:", new Object[]{this.dmpAddr});
                    }
                    this.out.format(frmt, new Object[]{Dscud.peek(this.dmpAddr, this.dmpWidth)});
                    this.dmpAddr += this.dmpWidth;
                    ++j;
                }
                if (this.dmpCount <= 0) break;
                this.out.println();
                break;
            }
            case 65: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)("Timer value = " + Dscud.getTime() + " ms"));
                break;
            }
            case 64: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"S", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)("Board type = " + Dscud.getBoardMacro((String)args[0])));
                break;
            }
            case 59: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                Thread[] threads = new Thread[Thread.activeCount()];
                int nThread = Thread.enumerate(threads);
                this.out.println((Object)"Thread information:");
                int j = 0;
                while (j < nThread) {
                    this.out.println((Object)("  " + threads[j]));
                    ++j;
                }
                break;
            }
            case 60: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"S", (Object[])args);
                if (found < 0) break;
                String name = (String)args[0];
                Thread[] threads = new Thread[Thread.activeCount()];
                int nThread = Thread.enumerate(threads);
                int j = 0;
                while (j < nThread) {
                    if (threads[j].getName().equals(name)) {
                        threads[j].stop();
                        break;
                    }
                    ++j;
                }
                if (j < nThread) break;
                this.out.println((Object)("Thread " + name + " not found"));
                break;
            }
            case 61: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Si", (Object[])args);
                if (found < 0) break;
                int oper = -1;
                String name = (String)args[0];
                if ((found & 2) != 0) {
                    oper = (Integer)args[1];
                }
                Thread[] threads = new Thread[Thread.activeCount()];
                int nThread = Thread.enumerate(threads);
                int j = 0;
                while (j < nThread) {
                    if (threads[j].getName().equals(name)) break;
                    ++j;
                }
                if (j >= nThread) {
                    this.out.println((Object)("Thread " + name + " not found"));
                    break;
                }
                if (oper < 0) {
                    this.out.format("Thread %s is%s a daemon\n", new Object[]{name, threads[j].isDaemon() ? "" : " not"});
                    break;
                }
                threads[j].setDaemon(oper > 0);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    public void cleanup() {
        try {
            this.board.freeBoard();
        }
        catch (DscudException dscudException) {}
    }

    private void intProc() {
        this.intLast = System.nanoTime();
        if (this.intSaved < 64) {
            this.intTimes[this.intSaved] = this.intLast;
            this.board.registerWrite((short)1, (byte)0);
            this.board.registerWrite((short)15, (byte)-64);
            this.intCounts[this.intSaved] = this.board.registerRead((short)12) & 0xFF | this.board.registerRead((short)13) << 8 & 0xFF00;
            ++this.intSaved;
        }
        ++this.intCount;
    }

    private void showRegs() {
        if (this.boardType == 35) {
            short r;
            byte[] regs = new byte[24];
            short r2 = 0;
            while (r2 < 12) {
                regs[r2] = this.board.registerRead(r2);
                r2 = (short)(r2 + 1);
            }
            byte p = 0;
            while (p < 3) {
                this.board.registerWrite((short)1, p);
                r = 12;
                while (r < 16) {
                    regs[4 * p + r] = this.board.registerRead(r);
                    r = (short)(r + 1);
                }
                p = (byte)(p + 1);
            }
            this.out.println((Object)"Main registers:");
            r2 = 0;
            while (r2 < 12) {
                if ((r2 == 5 || r2 == 6) && (regs[20] & 1) != 0) {
                    this.out.format("  %2s: %02x  %s\n", new Object[]{r2, regs[r2], heliosDesc[r2 + 19]});
                } else {
                    this.out.format("  %2s: %02x  %s\n", new Object[]{r2, regs[r2], heliosDesc[r2]});
                }
                r2 = (short)(r2 + 1);
            }
            p = 0;
            while (p < 3) {
                this.out.format("\nPage %s: %s\n", new Object[]{p, pageDesc[p]});
                r = 12;
                while (r < 16) {
                    int ri = 4 * p + r;
                    this.out.format("  %2s: %02x  %s\n", new Object[]{r, regs[ri], heliosDesc[ri]});
                    r = (short)(r + 1);
                }
                p = (byte)(p + 1);
            }
        } else {
            this.out.println((Object)("Unknown board type (" + this.boardType + ")"));
        }
    }
}

