/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dmmio;

import org.apache.log4j.Logger;
import org.lsst.ccs.drivers.commons.IOBoardDriver;
import org.lsst.ccs.drivers.dmmio.PCIIOHandler;

public class DMMIOBoardDriver
extends IOBoardDriver {
    static Logger log = Logger.getLogger(DMMIOBoardDriver.class);
    int baseAddress = -1;
    boolean inited = false;
    boolean differential = false;
    boolean biPolar = true;
    double gain = 1.0;
    double fullScaleOut = 5.0;
    byte digitalOut = 0;

    public DMMIOBoardDriver() {
    }

    public DMMIOBoardDriver(int baseAddress) {
        this.setBaseAddress(baseAddress);
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (this.baseAddress < 0) {
            this.baseAddress = 768;
        }
        try {
            byte status = PCIIOHandler.readByte(this.baseAddress + 8);
            this.differential = (status & 0x20) == 0;
            this.biPolar = (status & 0x40) == 0;
            this.setDigitalOutChannelsByte((byte)0);
        }
        catch (Throwable throwable) {
            log.error((Object)"***** Error loading driver, running dummy driver");
            this.baseAddress = -1;
        }
    }

    public void setBaseAddress(int baseAddress) {
        this.baseAddress = baseAddress;
        this.inited = false;
        this.init();
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public boolean isBiPolar() {
        return this.biPolar;
    }

    public boolean isDifferential() {
        return this.differential;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }

    public double getGain() {
        return this.gain;
    }

    public void setFullScaleOut(double fullScaleOut) {
        this.fullScaleOut = fullScaleOut;
    }

    public double getFullScaleOut() {
        return this.fullScaleOut;
    }

    public final void setAnalogChannelRange(byte low, byte high) {
        byte value = (byte)(high << 4 | low);
        if (this.baseAddress > 0) {
            PCIIOHandler.writeByte(this.baseAddress + 2, value);
        }
    }

    protected final void triggerADC() {
        if (this.baseAddress > 0) {
            PCIIOHandler.writeByte(this.baseAddress + 0, (byte)0);
        }
    }

    protected final void waitWhileBusy() {
        if (this.baseAddress > 0) {
            while ((PCIIOHandler.readByte(this.baseAddress + 8) & 0x80) != 0) {
            }
        }
    }

    protected final synchronized short readData() {
        if (this.baseAddress < 0) {
            return 0;
        }
        byte b1 = PCIIOHandler.readByte(this.baseAddress + 0);
        byte b2 = PCIIOHandler.readByte(this.baseAddress + 1);
        return (short)(b1 >>> 4 & 0xF | b2 << 4);
    }

    protected double convertToVolts(short value) {
        if (this.biPolar) {
            return 5.0 * ((double)value / 2048.0 - 1.0) / this.gain;
        }
        return 10.0 * (double)value / 4096.0 / this.gain;
    }

    protected short convertFromVolts(double value) {
        return (short)(value / this.fullScaleOut * 4096.0);
    }

    public int getAnalogInChannels() {
        return this.differential ? 8 : 16;
    }

    public int getAnalogOutChannels() {
        return 2;
    }

    public int getDigitalInChannels() {
        return 8;
    }

    public int getDigitalOutChannels() {
        return 8;
    }

    public synchronized double getAnalogInChannel(int n) {
        this.setAnalogChannelRange((byte)n, (byte)n);
        this.triggerADC();
        this.waitWhileBusy();
        return this.convertToVolts(this.readData());
    }

    public synchronized double getNextAnalogInChannel() {
        this.triggerADC();
        this.waitWhileBusy();
        return this.convertToVolts(this.readData());
    }

    public synchronized void setAnalogOutChannel(int n, double value) {
        if (this.baseAddress < 0) {
            return;
        }
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Analog out channel");
        }
        short adu = this.convertFromVolts(value);
        byte lsb = (byte)(adu & 0xFF);
        byte msb = (byte)(adu / 256);
        PCIIOHandler.writeByte(this.baseAddress + 4 + 2 * n, lsb);
        PCIIOHandler.writeByte(this.baseAddress + 5 + 2 * n, msb);
    }

    public byte getDigitalInChannelsByte() {
        if (this.baseAddress < 0) {
            return 0;
        }
        return PCIIOHandler.readByte(this.baseAddress + 3);
    }

    public void setDigitalOutChannelsByte(byte b) {
        if (this.baseAddress < 0) {
            return;
        }
        PCIIOHandler.writeByte(this.baseAddress + 3, b);
        this.digitalOut = b;
    }

    public int getDigitalInChannel(int n) {
        return this.getDigitalInChannelsByte() >> n & 1;
    }

    public void setDigitalOutChannel(int n, int value) {
        byte mask = (byte)(1 << n);
        this.digitalOut = (byte)(this.digitalOut & ~mask);
        if (value != 0) {
            this.digitalOut = (byte)(this.digitalOut | mask);
        }
        this.setDigitalOutChannelsByte(this.digitalOut);
    }

    public static void main(String[] args) {
        DMMIOBoardDriver b = new DMMIOBoardDriver();
        b.init();
        byte status = PCIIOHandler.readByte(b.baseAddress + 8);
        System.out.print("status " + status + " : ");
        System.out.print(" STS " + (status >> 7));
        System.out.print(" U/B " + ((status & 0x40) >> 6));
        System.out.print(" S/D " + ((status & 0x20) >> 5));
        System.out.print(" INT " + ((status & 0x10) >> 6));
        System.out.println(" ADC " + (status & 0xF));
        System.out.println("differential : " + b.isDifferential());
        System.out.println("bipolar : " + b.isBiPolar());
        byte value = Byte.parseByte(args[0]);
        b.setDigitalOutChannelsByte(value);
        b.setGain(2.0);
        value = b.getDigitalInChannelsByte();
        System.out.println("in byte " + value);
        int nch = b.getAnalogInChannels();
        b.setAnalogOutChannel(0, nch - 1);
        status = PCIIOHandler.readByte(b.baseAddress + 8);
        int nmes = 100;
        double sum = 0.0;
        int i = 0;
        while (i < nmes) {
            double mes = b.getAnalogInChannel(0);
            System.out.println("analog in " + i + " " + mes);
            sum += mes;
            ++i;
        }
        System.out.println("average " + sum / (double)nmes);
        status = PCIIOHandler.readByte(b.baseAddress + 8);
    }
}

