/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.demo;

import java.util.Random;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

public class DemoDriver {
    public static final int DEVID0 = 0;
    private static final int N_DIDS = 1;
    private static final int[] pids = new int[1];
    private int devId = -1;

    public int getDevId() {
        return this.devId;
    }

    @Command(name="open", description="Open a device for use")
    public void open(@Argument(name="devId", description="The device ID of the device to open") int did) throws DriverException {
        if (this.devId >= 0) {
            throw new DriverException("Device already open");
        }
        if (did < 0 || did >= pids.length) {
            throw new DriverException("Invalid device identifier");
        }
        this.devId = did;
    }

    @Command(name="close", description="Close the device")
    public void close() throws DriverException {
        if (this.devId < 0) {
            throw new DriverException("No device open");
        }
        this.devId = -1;
    }

    @Command(name="read", description="Read <count> bytes from device and print in hex format\n\tread <N> ")
    public String read(@Argument(name="count", description="The number of bytes to read") int count) throws Exception {
        byte[] data = new byte[count];
        int bytesRead = 0;
        bytesRead = this.read(count, data);
        if (bytesRead != count) {
            throw new DriverException("bad count returned by read()");
        }
        return DemoDriver.toHex(data);
    }

    private synchronized int read(int count, byte[] data) throws DriverException {
        if (this.devId < 0) {
            throw new DriverException("No device open");
        }
        if (data.length < count) {
            throw new DriverException("buffer size less than count given");
        }
        Random rnd = new Random(System.currentTimeMillis());
        byte[] tmpBuf = new byte[count];
        rnd.nextBytes(tmpBuf);
        System.arraycopy(tmpBuf, 0, data, 0, count);
        return count;
    }

    @Command(name="write", description="write the input string to the device\n\twrite <input-string>")
    public void write(@Argument(name="input-string", description="The input string") String input) throws DriverException {
        byte[] data = input.getBytes();
        this.write(data.length, data);
    }

    private synchronized int write(int count, byte[] data) throws DriverException {
        if (this.devId < 0) {
            throw new DriverException("No device open");
        }
        byte[] tmpBuf = new byte[count];
        if (data.length < count) {
            throw new DriverException("buffer size less than count given");
        }
        System.arraycopy(data, 0, tmpBuf, 0, count);
        return count;
    }

    private static String toHex(byte[] digest) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            int bi = b & 0xFF;
            sb.append(digits.charAt(bi >> 4));
            sb.append(digits.charAt(bi & 0xF));
        }
        return sb.toString();
    }

    @Command(name="print", description="print to screen at GUI or remote")
    public void print(@Argument(name="printedWord", description="User input text string") String userWord) {
        System.out.println(userWord);
    }

    static {
        DemoDriver.pids[0] = 0;
    }
}

