package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Routines for controlling a Dataforth MAQ20 analog input module.
 *
 *  @author  Owen Saxton
 */
public class Maq20AnalogIn extends Maq20Analog {

    /**
     *  Constructor.
     *
     *  @param  maq    The underlying Maq20 object
     *  @param  modId  The module registration ID
     *  @throws DriverException
     */
    Maq20AnalogIn(Maq20 maq, int modId) throws DriverException
    {
        super(maq, modId);
        if (module.opType != Maq20.OPER_ANALOG) {
            throw new DriverException("Invalid module type (" + module.type + ") for analog input operations");
        }
    }


    /**
     *  Enables or disables a channel.
     *
     *  @param  chan   The channel number
     *  @param  state  The enabled state to set: true or false
     *  @throws  DriverException
     */
    public void enable(int chan, boolean state) throws DriverException
    {
        checkChannel(chan);
        maq.writeRegister((short)(module.baseAddr + CHAN_ENABLE_ADDR + chan), state ? Maq20.ONE : Maq20.ZERO);
    }


    /**
     *  Gets the enabled state of a channel.
     *
     *  @param  chan   The channel number
     *  @return  Whether the channel is enabled
     *  @throws  DriverException
     */
    public boolean isEnabled(int chan) throws DriverException
    {
        checkChannel(chan);
        return maq.readRegister((short)(module.baseAddr + CHAN_ENABLE_ADDR + chan)) != 0;
    }

}
