/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;

public class Maq20DiscreteFunc
extends Maq20Discrete {
    public static final short TIMEBASE_SECS = 0;
    public static final short TIMEBASE_MSECS = 1;
    public static final short TIMEBASE_USECS = 2;
    static final int FUNC_NONE = 0;
    static final int FUNC_PULSE = 1;
    static final int FUNC_PULSE_DEB = 2;
    static final int FUNC_WAVEFORM = 3;
    static final int FUNC_EVENT_TIME = 4;
    static final int FUNC_FREQ_GEN = 5;
    static final int FUNC_PWM_GEN = 6;
    static final int FUNC_PULSE_GEN = 7;
    static final int NUM_FUNCTIONS = 8;
    static final int NUM_FUNC_CHANS = 2;
    static final int FUNC_BASE_ADDR = 1100;
    static final int FUNC_BASE_INCR = 100;
    static final int FUNCTION_ADDR = 0;
    static final int ARM_ADDR = 1;
    static final int FUNC_STAT_ADDR = 2;
    static final int ALARM_STAT_ADDR = 3;
    static final int SAVE_CONFIG_ADDR = 90;

    Maq20DiscreteFunc(Maq20 maq, int modId) throws DriverException {
        super(maq, modId);
    }

    void checkFunction(int chan, int func) throws DriverException {
        this.getBaseAddr(chan, func);
    }

    void setFunction(int chan, int func) throws DriverException {
        if (func < 0 || func >= 8) {
            throw new DriverException("Invalid function code (" + func + ")");
        }
        this.maq.writeRegister(this.getRegAddr(chan, 0), (short)func);
    }

    int getFunction(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 0));
    }

    public void armFunction(int chan) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 1), (short)1);
    }

    public void disarmFunction(int chan) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 1), (short)0);
    }

    public boolean isFunctionArmed(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 1)) != 0;
    }

    public void saveConfig(int chan) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 90), (short)0);
    }

    int getBaseAddr(int chan) throws DriverException {
        if (chan < 0 || chan >= 2) {
            throw new DriverException("Invalid function channel (" + chan + ")");
        }
        return this.module.baseAddr + 1100 + chan * 100;
    }

    int getBaseAddr(int chan, int func) throws DriverException {
        int baseAddr = this.getBaseAddr(chan);
        int actFunc = this.maq.readRegister((short)(baseAddr + 0));
        if (func != actFunc) {
            throw new DriverException("Active function (" + actFunc + ") doesn't match request");
        }
        return baseAddr;
    }

    short getRegAddr(int chan, int offset) throws DriverException {
        return (short)(this.getBaseAddr(chan) + offset);
    }

    short getRegAddr(int chan, int func, int offset) throws DriverException {
        return (short)(this.getBaseAddr(chan, func) + offset);
    }
}

