/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;

public class Maq20Discrete {
    final Maq20 maq;
    final Maq20.ModuleData module;
    static final short DISCR_CONFIG_ADDR = 100;
    static final short DFLT_DATA_ADDR = 110;
    static final short SAVE_PARAMS_ADDR = 190;
    static final short CHAN_DATA_ADDR = 1000;

    public Maq20Discrete(Maq20 maq, int modId) throws DriverException {
        this.maq = maq;
        this.module = maq.getModuleData(modId, false);
        if (this.module.opType != 2 && this.module.opType != 3 && this.module.opType != 4) {
            throw new DriverException("Invalid module type (" + (Object)((Object)this.module.type) + ") for discrete operations");
        }
    }

    public int[] readDiscIn(int chan, int count) throws DriverException {
        this.checkInputChannels(chan, count);
        return this.readDiscData(1000 + this.module.numOutChan, chan, count, true);
    }

    public int readDiscIn(int chan) throws DriverException {
        return this.readDiscIn(chan, 1)[0];
    }

    public int[] readDiscIn() throws DriverException {
        return this.readDiscIn(0, this.module.numInChan);
    }

    public int[] readDiscOut(int chan, int count) throws DriverException {
        this.checkOutputChannels(chan, count);
        return this.readDiscData(1000, chan, count, true);
    }

    public int readDiscOut(int chan) throws DriverException {
        return this.readDiscOut(chan, 1)[0];
    }

    public int[] readDiscOut() throws DriverException {
        return this.readDiscOut(0, this.module.numOutChan);
    }

    public void writeDisc(int chan, int count, int[] data) throws DriverException {
        this.checkOutputChannels(chan, count);
        this.writeDiscData(1000, chan, count, data, true);
    }

    public void writeDisc(int chan, int data) throws DriverException {
        this.writeDisc(chan, 1, new int[]{data});
    }

    public void writeDisc(int[] data) throws DriverException {
        this.writeDisc(0, this.module.numOutChan, data);
    }

    public void setDiscDefault(int chan, int count, int[] data) throws DriverException {
        this.checkOutputChannels(chan, count);
        this.writeDiscData(110, chan, count, data, true);
        this.saveDiscDefaults();
    }

    public void setDiscDefault(int chan, int data) throws DriverException {
        this.setDiscDefault(chan, 1, new int[]{data});
    }

    public void setDiscDefault(int[] data) throws DriverException {
        this.setDiscDefault(0, this.module.numOutChan, data);
    }

    public int[] getDiscDefault(int chan, int count) throws DriverException {
        this.checkOutputChannels(chan, count);
        return this.readDiscData(110, chan, count, true);
    }

    public int getDiscDefault(int chan) throws DriverException {
        return this.getDiscDefault(chan, 1)[0];
    }

    public int[] getDiscDefault() throws DriverException {
        return this.getDiscDefault(0, this.module.numOutChan);
    }

    public void saveDiscDefaults() throws DriverException {
        short addr = (short)(this.module.baseAddr + 190);
        this.maq.writeRegister(addr, (short)0);
    }

    int[] readDiscData(int base, int chan, int count, boolean invert) throws DriverException {
        if (count == 0) {
            return new int[0];
        }
        short addr = (short)(this.module.baseAddr + base + chan);
        short[] raw = this.maq.readRegisters(addr, (short)count);
        int[] data = new int[count];
        short invMask = invert ? (short)1 : 0;
        for (int j = 0; j < data.length; ++j) {
            data[j] = raw[j] ^ invMask;
        }
        return data;
    }

    void writeDiscData(int base, int chan, int count, int[] data, boolean invert) throws DriverException {
        if (count == 0) {
            return;
        }
        short[] raw = new short[count];
        boolean invMask = invert;
        for (int j = 0; j < data.length; ++j) {
            raw[j] = (short)((data[j] != 0 ? 1 : 0) ^ (invMask ? 1 : 0));
        }
        this.maq.writeRegisters((short)(this.module.baseAddr + base + chan), raw);
    }

    void checkInputChannels(int chan, int count) throws DriverException {
        if (chan < 0 || chan >= this.module.numInChan) {
            throw new DriverException("Invalid input channel number");
        }
        if (count < 0 || chan + count > this.module.numInChan) {
            throw new DriverException("Invalid input channel count");
        }
    }

    void checkOutputChannels(int chan, int count) throws DriverException {
        if (chan < 0 || chan >= this.module.numOutChan) {
            throw new DriverException("Invalid output channel number");
        }
        if (count < 0 || chan + count > this.module.numOutChan) {
            throw new DriverException("Invalid output channel count");
        }
    }
}

