/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20Analog;

public class Maq20AnalogOut
extends Maq20Analog {
    private static final short DFLT_DATA_ADDR = 110;
    private static final short SAVE_PARAMS_ADDR = 119;

    public Maq20AnalogOut(Maq20 maq, int modId) throws DriverException {
        super(maq, modId);
        if (this.module.opType != 1) {
            throw new DriverException("Invalid module type (" + (Object)((Object)this.module.type) + ") for analog output operations");
        }
    }

    public void writeValue(int chan, int count, double[] data) throws DriverException {
        this.writeAnalogData(1000, chan, count, data);
    }

    public void writeValue(int chan, double data) throws DriverException {
        this.writeValue(chan, 1, new double[]{data});
    }

    public void writeValue(double[] data) throws DriverException {
        this.writeValue(0, this.module.numOutChan, data);
    }

    public void setDefaultValue(int chan, int count, double[] data) throws DriverException {
        this.writeAnalogData(110, chan, count, data);
        this.saveDefaultValues();
    }

    public void setDefaultValue(int chan, double data) throws DriverException {
        this.setDefaultValue(chan, 1, new double[]{data});
    }

    public void setDefaultValue(double[] data) throws DriverException {
        this.setDefaultValue(0, this.module.numOutChan, data);
    }

    public double[] getDefaultValue(int chan, int count) throws DriverException {
        return this.readAnalogData(110, chan, count);
    }

    public double getDefaultValue(int chan) throws DriverException {
        return this.getDefaultValue(chan, 1)[0];
    }

    public double[] getDefaultValue() throws DriverException {
        return this.getDefaultValue(0, -1);
    }

    public void saveDefaultValues() throws DriverException {
        this.maq.writeRegister((short)(this.module.baseAddr + 119), (short)1);
    }

    public void saveRanges() throws DriverException {
        this.maq.writeRegister((short)(this.module.baseAddr + 119), (short)0);
    }

    void writeAnalogData(int base, int chan, int count, double[] data) throws DriverException {
        this.checkChannel(chan, count);
        if (count == 0) {
            return;
        }
        short[] raw = new short[count];
        for (int j = 0; j < count; ++j) {
            int range = this.module.range[chan + j];
            raw[j] = (short)((data[j] + this.module.offset[range]) / this.module.scale[range]);
        }
        this.maq.writeRegisters((short)(this.module.baseAddr + base + chan), raw);
    }
}

