/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.TestModbus;

public class TestMaq20
extends TestModbus {
    private final Maq20 maq;

    public TestMaq20() {
        super((Modbus)new Maq20());
        this.maq = (Maq20)this.mod;
    }

    @Command(name="register", description="Register modules")
    public void register(String ... serial) throws DriverException {
        this.maq.register(serial);
    }

    @Command(name="showipaddress", description="Show the IP address")
    public void showIPAddress() throws DriverException {
        this.out.println("IP address = " + this.maq.getIPAddress());
    }

    @Command(name="setipaddress", description="Set the IP address")
    public void setIPAddress(@Argument(name="ipaddr", description="IP address") String ipAddr) throws DriverException {
        this.maq.setIPAddress(ipAddr);
    }

    @Command(name="showsubnet", description="Show the subnet mask")
    public void showSubnetMask() throws DriverException {
        this.out.println("Subnet mask = " + this.maq.getSubnetMask());
    }

    @Command(name="setsubnet", description="Set the subnet mask")
    public void setSubnetMask(@Argument(name="mask", description="subnet mask") String mask) throws DriverException {
        this.maq.setSubnetMask(mask);
    }

    @Command(name="showtemperature", description="Show the temperature")
    public void showTemperature() throws DriverException {
        this.out.println("Temperature = " + this.maq.readTemperature());
    }

    @Command(name="showid", description="Show module's ID")
    public void showId(@Argument(name="serial", description="Serial number") String serial) throws DriverException {
        this.out.println("Module ID = " + this.maq.getModuleId(serial));
    }

    @Command(name="showname", description="Show module's name")
    public void showName(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.out.println("Device name = " + this.maq.getModuleName(modId));
    }

    @Command(name="showserial", description="Show module's serial number")
    public void showSerial(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.out.println("Serial number = " + this.maq.getSerialNumber(modId));
    }

    @Command(name="showrevision", description="Show module's FW revision")
    public void showFwRevision(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.out.println("Firmware revision = " + this.maq.getFwRevision(modId));
    }

    @Command(name="showdate", description="Show module's date code")
    public void showDate(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.out.println("Date code = " + this.maq.getDateCode(modId));
    }

    @Command(name="showrange", description="Show channel's range")
    public void showRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        this.out.println("Range = " + this.maq.getRange(modId, chan));
    }

    @Command(name="setrange", description="Set channel's range")
    public void setRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="range", description="Range number") int range) throws DriverException {
        this.maq.setRange(modId, chan, range);
    }

    @Command(name="showenabled", description="Show channel's enabled state")
    public void showEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        this.out.println("Enabled state = " + (this.maq.isEnabled(modId, chan) ? "on" : "off"));
    }

    @Command(name="setenabled", description="Set channel's enabled state")
    public void setEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="state", description="Enabled state") TestModbus.OnOff state) throws DriverException {
        this.maq.enable(modId, chan, state == TestModbus.OnOff.ON);
    }

    @Command(name="readvalue", description="Show channels' data values")
    public void readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        this.showValues(this.maq.readValue(modId, chan, count));
    }

    @Command(name="readvalue", description="Show channel's data value")
    public void readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        this.showValues(new double[]{this.maq.readValue(modId, chan)});
    }

    @Command(name="readvalue", description="Show all channels' data values")
    public void readValue(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.showValues(this.maq.readValue(modId));
    }

    private void showValues(double[] values) {
        this.out.print(values.length > 1 ? "Values =" : "Value =");
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            this.out.format(" %.6g", value);
            ++n2;
        }
        this.out.println();
    }
}

