/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class Maq20
extends Modbus {
    public static final int NUM_MODULES = 24;
    public static final int MOD_TYPE_UNKNOWN = -1;
    public static final int MOD_TYPE_JTC = 0;
    public static final int MOD_TYPE_KTC = 1;
    public static final int MOD_TYPE_TTC = 2;
    public static final int MOD_TYPE_RSTC = 3;
    public static final int MOD_TYPE_RTD = 4;
    public static final int MOD_TYPE_MVD = 5;
    public static final int MOD_TYPE_VD = 6;
    public static final int MOD_TYPE_VS = 7;
    public static final int MOD_TYPE_ID = 8;
    public static final int MOD_TYPE_IS = 9;
    public static final int RANGE_TC_T_400 = 0;
    public static final int RANGE_TC_T_220 = 1;
    public static final int RANGE_TC_J_760 = 0;
    public static final int RANGE_TC_J_393 = 1;
    public static final int RANGE_TC_J_199 = 2;
    public static final int RANGE_TC_K_1350 = 0;
    public static final int RANGE_TC_K_651 = 1;
    public static final int RANGE_TC_K_332 = 2;
    public static final int RANGE_TC_R_1750 = 0;
    public static final int RANGE_TC_R_990 = 1;
    public static final int RANGE_TC_S_1750 = 2;
    public static final int RANGE_TC_S_970 = 3;
    public static final int RANGE_RTD_850 = 0;
    public static final int RANGE_RTD_200 = 1;
    public static final int RANGE_RTD_100 = 2;
    public static final int RANGE_VOLT_60 = 0;
    public static final int RANGE_VOLT_40 = 1;
    public static final int RANGE_VOLT_20 = 2;
    public static final int RANGE_VOLT_10 = 3;
    public static final int RANGE_VOLT_5 = 4;
    public static final int RANGE_MVOLT_2000 = 0;
    public static final int RANGE_MVOLT_1000 = 1;
    public static final int RANGE_MVOLT_250 = 2;
    public static final int RANGE_MVOLT_100 = 3;
    public static final int RANGE_MVOLT_50 = 4;
    public static final int RANGE_MAMP_0_20 = 0;
    public static final int RANGE_MAMP_4_20 = 1;
    private static final short ZERO = 0;
    private static final short ONE = 1;
    private static final short SLAVE_ADDR = 0;
    private static final short MODU_ADDR_INCR = 2000;
    private static final short DEV_NAME_ADDR = 0;
    private static final short DEV_NAME_LENG = 10;
    private static final short SER_NUM_ADDR = 20;
    private static final short SER_NUM_LENG = 10;
    private static final short DATE_CODE_ADDR = 31;
    private static final short DATE_CODE_LENG = 4;
    private static final short FW_REVN_ADDR = 36;
    private static final short FW_REVN_LENG = 4;
    private static final short IP_ADDRESS_ADDR = 50;
    private static final short IP_ADDRESS_LENG = 4;
    private static final short SUBNET_MASK_ADDR = 55;
    private static final short MODU_DETECT_ADDR = 98;
    private static final short RESET_ADDR = 99;
    private static final short MODU_STATUS_ADDR = 100;
    private static final short REGN_SN_ID_ADDR = 1000;
    private static final short AUTO_REGN_ADDR = 1020;
    private static final short SAVE_REGN_ADDR = 1021;
    private static final short DEL_REGN_ADDR = 1022;
    private static final short TEMPERATURE_ADDR = 1210;
    private static final short NUM_INP_CHANS_ADDR = 40;
    private static final short NUM_OUT_CHANS_ADDR = 41;
    private static final short INPUT_RANGE_ADDR = 100;
    private static final short CHAN_WEIGHT_ADDR = 120;
    private static final short CHAN_ENABLE_ADDR = 140;
    private static final short CHAN_DATA_ADDR = 1000;
    private static final short RANGE_COUNT_ADDR = 1700;
    private static final short RANGE_DATA_ADDR = 1710;
    private static final short RANGE_DATA_INCR = 20;
    private static final short ENG_NFS_OFFS = 0;
    private static final short ENG_PFS_OFFS = 2;
    private static final short ENG_FS_PWR_OFFS = 4;
    private static final short CNT_NFS_OFFS = 8;
    private static final short CNT_PFS_OFFS = 10;
    private static final short NUM_CHANNELS = 16;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final ModuleData[] modules = new ModuleData[24];

    static {
        typeMap.put("JTC", 0);
        typeMap.put("KTC", 1);
        typeMap.put("TTC", 2);
        typeMap.put("RSTC", 3);
        typeMap.put("RTD31", 4);
        typeMap.put("MVDN", 5);
        typeMap.put("VDN", 6);
        typeMap.put("VDS", 7);
        typeMap.put("IDN", 8);
        typeMap.put("ISN", 9);
    }

    public void open(int type, String ident, int parm) throws DriverException {
        super.open(type, ident, parm);
        this.setAddressMode(true);
        try {
            this.fillModuleData();
        }
        catch (DriverException e) {
            try {
                this.close();
            }
            catch (DriverException driverException) {}
            throw e;
        }
    }

    public boolean moduleExists(int modId) {
        return modId > 0 && modId < 24 && this.modules[modId] != null;
    }

    public String getModuleName(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        short addr = (short)(2000 * modId + 0);
        short[] text = this.readRegisters((short)0, addr, (short)10);
        return Maq20.makeString(text);
    }

    public int getModuleType(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        return this.modules[modId].type;
    }

    public String getSerialNumber(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        return this.getSerialNum(modId);
    }

    public String getDateCode(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        short addr = (short)(2000 * modId + 31);
        short[] text = this.readRegisters((short)0, addr, (short)4);
        return Maq20.makeString(text);
    }

    public String getFwRevision(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        short addr = (short)(2000 * modId + 36);
        short[] text = this.readRegisters((short)0, addr, (short)4);
        return Maq20.makeString(text);
    }

    public String getIPAddress() throws DriverException {
        short[] addr = this.readRegisters((short)0, (short)50, (short)4);
        return Maq20.makeIPString(addr);
    }

    public void setIPAddress(String ipAddr) throws DriverException {
        this.writeRegisters((short)0, (short)50, Maq20.makeIPAddress(ipAddr));
    }

    public String getSubnetMask() throws DriverException {
        short[] addr = this.readRegisters((short)0, (short)55, (short)4);
        return Maq20.makeIPString(addr);
    }

    public void setSubnetMask(String mask) throws DriverException {
        this.writeRegisters((short)0, (short)55, Maq20.makeIPAddress(mask));
    }

    public double readTemperature() throws DriverException {
        return this.readRegisters((short)0, (short)1210, (short)1)[0];
    }

    public void register(String ... serial) throws DriverException {
        ArrayList<Short> ids = new ArrayList<Short>();
        short j = 1;
        while (j < 24) {
            if (this.modules[j] != null) {
                ids.add(j);
            }
            j = (short)(j + 1);
        }
        if (serial.length != ids.size()) {
            throw new DriverException("Incorrect number of modules");
        }
        String[] stringArray = serial;
        int n = serial.length;
        int n2 = 0;
        while (n2 < n) {
            String sn = stringArray[n2];
            if (sn.length() > 10) {
                throw new DriverException("Serial number (" + sn + ") too long");
            }
            if (this.getModuleId(sn) < 0) {
                throw new DriverException("Serial number (" + sn + ") not found");
            }
            ++n2;
        }
        this.writeRegister((short)0, (short)1020, (short)0);
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            short id = (Short)iterator.next();
            this.writeRegister((short)0, (short)1022, id);
        }
        short[] snId = new short[11];
        String[] stringArray2 = serial;
        int n3 = serial.length;
        n = 0;
        while (n < n3) {
            block14: {
                String sn = stringArray2[n];
                int j2 = 0;
                while (j2 < 10) {
                    snId[j2] = j2 < sn.length() ? (int)sn.charAt(j2) : 32;
                    ++j2;
                }
                snId[10] = (short)(snId[10] + 1);
                int oldTimeout = this.timeout;
                this.timeout = 100;
                try {
                    try {
                        this.writeRegisters((short)0, (short)1000, snId);
                    }
                    catch (DriverTimeoutException driverTimeoutException) {
                        this.timeout = oldTimeout;
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    this.timeout = oldTimeout;
                    throw throwable;
                }
                this.timeout = oldTimeout;
            }
            ++n;
        }
        this.writeRegister((short)0, (short)1021, (short)1);
        this.writeRegister((short)0, (short)1020, (short)1);
        this.fillModuleData();
    }

    public int getModuleId(String serial) throws DriverException {
        short[] status = this.readRegisters((short)0, (short)100, (short)24);
        int id = 1;
        while (id < 24) {
            if (status[id] != 0 && serial.equals(this.getSerialNum(id))) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    public int getNumInputs(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        return this.modules[modId].numChan;
    }

    public int getNumRanges(int modId) throws DriverException {
        this.checkModuleId(modId, true);
        return this.modules[modId].offset.length;
    }

    public int getRange(int modId, int chan) throws DriverException {
        this.checkModuleId(modId, false);
        this.checkChannel(modId, chan);
        this.checkOpen();
        return this.modules[modId].range[chan];
    }

    public void setRange(int modId, int chan, int range) throws DriverException {
        this.checkModuleId(modId, false);
        this.checkChannel(modId, chan);
        ModuleData module = this.modules[modId];
        if (range < 0 || range >= module.offset.length) {
            throw new DriverException("Invalid range value");
        }
        short addr = (short)(2000 * modId + 100 + chan);
        this.writeRegister((short)0, addr, (short)range);
        module.range[chan] = range;
    }

    public boolean isEnabled(int modId, int chan) throws DriverException {
        this.checkModuleId(modId, false);
        this.checkChannel(modId, chan);
        short addr = (short)(2000 * modId + 140 + chan);
        return this.readRegisters((short)0, addr, (short)1)[0] != 0;
    }

    public void enable(int modId, int chan, boolean state) throws DriverException {
        this.checkModuleId(modId, false);
        this.checkChannel(modId, chan);
        short addr = (short)(2000 * modId + 140 + chan);
        this.writeRegister((short)0, addr, state ? (short)1 : 0);
    }

    public double[] readValue(int modId, int chan, int count) throws DriverException {
        this.checkModuleId(modId, false);
        this.checkChannel(modId, chan);
        ModuleData module = this.modules[modId];
        if (count <= 0 || chan + count > module.numChan) {
            throw new DriverException("Invalid channel count");
        }
        short addr = (short)(2000 * modId + 1000 + chan);
        short[] raw = this.readRegisters((short)0, addr, (short)count);
        double[] data = new double[count];
        int j = 0;
        while (j < count) {
            int range = module.range[chan];
            data[j] = module.scale[range] * (double)raw[j] + module.offset[range];
            ++j;
            ++chan;
        }
        return data;
    }

    public double readValue(int modId, int chan) throws DriverException {
        return this.readValue(modId, chan, 1)[0];
    }

    public double[] readValue(int modId) throws DriverException {
        this.checkModuleId(modId, false);
        return this.readValue(modId, 0, this.modules[modId].numChan);
    }

    private String getSerialNum(int modId) throws DriverException {
        short addr = (short)(2000 * modId + 20);
        short[] text = this.readRegisters((short)0, addr, (short)10);
        return Maq20.makeString(text);
    }

    private void fillModuleData() throws DriverException {
        short[] status = this.readRegisters((short)0, (short)100, (short)24);
        int id = 1;
        while (id < 24) {
            if (status[id] != 0) {
                Integer type;
                if (this.modules[id] == null) {
                    this.modules[id] = new ModuleData();
                }
                ModuleData module = this.modules[id];
                module.type = -1;
                String name = this.getModuleName(id);
                if (name.substring(0, 6).equals("MAQ20-") && (type = typeMap.get(name.substring(6))) != null) {
                    module.type = type;
                }
                short addr = (short)(2000 * id + 40);
                module.numChan = this.readRegisters((short)0, addr, (short)1)[0];
                int chan = 0;
                while (chan < module.numChan) {
                    module.range[chan] = this.readRange(id, chan);
                    ++chan;
                }
                this.setConversion(id);
            } else {
                this.modules[id] = null;
            }
            ++id;
        }
    }

    private void setConversion(int modId) throws DriverException {
        ModuleData module = this.modules[modId];
        short addr = (short)(2000 * modId + 1700);
        int nRange = this.readRegisters((short)0, addr, (short)1)[0];
        module.offset = new double[nRange];
        module.scale = new double[nRange];
        int j = 0;
        while (j < nRange) {
            addr = (short)(2000 * modId + 1710 + j * 20);
            short[] rData = this.readRegisters((short)0, addr, (short)20);
            double cntRange = rData[10] - rData[8];
            double mult = Math.pow(10.0, rData[4]);
            module.scale[j] = (double)(rData[2] - rData[0]) * mult / cntRange;
            module.offset[j] = (double)(rData[2] * rData[8] - rData[0] * rData[10]) * mult / cntRange;
            ++j;
        }
    }

    private int readRange(int modId, int chan) throws DriverException {
        short addr = (short)(2000 * modId + 100 + chan);
        return this.readRegisters((short)0, addr, (short)1)[0];
    }

    private void checkModuleId(int modId, boolean zeroOk) throws DriverException {
        if (zeroOk && modId == 0) {
            return;
        }
        if (!this.moduleExists(modId)) {
            throw new DriverException("Invalid module ID");
        }
    }

    private void checkChannel(int modId, int chan) throws DriverException {
        if (chan < 0 || chan >= this.modules[modId].numChan) {
            throw new DriverException("Invalid channel number");
        }
    }

    private static String makeString(short[] array) {
        int leng = array.length;
        while (leng > 0) {
            char elem = (char)array[leng - 1];
            if (elem != '\u0000' && elem != ' ') break;
            --leng;
        }
        char[] conv = new char[leng];
        int j = 0;
        while (j < leng) {
            conv[j] = (char)array[j];
            ++j;
        }
        return new String(conv);
    }

    private static String makeIPString(short[] array) {
        return String.format("%s.%s.%s.%s", array[0], array[1], array[2], array[3]);
    }

    private static short[] makeIPAddress(String ipAddr) throws DriverException {
        String[] elems = ipAddr.split("\\.");
        if (elems.length == 4) {
            short[] array = new short[4];
            try {
                int j = 0;
                while (j < 4) {
                    array[j] = Short.valueOf(elems[j]);
                    ++j;
                }
                return array;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new DriverException("Invalid IP address string");
    }

    static class ModuleData {
        int type;
        int numChan;
        int[] range = new int[16];
        double[] offset;
        double[] scale;

        ModuleData() {
        }
    }
}

