/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.lsst.ccs.daq.ims.Camera;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.StoreSimulation;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class SimulationTest {
    @BeforeClass
    public static void setupClass() {
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
    }

    @Test
    public void simulationTest() throws DAQException {
        Store store = new Store("test");
        Assert.assertEquals((Object)"test", (Object)store.getPartition());
        Assert.assertEquals((long)500000000000L, (long)store.getCapacity());
        Assert.assertEquals((long)250000000000L, (long)store.getRemaining());
        System.out.println(Store.getClientVersion());
    }

    @Test
    public void triggerTest() throws DAQException {
        AtomicInteger lastOpcode = new AtomicInteger();
        ArrayList lastMeta = new ArrayList();
        LinkedHashMap lastRegisterLists = new LinkedHashMap();
        StoreSimulation sim = StoreSimulation.instance();
        sim.addTriggerListener((opcode, meta, registerLists) -> {
            lastOpcode.set(opcode);
            lastMeta.add(meta);
            if (registerLists != null) {
                lastRegisterLists.putAll(registerLists);
            }
        });
        Store store = new Store("test");
        Camera camera = store.getCamera();
        camera.setRegisterList(Location.LocationType.SCIENCE, new int[]{1, 2, 3});
        camera.setRegisterList(Location.LocationType.GUIDER, new int[]{4, 5, 6});
        camera.setRegisterList(Location.LocationType.WAVEFRONT, new int[]{7, 8, 9});
        ImageMetaData meta2 = new ImageMetaData("name", "folder", "annotation", 7, (Set)LocationSet.all());
        Image triggerImage = camera.triggerImage(meta2);
        Assert.assertEquals((long)7L, (long)lastOpcode.get());
        Assert.assertEquals((Object)"name", (Object)((ImageMetaData)lastMeta.get(0)).getName());
        Assert.assertEquals((Object)"name", (Object)triggerImage.getMetaData().getName());
        Assertions.assertArrayEquals((int[])((int[])lastRegisterLists.get(Location.LocationType.SCIENCE)), (int[])new int[]{1, 2, 3});
        lastMeta.clear();
        lastRegisterLists.clear();
        Instant startSequencer = camera.startSequencer(4);
        Assert.assertEquals((long)4L, (long)lastOpcode.get());
        Assert.assertNull(lastMeta.get(0));
        Assert.assertNull(lastRegisterLists.get(Location.LocationType.SCIENCE));
    }

    @Test
    public void imageListenerTest() throws DAQException, InterruptedException, TimeoutException {
        final Phaser phaser = new Phaser(2);
        Store store = new Store("test");
        store.addImageListener(new ImageListener(){

            public void imageCreated(Image image) {
                phaser.arrive();
            }

            public void imageComplete(Image image) {
                phaser.arrive();
            }
        });
        Thread.sleep(100L);
        Camera camera = store.getCamera();
        ImageMetaData meta = new ImageMetaData("name", "folder", "annotation", 7, (Set)LocationSet.all());
        Image triggerImage = camera.triggerImage(meta);
        phaser.awaitAdvanceInterruptibly(0, 10L, TimeUnit.SECONDS);
    }
}

