/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.daq.guider.GuiderListener;
import org.lsst.ccs.daq.guider.ROICommonExtended;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.guider.SeriesMetaData;
import org.lsst.ccs.daq.guider.StateMetaData;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.HeaderWriter;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FitsWriterFactory
implements GuiderListener {
    private static final Logger LOG = Logger.getLogger(FitsWriterFactory.class.getName());
    private final String partition;
    private final FitsIntWriter.FileNamer fileNamer;
    private final Map<String, HeaderSpecification> headerSpecifications;
    private FitsWriter currentFitsFileWriter;
    private final boolean includeRawStamp;
    private SeriesMetaData series;

    public FitsWriterFactory(String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications) {
        this(partition, fileNamer, headerSpecifications, false);
    }

    public FitsWriterFactory(String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications, boolean includeRawStamp) {
        this.partition = partition;
        this.fileNamer = fileNamer;
        this.headerSpecifications = headerSpecifications;
        this.includeRawStamp = includeRawStamp;
    }

    protected FitsWriter createFitsFileWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications) throws IOException, FitsException {
        return new FitsWriter(state, series, partition, fileNamer, headerSpecifications, Collections.emptyList());
    }

    @Override
    public void start(StateMetaData state, SeriesMetaData series) {
        this.series = series;
    }

    @Override
    public void stop(StateMetaData state) {
    }

    @Override
    public void pause(StateMetaData state) throws IOException, FitsException {
        if (this.currentFitsFileWriter != null) {
            this.currentFitsFileWriter.closeAsync().exceptionally(t -> {
                LOG.log(Level.SEVERE, "Async close failed", (Throwable)t);
                return null;
            });
            this.currentFitsFileWriter = null;
        }
    }

    @Override
    public void resume(StateMetaData state) throws IOException, FitsException {
        this.currentFitsFileWriter = this.createFitsFileWriter(state, this.series, this.partition, this.fileNamer, this.headerSpecifications);
    }

    @Override
    public void stamp(StateMetaData state, ByteBuffer stamp) throws FitsException, IOException {
        if (this.currentFitsFileWriter != null) {
            this.currentFitsFileWriter.stamp(state, stamp);
        }
    }

    @Override
    public void rawStamp(StateMetaData state, ByteBuffer rawStamp) throws FitsException, IOException {
        if (this.currentFitsFileWriter != null && this.includeRawStamp) {
            this.currentFitsFileWriter.rawStamp(state, rawStamp);
        }
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setLongStringsEnabled((boolean)true);
    }

    public static class FitsWriter
    implements AutoCloseable {
        private final BufferedFile bufferedFile;
        private final Map<String, Object> properties;
        private final Map<String, HeaderSpecification> headerSpecifications;
        private final String obsid;
        private final Object finalFileName;
        private final File temporaryFileName;
        private int stampCount = 0;
        private int rawStampCount = 0;
        private final BasicHDU<?> primary;
        private int lastDAQStamp;

        public FitsWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications, List<FitsHeaderMetadataProvider> metaDataProviders) throws IOException, FitsException {
            String seriesId = series.getId();
            String comment = state.getComment();
            String string = this.obsid = comment == null ? seriesId : comment;
            if (this.obsid == null) {
                throw new IOException("Missing OBSID");
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                ImageName imageName = new ImageName(this.obsid);
                props.put("ImageName", imageName.toString());
                props.put("ImageDate", imageName.getDateString());
                props.put("ImageNumber", imageName.getNumberString());
                props.put("ImageController", imageName.getController().getCode());
                props.put("ImageSource", imageName.getSource().getCode());
            }
            catch (IllegalArgumentException x) {
                throw new IOException("Bad OBSID, rejected: " + this.obsid, x);
            }
            ROILocation roiLocation = series.getLocation();
            SensorLocation sensorLocation = roiLocation.getLocation();
            Location rebLocation = sensorLocation.getRebLocation();
            ROICommonExtended common = series.getCommon();
            props.put("FileCreationTime", CCSTimeStamp.currentTime());
            props.put("RaftBay", rebLocation.getRaftName());
            props.put("RebSlot", rebLocation.getBoardName());
            props.put("DAQPartition", partition);
            props.put("IntegrationTime", common.getIntegrationTimeMillis());
            props.put("ROISegment", String.format("Segment%02d", roiLocation.getSegment()));
            props.put("ROIStartCol", roiLocation.getStartCol());
            props.put("ROIStartRow", roiLocation.getStartRow());
            props.put("ROICols", common.getCols());
            props.put("ROIRows", common.getRows());
            props.put("Firmware", String.format("%x", series.getFirmware()));
            props.put("CCDControllerSerial", String.format("%x", series.getSerialNumber() & 0xFFFFFFFFL));
            props.put("DAQVersion", series.getVersion().toString());
            props.put("Platform", series.getPlatform());
            props.put("ROISplit", series.isSplitROI());
            props.put("ROIUnderCols", common.getUnderCols());
            props.put("ROIOverCols", common.getOverCols());
            props.put("ROIOverRows", common.getOverRows());
            props.put("ROIFlushCount", common.getFlushCount());
            props.put("ROICCDType", series.getCcdType());
            props.put("StartTime", state.getTimestamp());
            props.put("DAQSequence", state.getSequence());
            props.put("CCDSlot", rebLocation.getSensorName(sensorLocation.getSensor()));
            props.put("StampCount", 0);
            File computedFileName = fileNamer.computeFileName(props);
            this.finalFileName = props.get("OriginalFileName");
            this.temporaryFileName = computedFileName;
            this.headerSpecifications = headerSpecifications;
            BufferedFile bf = new BufferedFile(computedFileName, "rw");
            this.primary = BasicHDU.getDummyHDU();
            MetaDataSet metaDataSet = new MetaDataSet();
            metaDataSet.addMetaDataMap("primary", props);
            for (FitsHeaderMetadataProvider provider : metaDataProviders) {
                metaDataSet.addMetaDataSet(provider.getPrimaryHeaderMetadata());
            }
            HeaderWriter.addMetaDataToHeader((File)computedFileName, this.primary, (HeaderSpecification)headerSpecifications.get("primary"), (MetaDataSet)metaDataSet);
            FitsCheckSum.setChecksum(this.primary);
            this.primary.write((ArrayDataOutput)bf);
            this.bufferedFile = bf;
            this.properties = props;
        }

        private void fixupStampCount() throws IOException, FitsException {
            if (this.stampCount != this.lastDAQStamp + 1) {
                LOG.log(Level.WARNING, "{2}: DAQ stamp count {0} not equal to number of stamps received {1}", new Object[]{this.lastDAQStamp + 1, this.stampCount, this.obsid});
            }
            Header header = this.primary.getHeader();
            HeaderCard stampsCard = header.findCard("N_STAMPS");
            stampsCard.setValue(this.stampCount);
            FitsCheckSum.setChecksum(this.primary);
            this.bufferedFile.seek(0L);
            this.primary.write((ArrayDataOutput)this.bufferedFile);
        }

        public CompletableFuture<Void> closeAsync() {
            return CompletableFuture.runAsync(() -> {
                try {
                    this.close();
                }
                catch (IOException | FitsException x) {
                    throw new CompletionException(x);
                }
            });
        }

        @Override
        public void close() throws IOException, FitsException {
            long start = System.nanoTime();
            this.fixupStampCount();
            long start2 = System.nanoTime();
            this.bufferedFile.close();
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "Closing file {0} took {1}ns fixupStampCount took {2}ns", new Object[]{this.temporaryFileName, stop - start, start2 - start});
        }

        private void stamp(StateMetaData state, ByteBuffer stamp) throws FitsException, IOException {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("StampTime", state.getTimestamp());
            this.lastDAQStamp = state.getStamp();
            props.put("DAQStamp", state.getStamp());
            props.put("StampCount", ++this.stampCount);
            props.put("ExtName", "IMAGE");
            int[][] intDummyData = new int[1][1];
            BasicHDU imageHDU = FitsFactory.hduFactory((Object)intDummyData);
            Header header = imageHDU.getHeader();
            header.setXtension("IMAGE");
            header.setBitpix(32);
            header.setNaxes(2);
            header.setNaxis(1, ((Integer)this.properties.get("ROICols")).intValue());
            header.setNaxis(2, ((Integer)this.properties.get("ROIRows")).intValue());
            MetaDataSet metaDataSet = new MetaDataSet();
            metaDataSet.addMetaDataMap("stamp", props);
            HeaderWriter.addMetaDataToHeader(null, (BasicHDU)imageHDU, (HeaderSpecification)this.headerSpecifications.get("stamp"), (MetaDataSet)metaDataSet);
            FitsCheckSum.setChecksum((BasicHDU)imageHDU);
            long imageSize = stamp.remaining();
            header.write((ArrayDataOutput)this.bufferedFile);
            this.bufferedFile.getChannel().write(stamp);
            FitsUtil.pad((ArrayDataOutput)this.bufferedFile, (long)imageSize);
        }

        private void rawStamp(StateMetaData state, ByteBuffer rawStamp) throws FitsException, IOException {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("StampTime", state.getTimestamp());
            props.put("DAQStamp", state.getStamp());
            props.put("StampCount", ++this.rawStampCount);
            props.put("ExtName", "RAWSTAMP");
            int[][] intDummyData = new int[1][1];
            BasicHDU binaryTableHDU = FitsFactory.hduFactory((Object)intDummyData);
            Header header = binaryTableHDU.getHeader();
            header.setXtension("BINTABLE");
            header.setBitpix(8);
            header.setNaxes(2);
            header.setNaxis(1, rawStamp.remaining());
            header.setNaxis(2, 1);
            header.addValue("PCOUNT", 0L, "");
            header.addValue("GCOUNT", 1L, "");
            header.addValue("TFIELDS", 1L, "");
            header.addValue("TFORM1", rawStamp.remaining() / 4 + "J", "");
            header.addValue("TTYPE1", "rawStamp", "");
            MetaDataSet metaDataSet = new MetaDataSet();
            metaDataSet.addMetaDataMap("stamp", props);
            HeaderWriter.addMetaDataToHeader(null, (BasicHDU)binaryTableHDU, (HeaderSpecification)this.headerSpecifications.get("stamp"), (MetaDataSet)metaDataSet);
            FitsCheckSum.setChecksum((BasicHDU)binaryTableHDU);
            long imageSize = rawStamp.remaining();
            header.write((ArrayDataOutput)this.bufferedFile);
            this.bufferedFile.getChannel().write(rawStamp);
            FitsUtil.pad((ArrayDataOutput)this.bufferedFile, (long)imageSize);
        }

        public String getImageName() {
            return this.obsid;
        }

        public File getFileName() {
            return this.temporaryFileName;
        }
    }
}

