/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.rice;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.quant.QuantizeProcessor;
import nom.tam.fits.compression.algorithm.rice.BitBuffer;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.algorithm.rice.RiceQuantizeCompressOption;
import nom.tam.util.type.PrimitiveTypes;

public abstract class RiceCompressor<T extends Buffer>
implements ICompressor<T> {
    private static final long UNSIGNED_BYTE_MASK = 255L;
    private static final long UNSIGNED_SHORT_MASK = 65535L;
    private static final long UNSIGNED_INTEGER_MASK = 0xFFFFFFFFL;
    private static final Logger LOG = Logger.getLogger(RiceCompressor.class.getName());
    private static final int BITS_OF_1_BYTE = 8;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTE_MASK = 255;
    private static final int FS_BITS_FOR_BYTE = 3;
    private static final int FS_BITS_FOR_INT = 5;
    private static final int FS_BITS_FOR_SHORT = 4;
    private static final int FS_MAX_FOR_BYTE = 6;
    private static final int FS_MAX_FOR_INT = 25;
    private static final int FS_MAX_FOR_SHORT = 14;
    private static final int[] NONZERO_COUNT = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private final int bBits;
    private final int bitsPerPixel;
    private final int blockSize;
    private final int fsBits;
    private final int fsMax;

    private RiceCompressor(RiceCompressOption option) {
        this.blockSize = option.getBlockSize();
        if (option.getBytePix() == PrimitiveTypes.BYTE.size()) {
            this.fsBits = 3;
            this.fsMax = 6;
            this.bitsPerPixel = 8;
        } else if (option.getBytePix() == PrimitiveTypes.SHORT.size()) {
            this.fsBits = 4;
            this.fsMax = 14;
            this.bitsPerPixel = 16;
        } else if (option.getBytePix() == PrimitiveTypes.INT.size()) {
            this.fsBits = 5;
            this.fsMax = 25;
            this.bitsPerPixel = 32;
        } else {
            throw new UnsupportedOperationException("Rice only supports 1/2/4 type per pixel");
        }
        this.bBits = 1 << this.fsBits;
    }

    private long undoMappingAndDifferencing(long lastpix, long diff) {
        diff = ((diff &= 0xFFFFFFFFL) & 1L) == 0L ? (diff >>>= 1) : diff >>> 1 ^ 0xFFFFFFFFL;
        lastpix = diff + lastpix & 0xFFFFFFFFL;
        this.nextPixel((int)lastpix);
        return lastpix;
    }

    protected void compress(int dataLength, int firstPixel, BitBuffer buffer) {
        int lastpix = firstPixel;
        buffer.putInt(firstPixel, this.bitsPerPixel);
        int thisblock = this.blockSize;
        for (int i = 0; i < dataLength; i += this.blockSize) {
            if (dataLength - i < this.blockSize) {
                thisblock = dataLength - i;
            }
            long[] diff = new long[this.blockSize];
            double pixelsum = 0.0;
            for (int j = 0; j < thisblock; ++j) {
                int nextpix = this.nextPixel();
                long pdiff = nextpix - lastpix;
                diff[j] = (pdiff < 0L ? pdiff << 1 ^ 0xFFFFFFFFL : pdiff << 1) & 0xFFFFFFFFL;
                pixelsum += (double)diff[j];
                lastpix = nextpix;
            }
            double dpsum = (pixelsum - (double)thisblock / 2.0 - 1.0) / (double)thisblock;
            if (dpsum < 0.0) {
                dpsum = 0.0;
            }
            long psum = (long)dpsum >> 1;
            int fs = 0;
            while (psum > 0L) {
                psum >>= 1;
                ++fs;
            }
            if (fs >= this.fsMax) {
                buffer.putInt(this.fsMax + 1, this.fsBits);
                for (int j = 0; j < thisblock; ++j) {
                    buffer.putLong(diff[j], this.bBits);
                }
                continue;
            }
            if (fs == 0 && pixelsum == 0.0) {
                buffer.putInt(0, this.fsBits);
                continue;
            }
            buffer.putInt(fs + 1, this.fsBits);
            int fsmask = (1 << fs) - 1;
            int bitsToGo = buffer.missingBitsInCurrentByte();
            int bitBuffer = buffer.bitbuffer() >> bitsToGo;
            buffer.movePosition(bitsToGo - 8);
            for (int j = 0; j < thisblock; ++j) {
                int v = (int)diff[j];
                int top = v >> fs;
                if (bitsToGo >= top + 1) {
                    bitBuffer <<= top + 1;
                    bitBuffer |= 1;
                    bitsToGo -= top + 1;
                } else {
                    buffer.putByte((byte)((bitBuffer <<= bitsToGo) & 0xFF));
                    top -= bitsToGo;
                    while (top >= 8) {
                        buffer.putByte((byte)0);
                        top -= 8;
                    }
                    bitBuffer = 1;
                    bitsToGo = 7 - top;
                }
                if (fs <= 0) continue;
                bitBuffer <<= fs;
                bitBuffer |= v & fsmask;
                bitsToGo -= fs;
                while (bitsToGo <= 0) {
                    buffer.putByte((byte)(bitBuffer >> -bitsToGo & 0xFF));
                    bitsToGo += 8;
                }
            }
            buffer.putByte((byte)(bitBuffer & 0xFF), 8 - bitsToGo);
        }
        buffer.close();
    }

    protected void decompressBuffer(ByteBuffer readBuffer, int nx) {
        long lastpix = 0L;
        if (this.bitsPerPixel == PrimitiveTypes.BYTE.bitPix()) {
            lastpix = (long)readBuffer.get() & 0xFFL;
        } else if (this.bitsPerPixel == PrimitiveTypes.SHORT.bitPix()) {
            lastpix = (long)readBuffer.getShort() & 0xFFFFL;
        } else if (this.bitsPerPixel == PrimitiveTypes.INT.bitPix()) {
            lastpix = (long)readBuffer.getInt() & 0xFFFFFFFFL;
        }
        long b = readBuffer.get() & 0xFF;
        int nbits = 8;
        int i = 0;
        while (i < nx) {
            nbits -= this.fsBits;
            while (nbits < 0) {
                b = b << 8 | (long)(readBuffer.get() & 0xFF);
                nbits += 8;
            }
            long fs = (b >>> nbits) - 1L;
            b &= (long)((1 << nbits) - 1);
            int imax = i + this.blockSize;
            if (imax > nx) {
                imax = nx;
            }
            if (fs < 0L) {
                while (i < imax) {
                    this.nextPixel((int)lastpix);
                    ++i;
                }
                continue;
            }
            if (fs == (long)this.fsMax) {
                while (i < imax) {
                    int k = this.bBits - nbits;
                    long diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b >>> -k;
                        b &= (long)(1 << nbits) - 1L;
                    } else {
                        b = 0L;
                    }
                    lastpix = this.undoMappingAndDifferencing(lastpix, diff);
                    ++i;
                }
                continue;
            }
            while (i < imax) {
                while (b == 0L) {
                    nbits += 8;
                    b = readBuffer.get() & 0xFF;
                }
                long nzero = nbits - NONZERO_COUNT[(int)(b & 0xFFL)];
                nbits = (int)((long)nbits - (nzero + 1L));
                b ^= (long)(1 << nbits);
                for (nbits = (int)((long)nbits - fs); nbits < 0; nbits += 8) {
                    b = b << 8 | (long)(readBuffer.get() & 0xFF);
                }
                long diff = nzero << (int)fs | b >> nbits;
                b &= (long)(1 << nbits) - 1L;
                lastpix = this.undoMappingAndDifferencing(lastpix, diff);
                ++i;
            }
        }
        if (readBuffer.limit() > readBuffer.position()) {
            LOG.warning("decompressing left over some extra bytes got: " + readBuffer.limit() + " but needed only " + readBuffer.position());
        }
    }

    protected abstract int nextPixel();

    protected abstract void nextPixel(int var1);

    public static class ShortRiceCompressor
    extends RiceCompressor<ShortBuffer> {
        private ShortBuffer pixelBuffer;

        public ShortRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.SHORT.size()));
        }

        @Override
        public boolean compress(ShortBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, ShortBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put((short)pixel);
        }
    }

    public static class IntRiceCompressor
    extends RiceCompressor<IntBuffer> {
        private IntBuffer pixelBuffer;

        public IntRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.INT.size()));
        }

        @Override
        public boolean compress(IntBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, IntBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put(pixel);
        }
    }

    public static class FloatRiceCompressor
    extends QuantizeProcessor.FloatQuantCompressor {
        public FloatRiceCompressor(RiceQuantizeCompressOption options) {
            super(options, new IntRiceCompressor(options.getRiceCompressOption()));
        }
    }

    public static class DoubleRiceCompressor
    extends QuantizeProcessor.DoubleQuantCompressor {
        public DoubleRiceCompressor(RiceQuantizeCompressOption options) {
            super(options, new IntRiceCompressor(options.getRiceCompressOption()));
        }
    }

    public static class ByteRiceCompressor
    extends RiceCompressor<ByteBuffer> {
        private ByteBuffer pixelBuffer;

        public ByteRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.BYTE.size()));
        }

        @Override
        public boolean compress(ByteBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, ByteBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put((byte)pixel);
        }
    }
}

