/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.guider.ROISpec;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;

public class ROISpecTest {
    @Test
    public void testParse() {
        String testData = "{ \"common\": { \"rows\": 50, \"cols\": 100, \"integrationTimeMillis\": 100}, \"R00SG0\": { \"segment\": 10, \"startRow\": 100, \"startCol\": 200},\"R00SG1\": {\"segment\": 7, \"startRow\": 50, \"startCol\": 150} }  ";
        ROISpec spec = ROISpec.parse((String)testData);
        Assert.assertEquals((long)50L, (long)spec.getCommon().getRows());
        Assert.assertEquals((long)100L, (long)spec.getCommon().getCols());
        Assert.assertEquals((long)100L, (long)spec.getCommon().getIntegrationTimeMillis());
        Assert.assertEquals((long)2L, (long)spec.getLocations().size());
        Assert.assertEquals((Object)"R00SG0", (Object)((ROILocation)spec.getLocations().get(0)).getLocation().toString());
        Assert.assertEquals((long)10L, (long)((ROILocation)spec.getLocations().get(0)).getSegment());
    }

    @Test
    public void testToString() {
        ArrayList<ROILocation> locations = new ArrayList<ROILocation>();
        Location R00 = Location.of((String)"R00/RebG");
        SensorLocation sensorLocation0 = new SensorLocation(R00, 0);
        SensorLocation sensorLocation1 = new SensorLocation(R00, 1);
        locations.add(new ROILocation(sensorLocation0, 4, 100, 100));
        locations.add(new ROILocation(sensorLocation1, 5, 200, 200));
        ROICommon common = new ROICommon(50, 50, 100);
        ROISpec spec = new ROISpec(common, locations);
        Assert.assertEquals((Object)"{\"common\":{\"rows\":50,\"cols\":50,\"integrationTimeMillis\":100},\"R00SG0\":{\"segment\":4,\"startRow\":100,\"startCol\":100},\"R00SG1\":{\"segment\":5,\"startRow\":200,\"startCol\":200}}", (Object)spec.toString());
    }
}

