/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;

class XmlWriter {
    private final Writer out_;
    private final int indent_;
    private int iLevel_;
    private static final String ENCODING = "UTF-8";

    public XmlWriter(OutputStream out, int indent) throws IOException {
        this.out_ = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        this.indent_ = indent;
        this.literal("<?xml version='1.0' encoding='UTF-8'?>");
        this.newline();
    }

    public void start(String element) throws IOException {
        this.pad(this.iLevel_++);
        this.out_.write(60);
        this.out_.write(element);
        this.out_.write(62);
        this.newline();
    }

    public void end(String element) throws IOException {
        this.pad(--this.iLevel_);
        this.out_.write("</");
        this.out_.write(element);
        this.out_.write(62);
        this.newline();
    }

    public void inline(String element, String content) throws IOException {
        this.pad(this.iLevel_);
        this.out_.write(60);
        this.out_.write(element);
        this.out_.write(62);
        this.text(content);
        this.out_.write("</");
        this.out_.write(element);
        this.out_.write(62);
        this.newline();
    }

    public void text(String txt) throws IOException {
        int leng = txt.length();
        block5: for (int i = 0; i < leng; ++i) {
            char c = txt.charAt(i);
            switch (c) {
                case '&': {
                    this.out_.write("&amp;");
                    continue block5;
                }
                case '<': {
                    this.out_.write("&lt;");
                    continue block5;
                }
                case '>': {
                    this.out_.write("&gt;");
                    continue block5;
                }
                default: {
                    this.out_.write(c);
                }
            }
        }
    }

    public void literal(String txt) throws IOException {
        this.out_.write(txt);
    }

    public void newline() throws IOException {
        this.out_.write(10);
    }

    public void sampValue(Object value) throws IOException {
        if (value instanceof String) {
            this.inline("value", (String)value);
        } else if (value instanceof List) {
            this.start("value");
            this.start("array");
            this.start("data");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                this.sampValue(it.next());
            }
            this.end("data");
            this.end("array");
            this.end("value");
        } else if (value instanceof Map) {
            this.start("value");
            this.start("struct");
            Iterator it = ((Map)value).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.start("member");
                this.inline("name", entry.getKey().toString());
                this.sampValue(entry.getValue());
                this.end("member");
            }
            this.end("struct");
            this.end("value");
        } else {
            if (value == null) {
                throw new XmlRpcFormatException("Null value not permitted");
            }
            throw new XmlRpcFormatException("Unsupported object type " + value.getClass().getName());
        }
    }

    public void close() throws IOException {
        this.out_.close();
    }

    private void pad(int level) throws IOException {
        int npad = level * this.indent_;
        for (int i = 0; i < npad; ++i) {
            this.out_.write(32);
        }
    }
}

