/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.daq.guider.GuiderListener;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.guider.SeriesMetaData;
import org.lsst.ccs.daq.guider.StateMetaData;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.HeaderWriter;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FitsWriterFactory
implements GuiderListener {
    private final String partition;
    private final FitsIntWriter.FileNamer fileNamer;
    private final Map<String, HeaderSpecification> headerSpecifications;
    private FitsWriter currentFitsFileWriter;

    public FitsWriterFactory(String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications) {
        this.partition = partition;
        this.fileNamer = fileNamer;
        this.headerSpecifications = headerSpecifications;
    }

    protected FitsWriter createFitsFileWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications) throws IOException, FitsException {
        return new FitsWriter(state, series, partition, fileNamer, headerSpecifications, Collections.emptyList());
    }

    @Override
    public void start(StateMetaData state, SeriesMetaData series) throws IOException, FitsException {
        this.currentFitsFileWriter = this.createFitsFileWriter(state, series, this.partition, this.fileNamer, this.headerSpecifications);
    }

    @Override
    public void stop(StateMetaData state) throws IOException, FitsException {
        if (this.currentFitsFileWriter != null) {
            this.currentFitsFileWriter.close();
            this.currentFitsFileWriter = null;
        }
    }

    @Override
    public void pause(StateMetaData state) {
    }

    @Override
    public void resume(StateMetaData state) {
    }

    @Override
    public void stamp(StateMetaData state, ByteBuffer stamp) throws FitsException, IOException {
        if (this.currentFitsFileWriter != null) {
            this.currentFitsFileWriter.stamp(state, stamp);
        }
    }

    @Override
    public void rawStamp(StateMetaData state, ByteBuffer rawStamp) {
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
        FitsFactory.setLongStringsEnabled((boolean)true);
    }

    public static class FitsWriter
    implements AutoCloseable {
        private final BufferedFile bufferedFile;
        private final Map<String, Object> properties;
        private final Map<String, HeaderSpecification> headerSpecifications;
        private final String seriesId;
        private final Object finalFileName;
        private final File temporaryFileName;
        private int stampCount = 0;
        private final BasicHDU<?> primary;

        public FitsWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications, List<FitsHeaderMetadataProvider> metaDataProviders) throws IOException, FitsException {
            this.seriesId = series.getId();
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                ImageName imageName = new ImageName(series.getId());
                props.put("ImageName", imageName.toString());
                props.put("ImageDate", imageName.getDateString());
                props.put("ImageNumber", imageName.getNumberString());
                props.put("ImageController", imageName.getController().getCode());
                props.put("ImageSource", imageName.getSource().getCode());
            }
            catch (IllegalArgumentException x) {
                props.put("ImageName", series.getId());
                props.put("ImageDate", "20230101");
                props.put("ImageNumber", 1);
                props.put("ImageController", "MC");
                props.put("ImageSource", "C");
            }
            ROILocation roiLocation = series.getLocation();
            SensorLocation sensorLocation = roiLocation.getLocation();
            Location rebLocation = sensorLocation.getRebLocation();
            ROICommon common = series.getCommon();
            props.put("FileCreationTime", CCSTimeStamp.currentTime());
            props.put("RaftBay", rebLocation.getRaftName());
            props.put("RebSlot", rebLocation.getBoardName());
            props.put("DAQPartition", partition);
            props.put("IntegrationTime", common.getIntegrationTimeMillis());
            props.put("ROISegment", String.format("Segment%02d", roiLocation.getSegment()));
            props.put("ROICols", common.getCols());
            props.put("ROIRows", common.getRows());
            props.put("Firmware", String.format("%x", series.getFirmware()));
            props.put("CCDControllerSerial", String.format("%x", series.getSerialNumber() & 0xFFFFFFFFL));
            props.put("DAQVersion", series.getVersion().toString());
            props.put("Platform", series.getPlatform());
            props.put("StartTime", state.getTimestamp());
            props.put("DAQSequence", state.getSequence());
            props.put("CCDSlot", rebLocation.getSensorName(sensorLocation.getSensor()));
            props.put("StampCount", 0);
            File computedFileName = fileNamer.computeFileName(props);
            this.finalFileName = props.get("OriginalFileName");
            this.temporaryFileName = computedFileName;
            this.headerSpecifications = headerSpecifications;
            BufferedFile bf = new BufferedFile(computedFileName, "rw");
            this.primary = BasicHDU.getDummyHDU();
            MetaDataSet metaDataSet = new MetaDataSet();
            metaDataSet.addMetaDataMap("primary", props);
            for (FitsHeaderMetadataProvider provider : metaDataProviders) {
                metaDataSet.addMetaDataSet(provider.getPrimaryHeaderMetadata());
            }
            HeaderWriter.addMetaDataToHeader((File)computedFileName, this.primary, (HeaderSpecification)headerSpecifications.get("primary"), (MetaDataSet)metaDataSet);
            FitsCheckSum.setChecksum(this.primary);
            this.primary.write((ArrayDataOutput)bf);
            this.bufferedFile = bf;
            this.properties = props;
        }

        private void fixupStampCount() throws IOException, FitsException {
            Header header = this.primary.getHeader();
            HeaderCard stampsCard = header.findCard("N_STAMPS");
            stampsCard.setValue(this.stampCount);
            FitsCheckSum.setChecksum(this.primary);
            this.bufferedFile.seek(0L);
            this.primary.write((ArrayDataOutput)this.bufferedFile);
        }

        @Override
        public void close() throws IOException, FitsException {
            this.fixupStampCount();
            this.bufferedFile.close();
        }

        private void stamp(StateMetaData state, ByteBuffer stamp) throws FitsException, IOException {
            HashMap<String, Instant> props = new HashMap<String, Instant>();
            props.put("StampTime", state.getTimestamp());
            int[][] intDummyData = new int[1][1];
            BasicHDU imageHDU = FitsFactory.hduFactory((Object)intDummyData);
            Header header = imageHDU.getHeader();
            header.setXtension("IMAGE");
            header.setBitpix(32);
            header.setNaxes(2);
            header.setNaxis(1, ((Integer)this.properties.get("ROIRows")).intValue());
            header.setNaxis(2, ((Integer)this.properties.get("ROICols")).intValue());
            MetaDataSet metaDataSet = new MetaDataSet();
            metaDataSet.addMetaDataMap("stamp", props);
            HeaderWriter.addMetaDataToHeader(null, (BasicHDU)imageHDU, (HeaderSpecification)this.headerSpecifications.get("stamp"), (MetaDataSet)metaDataSet);
            FitsCheckSum.setChecksum((BasicHDU)imageHDU);
            long imageSize = stamp.remaining();
            header.write((ArrayDataOutput)this.bufferedFile);
            this.bufferedFile.getChannel().write(stamp);
            FitsUtil.pad((ArrayDataOutput)this.bufferedFile, (long)imageSize);
            ++this.stampCount;
        }

        public String getImageName() {
            return this.seriesId;
        }

        public File getFileName() {
            return this.temporaryFileName;
        }
    }
}

